/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.mvnpm.importmap.Aggregator;
import io.mvnpm.importmap.model.Imports;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.builder.Version;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsLocalDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.ide.EffectiveIdeBuildItem;
import io.quarkus.deployment.ide.Ide;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.devui.deployment.BuildTimeConstBuildItem;
import io.quarkus.devui.deployment.DeploymentMethodBuildItem;
import io.quarkus.devui.deployment.DevUIConfig;
import io.quarkus.devui.deployment.ExtensionsBuildItem;
import io.quarkus.devui.deployment.InternalImportMapBuildItem;
import io.quarkus.devui.deployment.InternalPageBuildItem;
import io.quarkus.devui.deployment.MvnpmBuildItem;
import io.quarkus.devui.deployment.RelocationImportMapBuildItem;
import io.quarkus.devui.deployment.ThemeVarsBuildItem;
import io.quarkus.devui.deployment.extension.Extension;
import io.quarkus.devui.spi.DevUIContent;
import io.quarkus.devui.spi.buildtime.BuildTimeAction;
import io.quarkus.devui.spi.buildtime.BuildTimeActionBuildItem;
import io.quarkus.devui.spi.buildtime.QuteTemplateBuildItem;
import io.quarkus.devui.spi.buildtime.StaticContentBuildItem;
import io.quarkus.devui.spi.page.AbstractPageBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.FooterPageBuildItem;
import io.quarkus.devui.spi.page.MenuPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.vertx.core.json.jackson.DatabindCodec;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class BuildTimeContentProcessor {
    private static final Logger log = Logger.getLogger(BuildTimeContentProcessor.class);
    private static final String SLASH = "/";
    private static final String BUILD_TIME_PATH = "dev-ui-templates/build-time";
    private static final String ES_MODULE_SHIMS = "es-module-shims";
    final Config config = ConfigProvider.getConfig();
    private static final List<String> LEVELS = List.of(Level.OFF.getName(), Level.SEVERE.getName(), org.jboss.logmanager.Level.ERROR.getName(), org.jboss.logmanager.Level.FATAL.getName(), Level.WARNING.getName(), org.jboss.logmanager.Level.WARN.getName(), org.jboss.logmanager.Level.INFO.getName(), org.jboss.logmanager.Level.DEBUG.getName(), org.jboss.logmanager.Level.TRACE.getName(), Level.CONFIG.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName(), Level.ALL.getName());
    private static final Color QUARKUS_BLUE = Color.from(210, 90, 60);
    private static final Color QUARKUS_RED = Color.from(4, 90, 58);
    private static final Color QUARKUS_DARK = Color.from(0, 0, 13);
    private static final Color QUARKUS_LIGHT = Color.from(0, 0, 100);
    private static final Color QUARKUS_ASSISTANT = Color.from(320, 100, 71);

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    InternalImportMapBuildItem createKnownInternalImportMap(NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        String contextRoot = nonApplicationRootPathBuildItem.getNonApplicationRootPath() + "dev-ui/";
        InternalImportMapBuildItem internalImportMapBuildItem = new InternalImportMapBuildItem();
        internalImportMapBuildItem.add("devui/", contextRoot);
        internalImportMapBuildItem.add("qwc/", contextRoot + "qwc/");
        internalImportMapBuildItem.add("qwc-no-data", contextRoot + "qwc/qwc-no-data.js");
        internalImportMapBuildItem.add("qwc-hot-reload-element", contextRoot + "qwc/qwc-hot-reload-element.js");
        internalImportMapBuildItem.add("qwc-abstract-log-element", contextRoot + "qwc/qwc-abstract-log-element.js");
        internalImportMapBuildItem.add("qwc-server-log", contextRoot + "qwc/qwc-server-log.js");
        internalImportMapBuildItem.add("qwc-footer-log", contextRoot + "qwc/qwc-footer-log.js");
        internalImportMapBuildItem.add("qwc-extension-link", contextRoot + "qwc/qwc-extension-link.js");
        internalImportMapBuildItem.add("qui-ide-link", contextRoot + "qui/qui-ide-link.js");
        internalImportMapBuildItem.add("qui-themed-code-block", contextRoot + "qui/qui-themed-code-block.js");
        internalImportMapBuildItem.add("qui-assistant-warning", contextRoot + "qui/qui-assistant-warning.js");
        internalImportMapBuildItem.add("qui-assistant-button", contextRoot + "qui/qui-assistant-button.js");
        internalImportMapBuildItem.add("echarts/", contextRoot + "echarts/");
        internalImportMapBuildItem.add("echarts-gauge-grade", contextRoot + "echarts/echarts-gauge-grade.js");
        internalImportMapBuildItem.add("echarts-pie", contextRoot + "echarts/echarts-pie.js");
        internalImportMapBuildItem.add("echarts-horizontal-stacked-bar", contextRoot + "echarts/echarts-horizontal-stacked-bar.js");
        internalImportMapBuildItem.add("echarts-force-graph", contextRoot + "echarts/echarts-force-graph.js");
        internalImportMapBuildItem.add("echarts-bar-stack", contextRoot + "echarts/echarts-bar-stack.js");
        internalImportMapBuildItem.add("icon/", contextRoot + "icon/");
        internalImportMapBuildItem.add("controller/", contextRoot + "controller/");
        internalImportMapBuildItem.add("log-controller", contextRoot + "controller/log-controller.js");
        internalImportMapBuildItem.add("storage-controller", contextRoot + "controller/storage-controller.js");
        internalImportMapBuildItem.add("router-controller", contextRoot + "controller/router-controller.js");
        internalImportMapBuildItem.add("notifier", contextRoot + "controller/notifier.js");
        internalImportMapBuildItem.add("jsonrpc", contextRoot + "controller/jsonrpc.js");
        internalImportMapBuildItem.add("state/", contextRoot + "state/");
        internalImportMapBuildItem.add("theme-state", contextRoot + "state/theme-state.js");
        internalImportMapBuildItem.add("connection-state", contextRoot + "state/connection-state.js");
        internalImportMapBuildItem.add("assistant-state", contextRoot + "state/assistant-state.js");
        internalImportMapBuildItem.add("devui-state", contextRoot + "state/devui-state.js");
        return internalImportMapBuildItem;
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    RelocationImportMapBuildItem createRelocationMap() {
        RelocationImportMapBuildItem relocationImportMapBuildItem = new RelocationImportMapBuildItem();
        relocationImportMapBuildItem.add("@quarkus-webcomponents/codeblock/", "@qomponent/qui-code-block/");
        relocationImportMapBuildItem.add("@quarkus-webcomponents/codeblock", "@qomponent/qui-code-block");
        relocationImportMapBuildItem.add("qui-badge", "@qomponent/qui-badge");
        relocationImportMapBuildItem.add("qui/qui-badge.js", "@qomponent/qui-badge");
        relocationImportMapBuildItem.add("qui-alert", "@qomponent/qui-alert");
        relocationImportMapBuildItem.add("qui/qui-alert.js", "@qomponent/qui-alert");
        relocationImportMapBuildItem.add("qui-card", "@qomponent/qui-card");
        relocationImportMapBuildItem.add("qui/qui-card.js", "@qomponent/qui-card");
        return relocationImportMapBuildItem;
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    void mapPageBuildTimeData(List<CardPageBuildItem> cards, List<MenuPageBuildItem> menus, List<FooterPageBuildItem> footers, CurateOutcomeBuildItem curateOutcomeBuildItem, BuildProducer<BuildTimeConstBuildItem> buildTimeConstProducer) {
        Map<String, Object> buildTimeData;
        String extensionPathName;
        for (CardPageBuildItem card : cards) {
            extensionPathName = card.getExtensionPathName(curateOutcomeBuildItem);
            buildTimeData = this.getBuildTimeDataForCard(curateOutcomeBuildItem, card);
            if (buildTimeData.isEmpty()) continue;
            buildTimeConstProducer.produce((BuildItem)new BuildTimeConstBuildItem(extensionPathName, buildTimeData));
        }
        for (MenuPageBuildItem menu : menus) {
            extensionPathName = menu.getExtensionPathName(curateOutcomeBuildItem);
            buildTimeData = this.getBuildTimeDataForPage((AbstractPageBuildItem)menu);
            if (buildTimeData.isEmpty()) continue;
            buildTimeConstProducer.produce((BuildItem)new BuildTimeConstBuildItem(extensionPathName, buildTimeData));
        }
        for (FooterPageBuildItem footer : footers) {
            extensionPathName = footer.getExtensionPathName(curateOutcomeBuildItem);
            buildTimeData = this.getBuildTimeDataForPage((AbstractPageBuildItem)footer);
            if (buildTimeData.isEmpty()) continue;
            buildTimeConstProducer.produce((BuildItem)new BuildTimeConstBuildItem(extensionPathName, buildTimeData));
        }
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    DeploymentMethodBuildItem mapDeploymentMethods(List<BuildTimeActionBuildItem> buildTimeActions, CurateOutcomeBuildItem curateOutcomeBuildItem, Capabilities capabilities) {
        boolean assistantIsAvailable = capabilities.isPresent("io.quarkus.assistant");
        ArrayList<String> methodNames = new ArrayList<String>();
        ArrayList<String> subscriptionNames = new ArrayList<String>();
        HashMap<String, RuntimeValue> recordedValues = new HashMap<String, RuntimeValue>();
        for (BuildTimeActionBuildItem actions : buildTimeActions) {
            String fullName;
            String extensionPathName = actions.getExtensionPathName(curateOutcomeBuildItem);
            for (BuildTimeAction bta : actions.getActions()) {
                fullName = extensionPathName + "." + bta.getMethodName();
                if (bta.hasRuntimeValue()) {
                    recordedValues.put(fullName, bta.getRuntimeValue());
                    methodNames.add(fullName);
                    continue;
                }
                if (bta.hasAction()) {
                    DevConsoleManager.register((String)fullName, (Function)bta.getAction());
                    methodNames.add(fullName);
                    continue;
                }
                if (!bta.hasAssistantAction() || !assistantIsAvailable) continue;
                DevConsoleManager.register((String)fullName, (BiFunction)bta.getAssistantAction());
                methodNames.add(fullName);
            }
            for (BuildTimeAction bts : actions.getSubscriptions()) {
                fullName = extensionPathName + "." + bts.getMethodName();
                if (bts.hasRuntimeValue()) {
                    recordedValues.put(fullName, bts.getRuntimeValue());
                    subscriptionNames.add(fullName);
                    continue;
                }
                if (bts.hasAction()) {
                    DevConsoleManager.register((String)fullName, (Function)bts.getAction());
                    subscriptionNames.add(fullName);
                    continue;
                }
                if (!bts.hasAssistantAction() || !assistantIsAvailable) continue;
                DevConsoleManager.register((String)fullName, (BiFunction)bts.getAssistantAction());
                subscriptionNames.add(fullName);
            }
        }
        return new DeploymentMethodBuildItem(methodNames, subscriptionNames, recordedValues);
    }

    private Map<String, Object> getBuildTimeDataForPage(AbstractPageBuildItem pageBuildItem) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (pageBuildItem.hasBuildTimeData()) {
            m.putAll(pageBuildItem.getBuildTimeData());
        }
        return m;
    }

    private Map<String, Object> getBuildTimeDataForCard(CurateOutcomeBuildItem curateOutcomeBuildItem, CardPageBuildItem pageBuildItem) {
        Map<String, Object> m = this.getBuildTimeDataForPage((AbstractPageBuildItem)pageBuildItem);
        if (pageBuildItem.getOptionalCard().isPresent()) {
            ArrayList<Page> pages = new ArrayList<Page>();
            List pageBuilders = pageBuildItem.getPages();
            for (PageBuilder pageBuilder : pageBuilders) {
                String path = pageBuildItem.getExtensionPathName(curateOutcomeBuildItem);
                pageBuilder.namespace(path);
                pageBuilder.extension(path);
                pages.add(pageBuilder.build());
            }
            m.put("pages", pages);
        }
        return m;
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    void createBuildTimeConstJsTemplate(CurateOutcomeBuildItem curateOutcomeBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, List<BuildTimeConstBuildItem> buildTimeConstBuildItems, BuildProducer<QuteTemplateBuildItem> quteTemplateProducer, BuildProducer<InternalImportMapBuildItem> internalImportMapProducer) {
        String contextRoot = nonApplicationRootPathBuildItem.getNonApplicationRootPath() + "dev-ui/";
        QuteTemplateBuildItem quteTemplateBuildItem = new QuteTemplateBuildItem("devui");
        InternalImportMapBuildItem internalImportMapBuildItem = new InternalImportMapBuildItem();
        ObjectWriter mapper = DatabindCodec.mapper().writerWithDefaultPrettyPrinter();
        for (BuildTimeConstBuildItem buildTimeConstBuildItem : buildTimeConstBuildItems) {
            HashMap<String, String> data = new HashMap<String, String>();
            if (buildTimeConstBuildItem.hasBuildTimeData()) {
                for (Map.Entry<String, Object> pageData : buildTimeConstBuildItem.getBuildTimeData().entrySet()) {
                    try {
                        String key = pageData.getKey();
                        String value = mapper.writeValueAsString(pageData.getValue());
                        data.put(key, value);
                    }
                    catch (JsonProcessingException ex) {
                        log.error((Object)"Could not create Json Data for Dev UI page", (Throwable)ex);
                    }
                }
            }
            if (data.isEmpty()) continue;
            HashMap<String, HashMap<String, String>> qutedata = new HashMap<String, HashMap<String, String>>();
            qutedata.put("buildTimeData", data);
            String ref = buildTimeConstBuildItem.getExtensionPathName(curateOutcomeBuildItem) + "-data";
            String file = ref + ".js";
            quteTemplateBuildItem.add("build-time-data.js", file, qutedata);
            internalImportMapBuildItem.add(ref, contextRoot + file);
        }
        quteTemplateProducer.produce((BuildItem)quteTemplateBuildItem);
        internalImportMapProducer.produce((BuildItem)internalImportMapBuildItem);
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    void gatherMvnpmJars(BuildProducer<MvnpmBuildItem> mvnpmProducer, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        HashSet<URL> mvnpmJars = new HashSet<URL>();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> jarsWithImportMaps = tccl.getResources("META-INF/importmap.json");
            while (jarsWithImportMaps.hasMoreElements()) {
                URL jarUrl = jarsWithImportMaps.nextElement();
                JarURLConnection connection = (JarURLConnection)jarUrl.openConnection();
                mvnpmJars.add(connection.getJarFileURL());
            }
            mvnpmProducer.produce((BuildItem)new MvnpmBuildItem(mvnpmJars));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    QuteTemplateBuildItem createIndexHtmlTemplate(MvnpmBuildItem mvnpmBuildItem, ThemeVarsBuildItem themeVarsBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, List<InternalImportMapBuildItem> internalImportMapBuildItems, RelocationImportMapBuildItem relocationImportMapBuildItem) {
        QuteTemplateBuildItem quteTemplateBuildItem = new QuteTemplateBuildItem("devui");
        Aggregator aggregator = new Aggregator(mvnpmBuildItem.getMvnpmJars());
        for (InternalImportMapBuildItem importMapBuildItem : internalImportMapBuildItems) {
            Map<String, String> importMap = importMapBuildItem.getImportMap();
            aggregator.addMappings(importMap);
        }
        Imports imports = aggregator.aggregate(nonApplicationRootPathBuildItem.getNonApplicationRootPath(), false);
        Map currentImportMap = imports.getImports();
        Map<String, String> relocationMap = relocationImportMapBuildItem.getRelocationMap();
        for (Map.Entry<String, String> relocation : relocationMap.entrySet()) {
            String from = relocation.getKey();
            String to = relocation.getValue();
            if (currentImportMap.containsKey(to)) {
                String newTo = (String)currentImportMap.get(to);
                currentImportMap.put(from, newTo);
                continue;
            }
            log.warn((Object)("Could not relocate " + from + " as " + to + " does not exist in the importmap"));
        }
        String esModuleShimsVersion = this.extractEsModuleShimsVersion(mvnpmBuildItem.getMvnpmJars());
        String importmap = aggregator.aggregateAsJson(imports);
        aggregator.reset();
        String themeVars = themeVarsBuildItem.getTemplateValue();
        String nonApplicationRoot = nonApplicationRootPathBuildItem.getNonApplicationRootPath();
        String contextRoot = nonApplicationRoot + "dev-ui/";
        Map<String, String> data = Map.of("nonApplicationRoot", nonApplicationRoot, "contextRoot", contextRoot, "importmap", importmap, "themeVars", themeVars, "esModuleShimsVersion", esModuleShimsVersion);
        quteTemplateBuildItem.add("index.html", data);
        return quteTemplateBuildItem;
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    void loadAllBuildTimeTemplates(BuildProducer<StaticContentBuildItem> buildTimeContentProducer, List<QuteTemplateBuildItem> templates) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (QuteTemplateBuildItem template : templates) {
            ArrayList<DevUIContent> contentPerExtension = new ArrayList<DevUIContent>();
            List templatesWithData = template.getTemplateDatas();
            for (QuteTemplateBuildItem.TemplateData e : templatesWithData) {
                String templateName = e.getTemplateName();
                Map data = e.getData();
                String resourceName = "dev-ui-templates/build-time/" + templateName;
                String fileName = e.getFileName();
                try {
                    InputStream templateStream = cl.getResourceAsStream(resourceName);
                    try {
                        if (templateStream == null) continue;
                        byte[] templateContent = IoUtil.readBytes((InputStream)templateStream);
                        DevUIContent content = DevUIContent.builder().fileName(fileName).template(templateContent).addData(data).build();
                        contentPerExtension.add(content);
                    }
                    finally {
                        if (templateStream == null) continue;
                        templateStream.close();
                    }
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException("An error occurred while processing " + resourceName, ioe);
                }
            }
            buildTimeContentProducer.produce((BuildItem)new StaticContentBuildItem("devui", contentPerExtension));
        }
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    void createBuildTimeData(BuildProducer<BuildTimeConstBuildItem> buildTimeConstProducer, BuildProducer<ThemeVarsBuildItem> themeVarsProducer, CurateOutcomeBuildItem curateOutcomeBuildItem, List<InternalPageBuildItem> internalPages, ExtensionsBuildItem extensionsBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, LaunchModeBuildItem launchModeBuildItem, Optional<EffectiveIdeBuildItem> effectiveIdeBuildItem, DevUIConfig devUIConfig) {
        BuildTimeConstBuildItem internalBuildTimeData = new BuildTimeConstBuildItem("devui");
        this.addThemeBuildTimeData(internalBuildTimeData, devUIConfig, themeVarsProducer);
        this.addMenuSectionBuildTimeData(internalBuildTimeData, internalPages, extensionsBuildItem);
        this.addFooterTabBuildTimeData(internalBuildTimeData, extensionsBuildItem, devUIConfig);
        this.addApplicationInfoBuildTimeData(internalBuildTimeData, curateOutcomeBuildItem, nonApplicationRootPathBuildItem);
        this.addIdeBuildTimeData(internalBuildTimeData, effectiveIdeBuildItem, launchModeBuildItem);
        buildTimeConstProducer.produce((BuildItem)internalBuildTimeData);
    }

    private String extractEsModuleShimsVersion(Set<URL> urls) {
        for (URL u : urls) {
            if (!u.getPath().contains(ES_MODULE_SHIMS)) continue;
            int i = u.getPath().indexOf(ES_MODULE_SHIMS) + ES_MODULE_SHIMS.length() + 1;
            String versionOnward = u.getPath().substring(i);
            String[] parts = versionOnward.split(SLASH);
            return parts[0];
        }
        return "";
    }

    private void addThemeBuildTimeData(BuildTimeConstBuildItem internalBuildTimeData, DevUIConfig devUIConfig, BuildProducer<ThemeVarsBuildItem> themeVarsProducer) {
        HashMap<String, Map<String, String>> themes = new HashMap<String, Map<String, String>>();
        HashMap<String, String> dark = new HashMap<String, String>();
        HashMap<String, String> light = new HashMap<String, String>();
        switch (devUIConfig.baseTheme()) {
            case red: {
                BuildTimeContentProcessor.computeRedColors(themes, dark, light, devUIConfig.theme());
                break;
            }
            case blue: {
                BuildTimeContentProcessor.computeBlueColors(themes, dark, light, devUIConfig.theme());
                break;
            }
            default: {
                BuildTimeContentProcessor.computeDefaultColors(themes, dark, light, devUIConfig.theme());
            }
        }
        internalBuildTimeData.addBuildTimeData("themes", themes);
        themeVarsProducer.produce((BuildItem)new ThemeVarsBuildItem(light.keySet(), QUARKUS_BLUE.toString()));
    }

    private void addMenuSectionBuildTimeData(BuildTimeConstBuildItem internalBuildTimeData, List<InternalPageBuildItem> internalPages, ExtensionsBuildItem extensionsBuildItem) {
        ArrayList<Page> sectionMenu = new ArrayList<Page>();
        Collections.sort(internalPages, (t, t1) -> Integer.valueOf(t.getPosition()).compareTo(t1.getPosition()));
        for (InternalPageBuildItem internalPageBuildItem : internalPages) {
            List<Page> pages = internalPageBuildItem.getPages();
            for (Page page : pages) {
                if (internalPageBuildItem.getMenuActionComponent() != null) {
                    page.setMenuActionComponent(internalPageBuildItem.getMenuActionComponent());
                }
                sectionMenu.add(page);
            }
            internalBuildTimeData.addAllBuildTimeData(internalPageBuildItem.getBuildTimeData());
        }
        for (Extension e : extensionsBuildItem.getSectionMenuExtensions()) {
            List<Page> pagesFromExtension = e.getMenuPages();
            sectionMenu.addAll(pagesFromExtension);
        }
        internalBuildTimeData.addBuildTimeData("menuItems", sectionMenu);
    }

    private void addFooterTabBuildTimeData(BuildTimeConstBuildItem internalBuildTimeData, ExtensionsBuildItem extensionsBuildItem, DevUIConfig devUIConfig) {
        ArrayList<Page> footerTabs = new ArrayList<Page>();
        Page serverLog = ((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().internal()).namespace("devui-logstream")).title("Server")).icon("font-awesome-solid:server")).componentLink("qwc-server-log.js").build();
        footerTabs.add(serverLog);
        Page testLog = ((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().internal()).namespace("devui-continuous-testing")).title("Testing")).icon("font-awesome-solid:flask-vial")).componentLink("qwc-test-log.js").build();
        footerTabs.add(testLog);
        if (Version.getVersion().equalsIgnoreCase("999-SNAPSHOT") || devUIConfig.showJsonRpcLog()) {
            Page devUiLog = ((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().internal()).namespace("devui-jsonrpcstream")).title("Dev UI")).icon("font-awesome-solid:satellite-dish")).componentLink("qwc-jsonrpc-messages.js").build();
            footerTabs.add(devUiLog);
        }
        for (Extension e : extensionsBuildItem.getFooterTabsExtensions()) {
            List<Page> tabsFromExtension = e.getFooterPages();
            footerTabs.addAll(tabsFromExtension);
        }
        internalBuildTimeData.addBuildTimeData("footerTabs", footerTabs);
        internalBuildTimeData.addBuildTimeData("loggerLevels", LEVELS);
    }

    private void addApplicationInfoBuildTimeData(BuildTimeConstBuildItem internalBuildTimeData, CurateOutcomeBuildItem curateOutcomeBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        HashMap<String, Object> applicationInfo = new HashMap<String, Object>();
        ApplicationModel applicationModel = curateOutcomeBuildItem.getApplicationModel();
        ResolvedDependency appArtifact = applicationModel.getAppArtifact();
        String groupId = appArtifact.getGroupId();
        applicationInfo.put("groupId", groupId);
        String artifactId = appArtifact.getArtifactId();
        applicationInfo.put("artifactId", artifactId);
        String contextRoot = nonApplicationRootPathBuildItem.getNonApplicationRootPath() + "dev-ui/";
        applicationInfo.put("contextRoot", contextRoot);
        applicationInfo.put("quarkusVersion", Version.getVersion());
        applicationInfo.put("applicationName", this.config.getOptionalValue("quarkus.application.name", String.class).orElse(""));
        applicationInfo.put("applicationVersion", this.config.getOptionalValue("quarkus.application.version", String.class).orElse(""));
        internalBuildTimeData.addBuildTimeData("applicationInfo", applicationInfo);
    }

    private void addIdeBuildTimeData(BuildTimeConstBuildItem internalBuildTimeData, Optional<EffectiveIdeBuildItem> effectiveIdeBuildItem, LaunchModeBuildItem launchModeBuildItem) {
        HashMap<String, Object> ideInfo = new HashMap<String, Object>();
        boolean disable = launchModeBuildItem.getDevModeType().orElse(DevModeType.LOCAL) != DevModeType.LOCAL;
        ideInfo.put("disable", disable);
        if (effectiveIdeBuildItem.isPresent()) {
            EffectiveIdeBuildItem eibi = effectiveIdeBuildItem.get();
            if (!disable) {
                Ide ide = eibi.getIde();
                ideInfo.put("ideName", ide.name());
                ideInfo.put("idePackages", this.getAllUserPackages());
            }
        }
        internalBuildTimeData.addBuildTimeData("ideInfo", ideInfo);
    }

    private List<String> getAllUserPackages() {
        List sourcesDir = DevConsoleManager.getHotReplacementContext().getSourcesDir();
        ArrayList<String> packages = new ArrayList<String>();
        for (Path sourcePaths : sourcesDir) {
            packages.addAll(this.sourcePackagesForRoot(sourcePaths));
        }
        return packages;
    }

    private List<String> sourcePackagesForRoot(Path langPath) {
        if (!Files.exists(langPath, new LinkOption[0])) {
            return Collections.emptyList();
        }
        File[] rootFiles = langPath.toFile().listFiles();
        ArrayList<Path> rootPackages = new ArrayList<Path>(1);
        if (rootFiles != null) {
            for (File rootFile : rootFiles) {
                if (!rootFile.isDirectory()) continue;
                rootPackages.add(rootFile.toPath());
            }
        }
        if (rootPackages.isEmpty()) {
            return List.of("");
        }
        ArrayList<String> result = new ArrayList<String>(rootPackages.size());
        for (Path rootPackage : rootPackages) {
            ArrayList<String> paths = new ArrayList<String>();
            DetectPackageFileVisitor simpleFileVisitor = new DetectPackageFileVisitor(paths);
            try {
                Files.walkFileTree(rootPackage, simpleFileVisitor);
                if (paths.isEmpty()) continue;
                String commonPath = this.commonPath(paths);
                String rootPackageStr = commonPath.replace(langPath.toAbsolutePath().toString(), "").replace(File.separator, ".");
                if (rootPackageStr.startsWith(".")) {
                    rootPackageStr = rootPackageStr.substring(1);
                }
                if (rootPackageStr.endsWith(".")) {
                    rootPackageStr = rootPackageStr.substring(0, rootPackageStr.length() - 1);
                }
                result.add(rootPackageStr);
            }
            catch (IOException e) {
                log.debug((Object)"Unable to determine the sources directories", (Throwable)e);
            }
        }
        return result;
    }

    private String commonPath(List<String> paths) {
        Object commonPath = "";
        ArrayList<String[]> dirs = new ArrayList<String[]>(paths.size());
        for (int i = 0; i < paths.size(); ++i) {
            dirs.add(i, paths.get(i).split(Pattern.quote(File.separator)));
        }
        for (int j = 0; j < ((String[])dirs.get(0)).length; ++j) {
            String thisDir = ((String[])dirs.get(0))[j];
            boolean allMatched = true;
            for (int i = 1; i < dirs.size() && allMatched; ++i) {
                if (((String[])dirs.get(i)).length < j) {
                    allMatched = false;
                    break;
                }
                allMatched = ((String[])dirs.get(i))[j].equals(thisDir);
            }
            if (!allMatched) break;
            commonPath = (String)commonPath + thisDir + File.separator;
        }
        return commonPath;
    }

    private static void addQuarkusLogoColors(Map<String, String> dark, Map<String, String> light) {
        light.put("--quarkus-blue", QUARKUS_BLUE.toString());
        dark.put("--quarkus-blue", QUARKUS_BLUE.toString());
        light.put("--quarkus-red", QUARKUS_RED.toString());
        dark.put("--quarkus-red", QUARKUS_RED.toString());
        light.put("--quarkus-center", QUARKUS_DARK.toString());
        dark.put("--quarkus-center", QUARKUS_LIGHT.toString());
        light.put("--quarkus-assistant", QUARKUS_ASSISTANT.toString());
        dark.put("--quarkus-assistant", QUARKUS_ASSISTANT.toString());
    }

    private static void computeDefaultColors(Map<String, Map<String, String>> themes, Map<String, String> dark, Map<String, String> light, Optional<DevUIConfig.Theme> theme) {
        BuildTimeContentProcessor.addQuarkusLogoColors(dark, light);
        light.put("--lumo-base-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::baseColor, Color.from(0, 0, 100).toString()));
        dark.put("--lumo-base-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::baseColor, Color.from(0, 0, 13).toString()));
        light.put("--lumo-contrast", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::contrast, Color.from(0, 0, 13).toString()));
        dark.put("--lumo-contrast", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::contrast, Color.from(0, 0, 100).toString()));
        light.put("--lumo-primary-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::primaryColor, QUARKUS_BLUE.toString()));
        dark.put("--lumo-primary-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::primaryColor, QUARKUS_BLUE.toString()));
        light.put("--lumo-primary-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::primaryTextColor, Color.from(210, 90, 60).toString()));
        dark.put("--lumo-primary-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::primaryTextColor, Color.from(210, 90, 60).toString()));
        light.put("--lumo-primary-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::primaryContrastColor, Color.from(0, 0, 100).toString()));
        dark.put("--lumo-primary-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::primaryContrastColor, Color.from(0, 0, 100).toString()));
        light.put("--lumo-error-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::errorTextColor, QUARKUS_RED.toString()));
        dark.put("--lumo-error-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::errorTextColor, QUARKUS_RED.toString()));
        light.put("--lumo-error-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::errorTextColor, Color.from(3, 90, 42).toString()));
        dark.put("--lumo-error-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::errorTextColor, Color.from(3, 90, 63).toString()));
        light.put("--lumo-error-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::errorContrastColor, Color.from(0, 0, 100).toString()));
        dark.put("--lumo-error-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::errorContrastColor, Color.from(0, 0, 100).toString()));
        light.put("--lumo-warning-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::warningColor, Color.from(30, 100, 50).toString()));
        dark.put("--lumo-warning-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::warningColor, Color.from(30, 100, 50).toString()));
        light.put("--lumo-warning-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::warningTextColor, Color.from(30, 89, 42).toString()));
        dark.put("--lumo-warning-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::warningTextColor, Color.from(30, 100, 67).toString()));
        light.put("--lumo-warning-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::warningContrastColor, Color.from(0, 0, 100).toString()));
        dark.put("--lumo-warning-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::warningContrastColor, Color.from(0, 0, 100).toString()));
        light.put("--lumo-success-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::successColor, Color.from(145, 72, 30).toString()));
        dark.put("--lumo-success-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::successColor, Color.from(145, 65, 42).toString()));
        light.put("--lumo-success-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::successTextColor, Color.from(145, 85, 25).toString()));
        dark.put("--lumo-success-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::successTextColor, Color.from(145, 85, 47).toString()));
        light.put("--lumo-success-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 100).toString()));
        dark.put("--lumo-success-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 100).toString()));
        light.put("--lumo-header-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::headerTextColor, Color.from(0, 0, 13).toString()));
        dark.put("--lumo-header-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::headerTextColor, Color.from(0, 0, 100).toString()));
        light.put("--lumo-body-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::bodyTextColor, Color.from(0, 0, 20, 0.94).toString()));
        dark.put("--lumo-body-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::bodyTextColor, Color.from(0, 0, 90, 0.9).toString()));
        light.put("--lumo-secondary-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::secondaryTextColor, Color.from(0, 0, 40, 0.69).toString()));
        dark.put("--lumo-secondary-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::secondaryTextColor, Color.from(0, 0, 70, 0.7).toString()));
        light.put("--lumo-tertiary-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::tertiaryTextColor, Color.from(0, 0, 50, 0.52).toString()));
        dark.put("--lumo-tertiary-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::tertiaryTextColor, Color.from(0, 0, 60, 0.5).toString()));
        light.put("--lumo-disabled-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::disabledTextColor, Color.from(0, 0, 60, 0.26).toString()));
        dark.put("--lumo-disabled-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::disabledTextColor, Color.from(0, 0, 50, 0.32).toString()));
        for (int i = 5; i <= 90; i += 5) {
            double opacity = (double)i / 100.0;
            String key = "--lumo-contrast-" + i + "pct";
            String lightContrast = BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, BuildTimeContentProcessor.getContrastPct(i), Color.from(0, 0, 13, opacity).toString());
            String darkContrast = BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, BuildTimeContentProcessor.getContrastPct(i), Color.from(0, 0, 100, opacity).toString());
            light.put(key, lightContrast);
            dark.put(key, darkContrast);
        }
        themes.put("dark", dark);
        themes.put("light", light);
    }

    private static void computeRedColors(Map<String, Map<String, String>> themes, Map<String, String> dark, Map<String, String> light, Optional<DevUIConfig.Theme> theme) {
        BuildTimeContentProcessor.addQuarkusLogoColors(dark, light);
        light.put("--lumo-base-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::baseColor, Color.from(0, 0, 100).toString()));
        dark.put("--lumo-base-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::baseColor, Color.from(0, 0, 10).toString()));
        light.put("--lumo-contrast", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::contrast, Color.from(0, 0, 10).toString()));
        dark.put("--lumo-contrast", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::contrast, Color.from(0, 0, 100).toString()));
        light.put("--lumo-primary-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::primaryColor, Color.from(0, 100, 47).toString()));
        dark.put("--lumo-primary-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::primaryColor, Color.from(0, 100, 47).toString()));
        light.put("--lumo-primary-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::primaryTextColor, Color.from(0, 100, 47).toString()));
        dark.put("--lumo-primary-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::primaryTextColor, Color.from(0, 100, 47).toString()));
        light.put("--lumo-primary-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::primaryContrastColor, Color.from(0, 0, 100).toString()));
        dark.put("--lumo-primary-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::primaryContrastColor, Color.from(0, 0, 100).toString()));
        light.put("--lumo-error-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::errorColor, Color.from(0, 100, 47).toString()));
        dark.put("--lumo-error-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::errorColor, Color.from(0, 100, 47).toString()));
        light.put("--lumo-error-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::errorTextColor, Color.from(0, 100, 40).toString()));
        dark.put("--lumo-error-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::errorTextColor, Color.from(0, 100, 55).toString()));
        light.put("--lumo-error-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::errorContrastColor, Color.from(0, 0, 100).toString()));
        dark.put("--lumo-error-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::errorContrastColor, Color.from(0, 0, 100).toString()));
        light.put("--lumo-warning-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::warningColor, Color.from(0, 0, 96).toString()));
        dark.put("--lumo-warning-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::warningColor, Color.from(0, 0, 96).toString()));
        light.put("--lumo-warning-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::warningTextColor, Color.from(0, 0, 80).toString()));
        dark.put("--lumo-warning-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::warningTextColor, Color.from(0, 0, 85).toString()));
        light.put("--lumo-warning-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::warningContrastColor, Color.from(0, 0, 100).toString()));
        dark.put("--lumo-warning-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::warningContrastColor, Color.from(0, 0, 100).toString()));
        light.put("--lumo-success-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::successColor, Color.from(207, 100, 25).toString()));
        dark.put("--lumo-success-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::successColor, Color.from(207, 100, 25).toString()));
        light.put("--lumo-success-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::successTextColor, Color.from(207, 100, 30).toString()));
        dark.put("--lumo-success-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::successTextColor, Color.from(207, 100, 35).toString()));
        light.put("--lumo-success-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 100).toString()));
        dark.put("--lumo-success-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 100).toString()));
        light.put("--lumo-header-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 10).toString()));
        dark.put("--lumo-header-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 100).toString()));
        light.put("--lumo-body-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 20, 0.94).toString()));
        dark.put("--lumo-body-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 90, 0.9).toString()));
        light.put("--lumo-secondary-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 40, 0.69).toString()));
        dark.put("--lumo-secondary-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 70, 0.7).toString()));
        light.put("--lumo-tertiary-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 50, 0.52).toString()));
        dark.put("--lumo-tertiary-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 60, 0.5).toString()));
        light.put("--lumo-disabled-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 60, 0.26).toString()));
        dark.put("--lumo-disabled-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 50, 0.32).toString()));
        for (int i = 5; i <= 90; i += 5) {
            double opacity = (double)i / 100.0;
            String key = "--lumo-contrast-" + i + "pct";
            String lightContrast = BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, BuildTimeContentProcessor.getContrastPct(i), Color.from(0, 0, 10, opacity).toString());
            String darkContrast = BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, BuildTimeContentProcessor.getContrastPct(i), Color.from(0, 0, 100, opacity).toString());
            light.put(key, lightContrast);
            dark.put(key, darkContrast);
        }
        themes.put("dark", dark);
        themes.put("light", light);
    }

    private static void computeBlueColors(Map<String, Map<String, String>> themes, Map<String, String> dark, Map<String, String> light, Optional<DevUIConfig.Theme> theme) {
        BuildTimeContentProcessor.addQuarkusLogoColors(dark, light);
        light.put("--lumo-base-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::baseColor, Color.from(0, 0, 100).toString()));
        dark.put("--lumo-base-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::baseColor, Color.from(0, 0, 9).toString()));
        light.put("--lumo-contrast", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::contrast, Color.from(0, 0, 9).toString()));
        dark.put("--lumo-contrast", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::contrast, Color.from(0, 0, 100).toString()));
        light.put("--lumo-primary-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::primaryColor, Color.from(212, 90, 20).toString()));
        dark.put("--lumo-primary-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::primaryColor, Color.from(212, 90, 20).toString()));
        light.put("--lumo-primary-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::primaryTextColor, Color.from(212, 90, 20).toString()));
        dark.put("--lumo-primary-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::primaryTextColor, Color.from(212, 53, 48).toString()));
        light.put("--lumo-primary-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::primaryContrastColor, Color.from(0, 0, 100).toString()));
        dark.put("--lumo-primary-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::primaryContrastColor, Color.from(0, 0, 100).toString()));
        light.put("--lumo-error-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::errorColor, Color.from(212, 90, 20).toString()));
        dark.put("--lumo-error-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::errorColor, Color.from(212, 90, 20).toString()));
        light.put("--lumo-error-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::errorTextColor, Color.from(212, 90, 30).toString()));
        dark.put("--lumo-error-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::errorTextColor, Color.from(212, 90, 40).toString()));
        light.put("--lumo-error-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::errorContrastColor, Color.from(0, 0, 100).toString()));
        dark.put("--lumo-error-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::errorContrastColor, Color.from(0, 0, 100).toString()));
        light.put("--lumo-warning-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::warningColor, Color.from(0, 0, 96).toString()));
        dark.put("--lumo-warning-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::warningColor, Color.from(0, 0, 96).toString()));
        light.put("--lumo-warning-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::warningTextColor, Color.from(0, 0, 80).toString()));
        dark.put("--lumo-warning-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::warningTextColor, Color.from(0, 0, 85).toString()));
        light.put("--lumo-warning-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::warningContrastColor, Color.from(0, 0, 100).toString()));
        dark.put("--lumo-warning-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::warningContrastColor, Color.from(0, 0, 100).toString()));
        light.put("--lumo-success-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::successColor, Color.from(214, 49, 50).toString()));
        dark.put("--lumo-success-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::successColor, Color.from(214, 49, 50).toString()));
        light.put("--lumo-success-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::successTextColor, Color.from(214, 49, 55).toString()));
        dark.put("--lumo-success-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::successTextColor, Color.from(214, 49, 60).toString()));
        light.put("--lumo-success-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 100).toString()));
        dark.put("--lumo-success-contrast-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 100).toString()));
        light.put("--lumo-header-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 9).toString()));
        dark.put("--lumo-header-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 100).toString()));
        light.put("--lumo-body-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 20, 0.94).toString()));
        dark.put("--lumo-body-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 90, 0.9).toString()));
        light.put("--lumo-secondary-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 40, 0.69).toString()));
        dark.put("--lumo-secondary-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 70, 0.7).toString()));
        light.put("--lumo-tertiary-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 50, 0.52).toString()));
        dark.put("--lumo-tertiary-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 60, 0.5).toString()));
        light.put("--lumo-disabled-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 60, 0.26).toString()));
        dark.put("--lumo-disabled-text-color", BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, DevUIConfig.ThemeMode::successContrastColor, Color.from(0, 0, 50, 0.32).toString()));
        for (int i = 5; i <= 90; i += 5) {
            double opacity = (double)i / 100.0;
            String key = "--lumo-contrast-" + i + "pct";
            String lightContrast = BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::light, BuildTimeContentProcessor.getContrastPct(i), Color.from(0, 0, 10, opacity).toString());
            String darkContrast = BuildTimeContentProcessor.getThemeSettingOrDefault(theme, DevUIConfig.Theme::dark, BuildTimeContentProcessor.getContrastPct(i), Color.from(0, 0, 100, opacity).toString());
            light.put(key, lightContrast);
            dark.put(key, darkContrast);
        }
        themes.put("dark", dark);
        themes.put("light", light);
    }

    private static Function<DevUIConfig.ThemeMode, Optional<String>> getContrastPct(int percentage) {
        return switch (percentage) {
            case 5 -> DevUIConfig.ThemeMode::contrast5pct;
            case 10 -> DevUIConfig.ThemeMode::contrast10pct;
            case 15 -> DevUIConfig.ThemeMode::contrast15pct;
            case 20 -> DevUIConfig.ThemeMode::contrast20pct;
            case 25 -> DevUIConfig.ThemeMode::contrast25pct;
            case 30 -> DevUIConfig.ThemeMode::contrast30pct;
            case 35 -> DevUIConfig.ThemeMode::contrast35pct;
            case 40 -> DevUIConfig.ThemeMode::contrast40pct;
            case 45 -> DevUIConfig.ThemeMode::contrast45pct;
            case 50 -> DevUIConfig.ThemeMode::contrast50pct;
            case 55 -> DevUIConfig.ThemeMode::contrast55pct;
            case 60 -> DevUIConfig.ThemeMode::contrast60pct;
            case 65 -> DevUIConfig.ThemeMode::contrast65pct;
            case 70 -> DevUIConfig.ThemeMode::contrast70pct;
            case 75 -> DevUIConfig.ThemeMode::contrast75pct;
            case 80 -> DevUIConfig.ThemeMode::contrast80pct;
            case 85 -> DevUIConfig.ThemeMode::contrast85pct;
            case 90 -> DevUIConfig.ThemeMode::contrast90pct;
            default -> mode -> Optional.empty();
        };
    }

    private static String getThemeSettingOrDefault(Optional<DevUIConfig.Theme> theme, Function<DevUIConfig.Theme, Optional<DevUIConfig.ThemeMode>> themeModeExtractor, Function<DevUIConfig.ThemeMode, Optional<String>> settingExtractor, String defaultValue) {
        return theme.flatMap(themeModeExtractor).flatMap(settingExtractor).orElse(defaultValue);
    }

    static class Color {
        private int hue;
        private int saturation;
        private int lightness;
        private double alpha;

        private Color(int hue, int saturation, int lightness, double alpha) {
            if (hue < 0 || hue > 360) {
                throw new RuntimeException("Invalid hue, number needs to be between 0 and 360. Defines a degree on the color wheel");
            }
            this.hue = hue;
            if (saturation < 0 || saturation > 100) {
                throw new RuntimeException("Invalid saturation, number needs to be between 0 and 100. 0% is a shade of gray and 100% is the full color (full saturation)");
            }
            this.saturation = saturation;
            if (lightness < 0 || lightness > 100) {
                throw new RuntimeException("Invalid lightness, number needs to be between 0 and 100. 0% is black, 50% is normal, and 100% is white");
            }
            this.lightness = lightness;
            if (alpha < 0.0 || alpha > 1.0) {
                throw new RuntimeException("Invalid alpha, number needs to be between 0 and 1. 0 is fully transparent, 1 is not transparent at all");
            }
            this.alpha = alpha;
        }

        public String toString() {
            return "hsla(" + this.hue + ", " + this.saturation + "%, " + this.lightness + "%, " + this.alpha + ")";
        }

        static Color from(Color color, double alpha) {
            return new Color(color.hue, color.saturation, color.lightness, alpha);
        }

        static Color from(int hue, int saturation, int lightness) {
            return new Color(hue, saturation, lightness, 1.0);
        }

        static Color from(int hue, int saturation, int lightness, double alpha) {
            return new Color(hue, saturation, lightness, alpha);
        }
    }

    private static class DetectPackageFileVisitor
    extends SimpleFileVisitor<Path> {
        private final List<String> paths;

        public DetectPackageFileVisitor(List<String> paths) {
            this.paths = paths;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            boolean hasRegularFiles = false;
            File[] files = dir.toFile().listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isFile()) continue;
                    hasRegularFiles = true;
                    break;
                }
            }
            if (hasRegularFiles) {
                this.paths.add(dir.toAbsolutePath().toString());
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

