/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.spi.page;

import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;

public class QuteDataPageBuilder
extends PageBuilder<QuteDataPageBuilder> {
    private static final String DOT_HTML = ".html";
    private static final String QWC_DATA_QUTE_PAGE_JS = "qwc-data-qute-page.js";
    private String templateLink;

    protected QuteDataPageBuilder(String title) {
        this.title = title;
        this.internalComponent = true;
        this.componentLink = QWC_DATA_QUTE_PAGE_JS;
    }

    public QuteDataPageBuilder templateLink(String templateLink) {
        if (templateLink == null || templateLink.isEmpty() || !templateLink.endsWith(DOT_HTML)) {
            throw new RuntimeException("Invalid template link [" + templateLink + "] - Expeting a link that ends with .html");
        }
        this.templateLink = templateLink;
        return this;
    }

    @Override
    public Page build() {
        super.metadata("templatePath", this.getTemplatePath());
        return super.build();
    }

    public String getTemplatePath() {
        return "/dev-ui/" + this.namespace + "/" + this.templateLink;
    }
}

