/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.spi.page;

import io.quarkus.devui.spi.page.Page;
import java.util.HashMap;
import java.util.Map;

public abstract class PageBuilder<T> {
    protected static final String EMPTY = "";
    protected static final String SPACE = " ";
    protected static final String DASH = "-";
    protected static final String DOT = ".";
    protected static final String JS = "js";
    protected static final String QWC_DASH = "qwc-";
    protected static final String DOT_JS = ".js";
    protected String icon = "font-awesome-solid:arrow-right";
    protected String title = null;
    protected String staticLabel = null;
    protected String dynamicLabel = null;
    protected String streamingLabel = null;
    protected String componentName;
    protected String componentLink;
    protected Map<String, String> metadata = new HashMap<String, String>();
    protected boolean embed = true;
    protected boolean internalComponent = false;
    protected String namespace = null;
    protected String extensionId = null;
    protected Class preprocessor = null;

    public T icon(String icon) {
        this.icon = icon;
        return (T)this;
    }

    public T title(String title) {
        this.title = title;
        return (T)this;
    }

    public T staticLabel(String staticLabel) {
        this.staticLabel = staticLabel;
        return (T)this;
    }

    public T dynamicLabelJsonRPCMethodName(String methodName) {
        this.dynamicLabel = methodName;
        return (T)this;
    }

    public T streamingLabelJsonRPCMethodName(String methodName) {
        this.streamingLabel = methodName;
        return (T)this;
    }

    public T metadata(String key, String value) {
        this.metadata.put(key, value);
        return (T)this;
    }

    public T namespace(String namespace) {
        if (this.namespace == null) {
            this.namespace = namespace;
        }
        return (T)this;
    }

    public T internal() {
        this.internalComponent = true;
        return (T)this;
    }

    public T extension(String extension) {
        this.extensionId = extension.toLowerCase().replaceAll(SPACE, DASH);
        this.metadata.put("extensionName", extension);
        this.metadata.put("extensionId", this.extensionId);
        return (T)this;
    }

    public Page build() {
        if (this.componentName == null && this.componentLink == null && this.title == null) {
            throw new RuntimeException("Not enough information to build the page. Set at least one of componentLink and/or componentName and/or title");
        }
        if (this.componentLink == null) {
            if (this.componentName != null) {
                this.componentLink = this.componentName + DOT_JS;
            } else if (this.title != null) {
                this.componentLink = QWC_DASH + this.title.toLowerCase().replaceAll(SPACE, DASH) + DOT_JS;
            }
        }
        if (this.componentName == null) {
            this.componentName = this.componentLink.substring(0, this.componentLink.lastIndexOf(DOT));
        }
        if (this.title == null) {
            String n = this.componentName.replaceAll(QWC_DASH, EMPTY);
            n = n.substring(n.indexOf(DASH) + 1);
            n = n.replaceAll(DASH, SPACE);
            this.title = n.substring(0, 1).toUpperCase() + n.substring(1);
        }
        Page page = new Page(this.icon, this.title, this.staticLabel, this.dynamicLabel, this.streamingLabel, this.componentName, this.componentLink, this.metadata, this.embed, this.internalComponent, this.namespace, this.extensionId);
        return page;
    }
}

