/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HTTPAuthenticationMechanism;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@ApplicationScoped
public class HttpAuthenticator {
    @Inject
    IdentityProviderManager identityProviderManager;
    final HTTPAuthenticationMechanism mechanism;

    public HttpAuthenticator() {
        this.mechanism = null;
    }

    @Inject
    public HttpAuthenticator(Instance<HTTPAuthenticationMechanism> instance, Instance<IdentityProvider<UsernamePasswordAuthenticationRequest>> usernamePassword) {
        if (instance.isResolvable()) {
            if (instance.isAmbiguous()) {
                throw new IllegalStateException("Multiple HTTP authentication mechanisms are not implemented yet, discovered " + instance.stream().collect(Collectors.toList()));
            }
            this.mechanism = (HTTPAuthenticationMechanism)instance.get();
        } else {
            this.mechanism = !usernamePassword.isUnsatisfied() ? new BasicAuthenticationMechanism("Quarkus") : null;
        }
    }

    public HttpAuthenticator(HTTPAuthenticationMechanism mechanism) {
        this.mechanism = mechanism;
    }

    public CompletionStage<SecurityIdentity> attemptAuthentication(RoutingContext routingContext) {
        if (this.mechanism == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.mechanism.authenticate(routingContext, this.identityProviderManager);
    }

    public CompletionStage<Void> sendChallenge(RoutingContext routingContext, Runnable closeTask) {
        if (closeTask == null) {
            closeTask = NoopCloseTask.INSTANCE;
        }
        if (this.mechanism == null) {
            routingContext.response().setStatusCode(HttpResponseStatus.FORBIDDEN.code());
            closeTask.run();
            return CompletableFuture.completedFuture(null);
        }
        return this.mechanism.sendChallenge(routingContext).thenRun(closeTask);
    }

    static class NoopCloseTask
    implements Runnable {
        static final NoopCloseTask INSTANCE = new NoopCloseTask();

        NoopCloseTask() {
        }

        @Override
        public void run() {
        }
    }
}

