/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.PolicyMappingConfig;
import io.quarkus.vertx.http.runtime.security.DenySecurityPolicy;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.PathMatcher;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class HttpAuthorizer {
    @Inject
    HttpAuthenticator httpAuthenticator;
    @Inject
    IdentityProviderManager identityProviderManager;
    private final PathMatcher<List<HttpMatcher>> pathMatcher = new PathMatcher();

    public void checkPermission(final RoutingContext routingContext) {
        QuarkusHttpUser user = (QuarkusHttpUser)routingContext.user();
        if (user != null) {
            this.doPermissionCheck(routingContext, user.getSecurityIdentity());
        } else {
            this.identityProviderManager.authenticate((AuthenticationRequest)AnonymousAuthenticationRequest.INSTANCE).handle(new BiFunction<SecurityIdentity, Throwable, Object>(){

                @Override
                public Object apply(SecurityIdentity identity, Throwable throwable) {
                    if (throwable != null) {
                        routingContext.fail(throwable);
                    } else {
                        HttpAuthorizer.this.doPermissionCheck(routingContext, identity);
                    }
                    return null;
                }
            });
        }
    }

    private void doPermissionCheck(RoutingContext routingContext, SecurityIdentity securityIdentity) {
        List<HttpSecurityPolicy> permissionCheckers = this.findPermissionCheckers(routingContext.request());
        this.doPermissionCheck(routingContext, securityIdentity, 0, permissionCheckers);
    }

    private void doPermissionCheck(final RoutingContext routingContext, final SecurityIdentity securityIdentity, final int index, final List<HttpSecurityPolicy> permissionCheckers) {
        if (index == permissionCheckers.size()) {
            routingContext.next();
            return;
        }
        HttpSecurityPolicy res = permissionCheckers.get(index);
        res.checkPermission(routingContext.request(), securityIdentity).handle(new BiFunction<HttpSecurityPolicy.CheckResult, Throwable, Object>(){

            @Override
            public Object apply(HttpSecurityPolicy.CheckResult checkResult, Throwable throwable) {
                if (throwable != null) {
                    routingContext.fail(throwable);
                } else if (checkResult == HttpSecurityPolicy.CheckResult.DENY) {
                    HttpAuthorizer.this.doDeny(securityIdentity, routingContext);
                } else {
                    HttpAuthorizer.this.doPermissionCheck(routingContext, securityIdentity, index + 1, permissionCheckers);
                }
                return null;
            }
        });
    }

    private void doDeny(SecurityIdentity securityIdentity, final RoutingContext routingContext) {
        if (securityIdentity.isAnonymous()) {
            this.httpAuthenticator.sendChallenge(routingContext, new Runnable(){

                @Override
                public void run() {
                    routingContext.response().end();
                }
            });
        } else {
            routingContext.fail(403);
        }
    }

    void init(HttpBuildTimeConfig config, Map<String, Supplier<HttpSecurityPolicy>> supplierMap) {
        HashMap<String, HttpSecurityPolicy> permissionCheckers = new HashMap<String, HttpSecurityPolicy>();
        for (Map.Entry<String, Supplier<HttpSecurityPolicy>> i : supplierMap.entrySet()) {
            permissionCheckers.put(i.getKey(), i.getValue().get());
        }
        HashMap tempMap = new HashMap();
        for (Map.Entry<String, PolicyMappingConfig> entry : config.auth.permissions.entrySet()) {
            HttpSecurityPolicy checker = (HttpSecurityPolicy)permissionCheckers.get(entry.getValue().policy);
            if (checker == null) {
                throw new RuntimeException("Unable to find HTTP security policy " + entry.getValue().policy);
            }
            for (String path : entry.getValue().paths) {
                HttpMatcher m;
                if (tempMap.containsKey(path)) {
                    m = new HttpMatcher(new HashSet<String>(entry.getValue().methods), checker);
                    ((List)tempMap.get(path)).add(m);
                    continue;
                }
                m = new HttpMatcher(new HashSet<String>(entry.getValue().methods), checker);
                ArrayList<HttpMatcher> perms = new ArrayList<HttpMatcher>();
                tempMap.put(path, perms);
                perms.add(m);
                if (path.endsWith("*")) {
                    this.pathMatcher.addPrefixPath(path.substring(0, path.length() - 1), perms);
                    continue;
                }
                this.pathMatcher.addExactPath(path, perms);
            }
        }
    }

    public List<HttpSecurityPolicy> findPermissionCheckers(HttpServerRequest request) {
        PathMatcher.PathMatch<List<HttpMatcher>> toCheck = this.pathMatcher.match(request.path());
        if (toCheck.getValue() == null || toCheck.getValue().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HttpSecurityPolicy> methodMatch = new ArrayList<HttpSecurityPolicy>();
        ArrayList<HttpSecurityPolicy> noMethod = new ArrayList<HttpSecurityPolicy>();
        for (HttpMatcher i : toCheck.getValue()) {
            if (i.methods == null || i.methods.isEmpty()) {
                noMethod.add(i.checker);
                continue;
            }
            if (!i.methods.contains(request.method().toString())) continue;
            methodMatch.add(i.checker);
        }
        if (!methodMatch.isEmpty()) {
            return methodMatch;
        }
        if (!noMethod.isEmpty()) {
            return noMethod;
        }
        return Collections.singletonList(DenySecurityPolicy.INSTANCE);
    }

    static class HttpMatcher {
        final Set<String> methods;
        final HttpSecurityPolicy checker;

        HttpMatcher(Set<String> methods, HttpSecurityPolicy checker) {
            this.methods = methods;
            this.checker = checker;
        }
    }
}

