/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import io.quarkus.vertx.http.runtime.devmode.ConfigDescription;
import io.smallrye.config.SmallRyeConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class ConfigDescriptionsSupplier
implements Supplier<List<ConfigDescription>> {
    private List<ConfigDescription> configDescriptions;

    public ConfigDescriptionsSupplier() {
    }

    public ConfigDescriptionsSupplier(List<ConfigDescription> configDescriptions) {
        this.configDescriptions = configDescriptions;
    }

    @Override
    public List<ConfigDescription> get() {
        ArrayList<String> properties = new ArrayList<String>();
        SmallRyeConfig current = (SmallRyeConfig)ConfigProvider.getConfig();
        for (ConfigDescription item : this.configDescriptions) {
            properties.add(item.getName());
            item.setConfigValue(current.getConfigValue(item.getName()));
        }
        for (ConfigSource configSource : current.getConfigSources()) {
            if (!configSource.getName().equals("PropertiesConfigSource[source=Build system]")) continue;
            properties.addAll(configSource.getPropertyNames());
        }
        for (String propertyName : current.getPropertyNames()) {
            if (properties.contains(propertyName)) continue;
            this.configDescriptions.add(new ConfigDescription(propertyName, null, null, current.getConfigValue(propertyName)));
        }
        Collections.sort(this.configDescriptions);
        return this.configDescriptions;
    }

    public List<ConfigDescription> getConfigDescriptions() {
        return this.configDescriptions;
    }

    public void setConfigDescriptions(List<ConfigDescription> configDescriptions) {
        this.configDescriptions = configDescriptions;
    }
}

