/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.logstream;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.vertx.http.runtime.logstream.HistoryHandler;
import io.quarkus.vertx.http.runtime.logstream.WebSocketHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.handlers.ConsoleHandler;

public class LogStreamWebSocket
implements io.vertx.core.Handler<RoutingContext> {
    private static final java.util.logging.Logger log = java.util.logging.Logger.getLogger(LogStreamWebSocket.class.getName());
    private final HistoryHandler historyHandler = new HistoryHandler();
    private final JsonObject initMessage = new JsonObject();
    private final ExtHandler rootHandler;
    private final Logger rootLogger;
    private static final String TYPE = "type";
    private static final String INIT = "init";
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String UPDATE = "update";

    public LogStreamWebSocket() {
        LogContext logContext = LogContext.getLogContext();
        this.rootLogger = logContext.getLogger("");
        this.rootHandler = this.findCorrectHandler(this.rootLogger.getHandlers());
        this.addHandler(this.historyHandler);
        this.initMessage.put(TYPE, INIT);
        this.initMessage.put("loggers", this.getLoggers());
        this.initMessage.put("levels", this.getLevels());
    }

    public void handle(RoutingContext event) {
        if ("websocket".equalsIgnoreCase(event.request().getHeader((CharSequence)HttpHeaderNames.UPGRADE))) {
            event.request().toWebSocket((io.vertx.core.Handler)new io.vertx.core.Handler<AsyncResult<ServerWebSocket>>(){

                public void handle(AsyncResult<ServerWebSocket> event) {
                    if (event.succeeded()) {
                        ServerWebSocket socket = (ServerWebSocket)event.result();
                        final SessionState state = new SessionState();
                        WebSocketHandler webSocketHandler = new WebSocketHandler(socket);
                        state.handler = webSocketHandler;
                        state.session = socket;
                        socket.closeHandler((io.vertx.core.Handler)new io.vertx.core.Handler<Void>(){

                            public void handle(Void event) {
                                LogStreamWebSocket.this.stop(state);
                            }
                        });
                        socket.textMessageHandler((io.vertx.core.Handler)new io.vertx.core.Handler<String>(){

                            public void handle(String event) {
                                LogStreamWebSocket.this.onMessage(event, state);
                            }
                        });
                        socket.writeTextMessage(LogStreamWebSocket.this.initMessage.toString());
                        LogStreamWebSocket.this.start(state);
                    } else {
                        log.log(Level.SEVERE, "Failed to connect to log server", event.cause());
                    }
                }
            });
        } else {
            event.next();
        }
    }

    public void onMessage(String message, SessionState session) {
        if (message != null && !message.isEmpty()) {
            if (message.equalsIgnoreCase(START)) {
                this.start(session);
            } else if (message.equalsIgnoreCase(STOP)) {
                this.stop(session);
            } else if (message.startsWith(UPDATE)) {
                this.update(message);
            }
        }
    }

    private void start(SessionState session) {
        if (!session.started) {
            session.started = true;
            this.rootLogger.addHandler((Handler)session.handler);
            if (this.historyHandler.hasHistory()) {
                List<ExtLogRecord> history = this.historyHandler.getHistory();
                for (ExtLogRecord lr : history) {
                    session.handler.publish(lr);
                }
            }
        }
    }

    private void stop(SessionState session) {
        this.rootLogger.removeHandler((Handler)session.handler);
        session.started = false;
    }

    private JsonArray getLevels() {
        return new JsonArray().add(Level.OFF.getName()).add(Level.SEVERE.getName()).add(Level.WARNING.getName()).add(Level.INFO.getName()).add(Level.CONFIG.getName()).add(Level.FINE.getName()).add(Level.FINER.getName()).add(Level.FINEST.getName()).add(Level.ALL.getName());
    }

    private JsonArray getLoggers() {
        TreeMap<String, JsonObject> loggerMap = new TreeMap<String, JsonObject>();
        LogManager manager = LogManager.getLogManager();
        Enumeration<String> loggerNames = manager.getLoggerNames();
        while (loggerNames.hasMoreElements()) {
            String loggerName = loggerNames.nextElement();
            JsonObject jsonObject = this.getLogger(loggerName);
            if (jsonObject == null) continue;
            loggerMap.put(loggerName, jsonObject);
        }
        ArrayList orderedLoggers = new ArrayList(loggerMap.values());
        JsonArray jsonArray = new JsonArray(orderedLoggers);
        return jsonArray;
    }

    private JsonObject getLogger(String loggerName) {
        if (loggerName != null && !loggerName.isEmpty()) {
            java.util.logging.Logger logger = java.util.logging.Logger.getLogger(loggerName);
            JsonObject jsonObject = new JsonObject();
            jsonObject.put("name", loggerName);
            jsonObject.put("effectiveLevel", this.getEffectiveLogLevel(logger));
            jsonObject.put("configuredLevel", this.getConfiguredLogLevel(logger));
            return jsonObject;
        }
        return null;
    }

    private String getConfiguredLogLevel(java.util.logging.Logger logger) {
        Level level = logger.getLevel();
        return level != null ? level.getName() : null;
    }

    private String getEffectiveLogLevel(java.util.logging.Logger logger) {
        if (logger == null) {
            return null;
        }
        if (logger.getLevel() != null) {
            return logger.getLevel().getName();
        }
        return this.getEffectiveLogLevel(logger.getParent());
    }

    private void update(String message) {
        String[] p = message.split("\\|");
        if (p.length == 3) {
            String loggerName = p[1];
            String levelVal = p[2];
            java.util.logging.Logger logger = java.util.logging.Logger.getLogger(loggerName);
            if (logger != null) {
                Level level = Level.parse(levelVal);
                logger.setLevel(level);
            }
        }
    }

    private void addHandler(ExtHandler extHandler) {
        if (this.rootHandler != null) {
            this.rootHandler.addHandler((Handler)extHandler);
        } else {
            this.rootLogger.addHandler((Handler)extHandler);
        }
    }

    private void removeHandler(ExtHandler extHandler) {
        if (this.rootHandler != null) {
            this.rootHandler.removeHandler((Handler)extHandler);
        } else {
            this.rootLogger.removeHandler((Handler)extHandler);
        }
    }

    private ExtHandler findCorrectHandler(Handler[] handlers) {
        for (Handler h : handlers) {
            ExtHandler exth;
            ExtHandler consoleLogger;
            if (!(h instanceof ExtHandler) || (consoleLogger = this.getConsoleHandler((exth = (ExtHandler)h).getHandlers())) == null) continue;
            return exth;
        }
        for (Handler h : handlers) {
            if (!(h instanceof ExtHandler)) continue;
            return (ExtHandler)h;
        }
        return null;
    }

    private ExtHandler getConsoleHandler(Handler[] handlers) {
        if (handlers != null && handlers.length > 0) {
            for (Handler h : handlers) {
                if (!h.getClass().equals(ConsoleHandler.class)) continue;
                return (ExtHandler)h;
            }
        }
        return null;
    }

    static class SessionState {
        ServerWebSocket session;
        ExtHandler handler;
        boolean started;

        SessionState() {
        }
    }
}

