/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.attribute;

import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.attribute.ReadOnlyAttributeException;
import io.vertx.ext.web.RoutingContext;

public class ResponseCodeAttribute
implements ExchangeAttribute {
    public static final String RESPONSE_CODE_SHORT = "%s";
    public static final String RESPONSE_CODE = "%{RESPONSE_CODE}";
    public static final ExchangeAttribute INSTANCE = new ResponseCodeAttribute();

    private ResponseCodeAttribute() {
    }

    @Override
    public String readAttribute(RoutingContext exchange) {
        return Integer.toString(exchange.response().getStatusCode());
    }

    @Override
    public void writeAttribute(RoutingContext exchange, String newValue) throws ReadOnlyAttributeException {
        exchange.response().setStatusCode(Integer.parseInt(newValue));
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Response code";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(ResponseCodeAttribute.RESPONSE_CODE) || token.equals(ResponseCodeAttribute.RESPONSE_CODE_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

