/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.security.AuthenticationRedirectException;
import io.quarkus.vertx.http.runtime.security.FormAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpAuthorizer;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.PathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.CDI;

@Recorder
public class HttpSecurityRecorder {
    public Handler<RoutingContext> authenticationMechanismHandler() {
        return new Handler<RoutingContext>(){
            volatile HttpAuthenticator authenticator;

            public void handle(final RoutingContext event) {
                if (this.authenticator == null) {
                    this.authenticator = (HttpAuthenticator)CDI.current().select(HttpAuthenticator.class, new Annotation[0]).get();
                }
                event.put(HttpAuthenticator.class.getName(), (Object)this.authenticator);
                this.authenticator.attemptAuthentication(event).handle(new BiFunction<SecurityIdentity, Throwable, Object>(){

                    @Override
                    public Object apply(SecurityIdentity identity, Throwable throwable) {
                        if (throwable != null) {
                            while (throwable instanceof CompletionException && throwable.getCause() != null) {
                                throwable = throwable.getCause();
                            }
                            if (throwable instanceof AuthenticationFailedException) {
                                authenticator.sendChallenge(event, new Runnable(){

                                    @Override
                                    public void run() {
                                        event.response().end();
                                    }
                                });
                            } else if (throwable instanceof AuthenticationRedirectException) {
                                AuthenticationRedirectException redirectEx = (AuthenticationRedirectException)throwable;
                                event.response().setStatusCode(redirectEx.getCode());
                                event.response().headers().set(HttpHeaders.LOCATION, (CharSequence)redirectEx.getRedirectUri());
                                event.response().end();
                            } else {
                                event.fail(throwable);
                            }
                            return null;
                        }
                        if (event.response().ended()) {
                            return null;
                        }
                        if (identity != null) {
                            event.setUser((User)new QuarkusHttpUser(identity));
                        }
                        event.next();
                        return null;
                    }
                });
            }
        };
    }

    public Handler<RoutingContext> permissionCheckHandler() {
        return new Handler<RoutingContext>(){
            volatile HttpAuthorizer authorizer;

            public void handle(RoutingContext event) {
                if (this.authorizer == null) {
                    this.authorizer = (HttpAuthorizer)CDI.current().select(HttpAuthorizer.class, new Annotation[0]).get();
                }
                this.authorizer.checkPermission(event);
            }
        };
    }

    public BeanContainerListener initPermissions(final HttpBuildTimeConfig permissions, final Map<String, Supplier<HttpSecurityPolicy>> policies) {
        return new BeanContainerListener(){

            public void created(BeanContainer container) {
                ((PathMatchingHttpSecurityPolicy)container.instance(PathMatchingHttpSecurityPolicy.class, new Annotation[0])).init(permissions, policies);
            }
        };
    }

    public void setupFormAuth(BeanContainer container, HttpConfiguration httpConfiguration, HttpBuildTimeConfig buildTimeConfig) {
        ((FormAuthenticationMechanism)container.instance(FormAuthenticationMechanism.class, new Annotation[0])).init(httpConfiguration, buildTimeConfig);
    }
}

