/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

class ResumingRequestWrapper
implements HttpServerRequest {
    private boolean userSetState;
    private final HttpServerRequest delegate;

    ResumingRequestWrapper(HttpServerRequest request) {
        this.delegate = request;
    }

    public long bytesRead() {
        return this.delegate.bytesRead();
    }

    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        return this.delegate.exceptionHandler(handler);
    }

    public HttpServerRequest handler(Handler<Buffer> handler) {
        this.delegate.handler(handler);
        if (!this.userSetState) {
            this.delegate.resume();
        }
        return this;
    }

    public HttpServerRequest pause() {
        this.userSetState = true;
        this.delegate.pause();
        return this;
    }

    public HttpServerRequest resume() {
        this.userSetState = true;
        this.delegate.resume();
        return this;
    }

    public HttpServerRequest fetch(long amount) {
        this.userSetState = true;
        this.delegate.fetch(amount);
        return this;
    }

    public HttpServerRequest endHandler(Handler<Void> handler) {
        this.delegate.endHandler(handler);
        if (!this.userSetState) {
            this.delegate.resume();
        }
        return this;
    }

    public HttpVersion version() {
        return this.delegate.version();
    }

    public HttpMethod method() {
        return this.delegate.method();
    }

    public String rawMethod() {
        return this.delegate.rawMethod();
    }

    public String uri() {
        return this.delegate.uri();
    }

    public String path() {
        return this.delegate.path();
    }

    public String query() {
        return this.delegate.query();
    }

    public HttpServerResponse response() {
        return this.delegate.response();
    }

    public MultiMap headers() {
        return this.delegate.headers();
    }

    public String getHeader(String s) {
        return this.delegate.getHeader(s);
    }

    public String getHeader(CharSequence charSequence) {
        return this.delegate.getHeader(charSequence);
    }

    public MultiMap params() {
        return this.delegate.params();
    }

    public String getParam(String s) {
        return this.delegate.getParam(s);
    }

    public SocketAddress remoteAddress() {
        return this.delegate.remoteAddress();
    }

    public SocketAddress localAddress() {
        return this.delegate.localAddress();
    }

    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.delegate.peerCertificateChain();
    }

    public SSLSession sslSession() {
        return this.delegate.sslSession();
    }

    public String absoluteURI() {
        return this.delegate.absoluteURI();
    }

    public String scheme() {
        return this.delegate.scheme();
    }

    public String host() {
        return this.delegate.host();
    }

    public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
        this.delegate.customFrameHandler(handler);
        return this;
    }

    public HttpConnection connection() {
        return this.delegate.connection();
    }

    public HttpServerRequest bodyHandler(Handler<Buffer> handler) {
        this.delegate.bodyHandler(handler);
        if (!this.userSetState) {
            this.delegate.resume();
        }
        return this;
    }

    public NetSocket netSocket() {
        return this.delegate.netSocket();
    }

    public HttpServerRequest setExpectMultipart(boolean b) {
        this.delegate.setExpectMultipart(b);
        return this;
    }

    public boolean isExpectMultipart() {
        return this.delegate.isExpectMultipart();
    }

    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> handler) {
        this.delegate.uploadHandler(handler);
        if (!this.userSetState) {
            this.delegate.resume();
        }
        return this;
    }

    public MultiMap formAttributes() {
        return this.delegate.formAttributes();
    }

    public String getFormAttribute(String s) {
        return this.delegate.getFormAttribute(s);
    }

    public ServerWebSocket upgrade() {
        return this.delegate.upgrade();
    }

    public boolean isEnded() {
        return this.delegate.isEnded();
    }

    public boolean isSSL() {
        return this.delegate.isSSL();
    }

    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> handler) {
        this.delegate.streamPriorityHandler(handler);
        return this;
    }

    public StreamPriority streamPriority() {
        return this.delegate.streamPriority();
    }

    public Cookie getCookie(String name) {
        return this.delegate.getCookie(name);
    }

    public int cookieCount() {
        return this.delegate.cookieCount();
    }

    public Map<String, Cookie> cookieMap() {
        return this.delegate.cookieMap();
    }
}

