/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.cors;

import io.quarkus.vertx.http.runtime.cors.CORSConfig;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public class CORSFilter
implements Handler<RoutingContext> {
    private static final Pattern COMMA_SEPARATED_SPLIT_REGEX = Pattern.compile("\\s*,\\s*");
    final CORSConfig corsConfig;

    public CORSFilter(CORSConfig corsConfig) {
        this.corsConfig = corsConfig;
    }

    private void processRequestedHeaders(HttpServerResponse response, String allowHeadersValue) {
        if (!this.corsConfig.headers.isPresent()) {
            response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS, (CharSequence)allowHeadersValue);
        } else {
            ArrayList<String> requestedHeaders = new ArrayList<String>();
            for (String requestedHeader : COMMA_SEPARATED_SPLIT_REGEX.split(allowHeadersValue)) {
                requestedHeaders.add(requestedHeader.toLowerCase());
            }
            ArrayList<String> validRequestedHeaders = new ArrayList<String>();
            for (String configHeader : this.corsConfig.headers.get()) {
                if (!requestedHeaders.contains(configHeader.toLowerCase())) continue;
                validRequestedHeaders.add(configHeader);
            }
            if (!validRequestedHeaders.isEmpty()) {
                response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS, (CharSequence)String.join((CharSequence)",", validRequestedHeaders));
            }
        }
    }

    private void processMethods(HttpServerResponse response, String allowMethodsValue) {
        if (!this.corsConfig.methods.isPresent()) {
            response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_METHODS, (CharSequence)allowMethodsValue);
        } else {
            ArrayList<String> requestedMethods = new ArrayList<String>();
            for (String requestedMethod : COMMA_SEPARATED_SPLIT_REGEX.split(allowMethodsValue)) {
                requestedMethods.add(requestedMethod.toLowerCase());
            }
            ArrayList<String> validRequestedMethods = new ArrayList<String>();
            for (HttpMethod configMethod : this.corsConfig.methods.get()) {
                if (!requestedMethods.contains(configMethod.name().toLowerCase())) continue;
                validRequestedMethods.add(configMethod.name());
            }
            if (!validRequestedMethods.isEmpty()) {
                response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_METHODS, (CharSequence)String.join((CharSequence)",", validRequestedMethods));
            }
        }
    }

    public void handle(RoutingContext event) {
        Objects.requireNonNull(this.corsConfig, "CORS config is not set");
        HttpServerRequest request = event.request();
        HttpServerResponse response = event.response();
        String origin = request.getHeader(HttpHeaders.ORIGIN);
        if (origin == null) {
            event.next();
        } else {
            boolean allowsOrigin;
            String requestedHeaders;
            String requestedMethods = request.getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_METHOD);
            if (requestedMethods != null) {
                this.processMethods(response, requestedMethods);
            }
            if ((requestedHeaders = request.getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS)) != null) {
                this.processRequestedHeaders(response, requestedHeaders);
            }
            boolean bl = allowsOrigin = !this.corsConfig.origins.isPresent() || this.corsConfig.origins.get().contains(origin);
            if (allowsOrigin) {
                response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, (CharSequence)origin);
            }
            response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS, (CharSequence)"true");
            Optional<List<String>> exposedHeaders = this.corsConfig.exposedHeaders;
            if (exposedHeaders.isPresent()) {
                response.headers().set(HttpHeaders.ACCESS_CONTROL_EXPOSE_HEADERS, (CharSequence)String.join((CharSequence)",", exposedHeaders.orElse(Collections.emptyList())));
            }
            if (request.method().equals((Object)HttpMethod.OPTIONS)) {
                if ((requestedHeaders != null || requestedMethods != null) && this.corsConfig.accessControlMaxAge.isPresent()) {
                    response.putHeader(HttpHeaders.ACCESS_CONTROL_MAX_AGE, (CharSequence)String.valueOf(this.corsConfig.accessControlMaxAge.get().getSeconds()));
                }
                response.end();
            } else {
                event.next();
            }
        }
    }
}

