/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.runtime.ExecutorRecorder;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class HttpAuthorizer {
    @Inject
    HttpAuthenticator httpAuthenticator;
    @Inject
    IdentityProviderManager identityProviderManager;
    final List<HttpSecurityPolicy> policies = new ArrayList<HttpSecurityPolicy>();
    private static final HttpSecurityPolicy.AuthorizationRequestContext CONTEXT = new HttpSecurityPolicy.AuthorizationRequestContext(){

        @Override
        public Uni<HttpSecurityPolicy.CheckResult> runBlocking(final RoutingContext context, final SecurityIdentity identity, final BiFunction<RoutingContext, SecurityIdentity, HttpSecurityPolicy.CheckResult> function) {
            if (BlockingOperationControl.isBlockingAllowed()) {
                try {
                    HttpSecurityPolicy.CheckResult res = function.apply(context, identity);
                    return Uni.createFrom().item((Object)res);
                }
                catch (Throwable t) {
                    return Uni.createFrom().failure(t);
                }
            }
            try {
                return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super HttpSecurityPolicy.CheckResult>>(){

                    @Override
                    public void accept(final UniEmitter<? super HttpSecurityPolicy.CheckResult> uniEmitter) {
                        ExecutorRecorder.getCurrent().execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    HttpSecurityPolicy.CheckResult val = (HttpSecurityPolicy.CheckResult)function.apply(context, identity);
                                    uniEmitter.complete((Object)val);
                                }
                                catch (Throwable t) {
                                    uniEmitter.fail(t);
                                }
                            }
                        });
                    }
                });
            }
            catch (Exception e) {
                return Uni.createFrom().failure((Throwable)e);
            }
        }
    };

    @Inject
    HttpAuthorizer(Instance<HttpSecurityPolicy> installedPolicies) {
        for (HttpSecurityPolicy i : installedPolicies) {
            this.policies.add(i);
        }
    }

    public void checkPermission(RoutingContext routingContext) {
        QuarkusHttpUser user = (QuarkusHttpUser)routingContext.user();
        if (user == null) {
            this.attemptAnonymousAuthentication(routingContext);
        } else {
            this.doPermissionCheck(routingContext, user.getSecurityIdentity(), 0, this.policies);
        }
    }

    private void attemptAnonymousAuthentication(final RoutingContext routingContext) {
        this.identityProviderManager.authenticate((AuthenticationRequest)AnonymousAuthenticationRequest.INSTANCE).subscribe().with((Consumer)new Consumer<SecurityIdentity>(){

            @Override
            public void accept(SecurityIdentity identity) {
                HttpAuthorizer.this.doPermissionCheck(routingContext, identity, 0, HttpAuthorizer.this.policies);
            }
        }, (Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable throwable) {
                routingContext.fail(throwable);
            }
        });
    }

    private void doPermissionCheck(final RoutingContext routingContext, final SecurityIdentity identity, final int index, final List<HttpSecurityPolicy> permissionCheckers) {
        if (index == permissionCheckers.size()) {
            QuarkusHttpUser currentUser = (QuarkusHttpUser)routingContext.user();
            if (!(identity.isAnonymous() || currentUser != null && currentUser.getSecurityIdentity() == identity)) {
                routingContext.setUser((User)new QuarkusHttpUser(identity));
            }
            routingContext.next();
            return;
        }
        HttpSecurityPolicy res = permissionCheckers.get(index);
        res.checkPermission(routingContext, identity, CONTEXT).subscribe().with((Consumer)new Consumer<HttpSecurityPolicy.CheckResult>(){

            @Override
            public void accept(HttpSecurityPolicy.CheckResult checkResult) {
                if (!checkResult.isPermitted()) {
                    HttpAuthorizer.this.doDeny(identity, routingContext);
                } else {
                    SecurityIdentity newIdentity = checkResult.getAugmentedIdentity() != null ? checkResult.getAugmentedIdentity() : identity;
                    HttpAuthorizer.this.doPermissionCheck(routingContext, newIdentity, index + 1, permissionCheckers);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable throwable) {
                routingContext.fail(throwable);
            }
        });
    }

    private void doDeny(SecurityIdentity identity, final RoutingContext routingContext) {
        if (identity.isAnonymous()) {
            this.httpAuthenticator.sendChallenge(routingContext).subscribe().withSubscriber((UniSubscriber)new UniSubscriber<Boolean>(){

                public void onSubscribe(UniSubscription subscription) {
                }

                public void onItem(Boolean item) {
                    routingContext.response().end();
                }

                public void onFailure(Throwable failure) {
                    routingContext.fail(failure);
                }
            });
        } else {
            routingContext.fail(403);
        }
    }
}

