/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.identity.SecurityIdentity;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;

public class QuarkusHttpUser
implements User {
    private final SecurityIdentity securityIdentity;

    public QuarkusHttpUser(SecurityIdentity securityIdentity) {
        this.securityIdentity = securityIdentity;
    }

    public User isAuthorized(String authority, Handler<AsyncResult<Boolean>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)this.securityIdentity.hasRole(authority)));
        return this;
    }

    public User isAuthorised(String authority, Handler<AsyncResult<Boolean>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)this.securityIdentity.hasRole(authority)));
        return this;
    }

    public User clearCache() {
        return this;
    }

    public JsonObject principal() {
        JsonObject ret = new JsonObject();
        ret.put("username", this.securityIdentity.getPrincipal().getName());
        return ret;
    }

    public void setAuthProvider(AuthProvider authProvider) {
    }

    public SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }
}

