/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.security.credential.PasswordCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TrustedAuthenticationRequest;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.quarkus.vertx.http.runtime.security.PersistentLoginManager;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.RoutingContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class FormAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static final Logger log = Logger.getLogger(FormAuthenticationMechanism.class);
    private final String loginPage;
    private final String errorPage;
    private final String postLocation;
    private final String usernameParameter;
    private final String passwordParameter;
    private final String locationCookie;
    private final String landingPage;
    private final boolean redirectAfterLogin;
    private final PersistentLoginManager loginManager;

    public FormAuthenticationMechanism(String loginPage, String postLocation, String usernameParameter, String passwordParameter, String errorPage, String landingPage, boolean redirectAfterLogin, String locationCookie, PersistentLoginManager loginManager) {
        this.loginPage = loginPage;
        this.postLocation = postLocation;
        this.usernameParameter = usernameParameter;
        this.passwordParameter = passwordParameter;
        this.locationCookie = locationCookie;
        this.errorPage = errorPage;
        this.landingPage = landingPage;
        this.redirectAfterLogin = redirectAfterLogin;
        this.loginManager = loginManager;
    }

    public Uni<SecurityIdentity> runFormAuth(final RoutingContext exchange, final IdentityProviderManager securityContext) {
        exchange.request().setExpectMultipart(true);
        return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super SecurityIdentity>>(){

            @Override
            public void accept(final UniEmitter<? super SecurityIdentity> uniEmitter) {
                exchange.request().endHandler((Handler)new Handler<Void>(){

                    public void handle(Void event) {
                        try {
                            MultiMap res = exchange.request().formAttributes();
                            String jUsername = res.get(FormAuthenticationMechanism.this.usernameParameter);
                            String jPassword = res.get(FormAuthenticationMechanism.this.passwordParameter);
                            if (jUsername == null || jPassword == null) {
                                log.debugf("Could not authenticate as username or password was not present in the posted result for %s", (Object)exchange);
                                uniEmitter.complete(null);
                                return;
                            }
                            securityContext.authenticate((AuthenticationRequest)new UsernamePasswordAuthenticationRequest(jUsername, new PasswordCredential(jPassword.toCharArray()))).subscribe().with((Consumer)new Consumer<SecurityIdentity>(){

                                @Override
                                public void accept(SecurityIdentity identity) {
                                    try {
                                        FormAuthenticationMechanism.this.loginManager.save(identity, exchange, null, exchange.request().isSSL());
                                        if (FormAuthenticationMechanism.this.redirectAfterLogin || exchange.getCookie(FormAuthenticationMechanism.this.locationCookie) != null) {
                                            FormAuthenticationMechanism.this.handleRedirectBack(exchange);
                                        } else {
                                            exchange.response().setStatusCode(200);
                                            exchange.response().end();
                                        }
                                        uniEmitter.complete(null);
                                    }
                                    catch (Throwable t) {
                                        log.error((Object)"Unable to complete post authentication", t);
                                        uniEmitter.fail(t);
                                    }
                                }
                            }, (Consumer)new Consumer<Throwable>(){

                                @Override
                                public void accept(Throwable throwable) {
                                    uniEmitter.fail(throwable);
                                }
                            });
                        }
                        catch (Throwable t) {
                            uniEmitter.fail(t);
                        }
                    }
                });
                exchange.request().resume();
            }
        });
    }

    protected void handleRedirectBack(RoutingContext exchange) {
        Object location;
        Cookie redirect = exchange.getCookie(this.locationCookie);
        if (redirect != null) {
            redirect.setSecure(exchange.request().isSSL());
            location = redirect.getValue();
            exchange.response().addCookie(redirect.setMaxAge(0L));
        } else {
            location = exchange.request().scheme() + "://" + exchange.request().host() + this.landingPage;
        }
        exchange.response().setStatusCode(302);
        exchange.response().headers().add((CharSequence)HttpHeaderNames.LOCATION, (CharSequence)location);
        exchange.response().end();
    }

    protected void storeInitialLocation(RoutingContext exchange) {
        exchange.response().addCookie(Cookie.cookie((String)this.locationCookie, (String)exchange.request().absoluteURI()).setPath("/").setSecure(exchange.request().isSSL()));
    }

    protected void servePage(RoutingContext exchange, String location) {
        FormAuthenticationMechanism.sendRedirect(exchange, location);
    }

    static void sendRedirect(RoutingContext exchange, String location) {
        String loc = exchange.request().scheme() + "://" + exchange.request().host() + location;
        exchange.response().headers().add((CharSequence)HttpHeaderNames.LOCATION, (CharSequence)loc);
        exchange.response().setStatusCode(302);
        exchange.response().end();
    }

    static Uni<ChallengeData> getRedirect(RoutingContext exchange, String location) {
        String loc = exchange.request().scheme() + "://" + exchange.request().host() + location;
        return Uni.createFrom().item((Object)new ChallengeData(302, "Location", loc));
    }

    @Override
    public Uni<SecurityIdentity> authenticate(final RoutingContext context, IdentityProviderManager identityProviderManager) {
        if (context.normalizedPath().endsWith(this.postLocation) && context.request().method().equals((Object)HttpMethod.POST)) {
            return this.runFormAuth(context, identityProviderManager);
        }
        final PersistentLoginManager.RestoreResult result = this.loginManager.restore(context);
        if (result != null) {
            Uni ret = identityProviderManager.authenticate((AuthenticationRequest)new TrustedAuthenticationRequest(result.getPrincipal()));
            return ret.onItem().invoke((Consumer)new Consumer<SecurityIdentity>(){

                @Override
                public void accept(SecurityIdentity securityIdentity) {
                    FormAuthenticationMechanism.this.loginManager.save(securityIdentity, context, result, context.request().isSSL());
                }
            });
        }
        return Uni.createFrom().optional(Optional.empty());
    }

    @Override
    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        if (context.normalizedPath().endsWith(this.postLocation) && context.request().method().equals((Object)HttpMethod.POST)) {
            log.debugf("Serving form auth error page %s for %s", (Object)this.loginPage, (Object)context);
            return FormAuthenticationMechanism.getRedirect(context, this.errorPage);
        }
        log.debugf("Serving login form %s for %s", (Object)this.loginPage, (Object)context);
        this.storeInitialLocation(context);
        return FormAuthenticationMechanism.getRedirect(context, this.loginPage);
    }

    @Override
    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return new HashSet<Class<? extends AuthenticationRequest>>(Arrays.asList(UsernamePasswordAuthenticationRequest.class, TrustedAuthenticationRequest.class));
    }

    @Override
    public HttpCredentialTransport getCredentialTransport() {
        return new HttpCredentialTransport(HttpCredentialTransport.Type.POST, this.postLocation);
    }
}

