/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.runtime.ExecutorRecorder;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class HttpAuthorizer {
    @Inject
    HttpAuthenticator httpAuthenticator;
    @Inject
    IdentityProviderManager identityProviderManager;
    @Inject
    AuthorizationController controller;
    final List<HttpSecurityPolicy> policies = new ArrayList<HttpSecurityPolicy>();
    private static final HttpSecurityPolicy.AuthorizationRequestContext CONTEXT = new HttpSecurityPolicy.AuthorizationRequestContext(){

        @Override
        public Uni<HttpSecurityPolicy.CheckResult> runBlocking(final RoutingContext context, final Uni<SecurityIdentity> identity, final BiFunction<RoutingContext, SecurityIdentity, HttpSecurityPolicy.CheckResult> function) {
            if (BlockingOperationControl.isBlockingAllowed()) {
                try {
                    HttpSecurityPolicy.CheckResult res = function.apply(context, (SecurityIdentity)identity.await().indefinitely());
                    return Uni.createFrom().item((Object)res);
                }
                catch (Throwable t) {
                    return Uni.createFrom().failure(t);
                }
            }
            try {
                return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super HttpSecurityPolicy.CheckResult>>(){

                    @Override
                    public void accept(final UniEmitter<? super HttpSecurityPolicy.CheckResult> uniEmitter) {
                        ExecutorRecorder.getCurrent().execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    HttpSecurityPolicy.CheckResult val = (HttpSecurityPolicy.CheckResult)function.apply(context, (SecurityIdentity)identity.await().indefinitely());
                                    uniEmitter.complete((Object)val);
                                }
                                catch (Throwable t) {
                                    uniEmitter.fail(t);
                                }
                            }
                        });
                    }
                });
            }
            catch (Exception e) {
                return Uni.createFrom().failure((Throwable)e);
            }
        }
    };

    @Inject
    HttpAuthorizer(Instance<HttpSecurityPolicy> installedPolicies) {
        for (HttpSecurityPolicy i : installedPolicies) {
            this.policies.add(i);
        }
    }

    public void checkPermission(RoutingContext routingContext) {
        if (!this.controller.isAuthorizationEnabled()) {
            routingContext.next();
            return;
        }
        this.doPermissionCheck(routingContext, QuarkusHttpUser.getSecurityIdentity(routingContext, this.identityProviderManager), 0, null, this.policies);
    }

    private void doPermissionCheck(final RoutingContext routingContext, final Uni<SecurityIdentity> identity, final int index, final SecurityIdentity augmentedIdentity, final List<HttpSecurityPolicy> permissionCheckers) {
        if (index == permissionCheckers.size()) {
            QuarkusHttpUser currentUser = (QuarkusHttpUser)routingContext.user();
            if (!(augmentedIdentity == null || augmentedIdentity.isAnonymous() || currentUser != null && currentUser.getSecurityIdentity() == augmentedIdentity)) {
                routingContext.setUser((User)new QuarkusHttpUser(augmentedIdentity));
                routingContext.put("io.quarkus.vertx.http.deferred-identity", (Object)Uni.createFrom().item((Object)augmentedIdentity));
            }
            routingContext.next();
            return;
        }
        HttpSecurityPolicy res = permissionCheckers.get(index);
        res.checkPermission(routingContext, identity, CONTEXT).subscribe().with((Consumer)new Consumer<HttpSecurityPolicy.CheckResult>(){

            @Override
            public void accept(HttpSecurityPolicy.CheckResult checkResult) {
                if (!checkResult.isPermitted()) {
                    HttpAuthorizer.this.doDeny((Uni<SecurityIdentity>)identity, routingContext);
                } else if (checkResult.getAugmentedIdentity() != null) {
                    HttpAuthorizer.this.doPermissionCheck(routingContext, (Uni<SecurityIdentity>)Uni.createFrom().item((Object)checkResult.getAugmentedIdentity()), index + 1, checkResult.getAugmentedIdentity(), permissionCheckers);
                } else {
                    HttpAuthorizer.this.doPermissionCheck(routingContext, (Uni<SecurityIdentity>)identity, index + 1, augmentedIdentity, permissionCheckers);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable throwable) {
                routingContext.fail(throwable);
            }
        });
    }

    private void doDeny(Uni<SecurityIdentity> identity, final RoutingContext routingContext) {
        identity.subscribe().withSubscriber((UniSubscriber)new UniSubscriber<SecurityIdentity>(){

            public void onSubscribe(UniSubscription subscription) {
            }

            public void onItem(SecurityIdentity identity) {
                if (identity.isAnonymous()) {
                    HttpAuthorizer.this.httpAuthenticator.sendChallenge(routingContext).subscribe().withSubscriber((UniSubscriber)new UniSubscriber<Boolean>(){

                        public void onSubscribe(UniSubscription subscription) {
                        }

                        public void onItem(Boolean item) {
                            routingContext.response().end();
                        }

                        public void onFailure(Throwable failure) {
                            routingContext.fail(failure);
                        }
                    });
                } else {
                    routingContext.fail(403);
                }
            }

            public void onFailure(Throwable failure) {
                routingContext.fail(failure);
            }
        });
    }
}

