/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import io.quarkus.fs.util.ZipUtils;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.core.net.impl.URIDecoder;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class FileSystemStaticHandler
implements Handler<RoutingContext>,
Closeable {
    private static final String DEFAULT_CONTENT_ENCODING = Charset.defaultCharset().name();
    private static final ReentrantLock ROOT_CREATION_LOCK = new ReentrantLock();
    private List<Path> resolvedWebRoots;
    private List<StaticWebRootConfiguration> webRootConfigurations;

    public FileSystemStaticHandler() {
    }

    public FileSystemStaticHandler(List<StaticWebRootConfiguration> webRootConfigurations) {
        this.webRootConfigurations = webRootConfigurations;
    }

    public List<StaticWebRootConfiguration> getWebRootConfigurations() {
        return this.webRootConfigurations;
    }

    public void setWebRootConfigurations(List<StaticWebRootConfiguration> webRootConfigurations) {
        this.webRootConfigurations = webRootConfigurations;
    }

    public void handle(RoutingContext context) {
        HttpServerRequest request = context.request();
        if (request.method() != HttpMethod.GET && request.method() != HttpMethod.HEAD) {
            context.next();
            return;
        }
        String uriDecodedPath = URIDecoder.decodeURIComponent((String)context.normalizedPath(), (boolean)false);
        if (uriDecodedPath == null) {
            context.next();
            return;
        }
        String path = HttpUtils.removeDots((CharSequence)uriDecodedPath.replace('\\', '/'));
        if ((path = Utils.pathOffset((String)path, (RoutingContext)context)).startsWith("/")) {
            path = path.substring(1);
        }
        try {
            this.sendStatic(context, path);
        }
        catch (IOException e) {
            context.fail((Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveWebRoots() throws IOException {
        if (this.resolvedWebRoots == null) {
            try {
                ROOT_CREATION_LOCK.lock();
                if (this.resolvedWebRoots == null) {
                    ArrayList<Path> rootPaths = new ArrayList<Path>();
                    for (StaticWebRootConfiguration fsConfiguration : this.webRootConfigurations) {
                        Path sysFSPath;
                        Path rootPath = sysFSPath = Paths.get(fsConfiguration.fileSystem, new String[0]);
                        if (Files.isRegularFile(sysFSPath, new LinkOption[0])) {
                            FileSystem fileSystem = ZipUtils.newFileSystem((Path)sysFSPath);
                            rootPath = fileSystem.getPath("", new String[0]);
                        }
                        rootPaths.add(rootPath.resolve(fsConfiguration.webRoot));
                    }
                    this.resolvedWebRoots = new ArrayList<Path>(rootPaths);
                }
            }
            finally {
                ROOT_CREATION_LOCK.unlock();
            }
        }
    }

    private void sendStatic(RoutingContext context, String path) throws IOException {
        BasicFileAttributes fileAttributes;
        this.resolveWebRoots();
        Path found = null;
        for (Path root : this.resolvedWebRoots) {
            Path resolved = root.resolve(path);
            if (!Files.exists(resolved, new LinkOption[0])) continue;
            found = resolved;
            break;
        }
        if (found == null) {
            context.next();
            return;
        }
        HttpServerResponse response = context.response();
        String contentType = MimeMapping.getMimeTypeForFilename((String)path);
        if (contentType != null) {
            if (contentType.startsWith("text")) {
                response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)(contentType + ";charset=" + DEFAULT_CONTENT_ENCODING));
            } else {
                response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
            }
        }
        if ((fileAttributes = Files.readAttributes(found, BasicFileAttributes.class, new LinkOption[0])).isDirectory()) {
            context.next();
            return;
        }
        if (fileAttributes.isRegularFile()) {
            context.end(Buffer.buffer((byte[])Files.readAllBytes(found)));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.resolvedWebRoots == null) {
            return;
        }
        for (Path resolvedWebRoot : this.resolvedWebRoots) {
            FileSystem fs = resolvedWebRoot.getFileSystem();
            if (fs == FileSystems.getDefault()) continue;
            fs.close();
        }
    }

    public static class StaticWebRootConfiguration {
        private String fileSystem;
        private String webRoot;

        public StaticWebRootConfiguration() {
        }

        public StaticWebRootConfiguration(String fileSystemPath, String webRoot) {
            this.fileSystem = fileSystemPath;
            this.webRoot = webRoot;
        }

        public String getFileSystem() {
            return this.fileSystem;
        }

        public void setFileSystem(String fileSystem) {
            this.fileSystem = fileSystem;
        }

        public String getWebRoot() {
            return this.webRoot;
        }

        public void setWebRoot(String webRoot) {
            this.webRoot = webRoot;
        }
    }
}

