/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.devui.runtime.DevUIBuildTimeStaticHandler;
import io.quarkus.devui.runtime.DevUIWebSocket;
import io.quarkus.devui.runtime.MvnpmHandler;
import io.quarkus.devui.runtime.VaadinRouterHandler;
import io.quarkus.devui.runtime.comms.JsonRpcRouter;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethod;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethodName;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.devmode.FileSystemStaticHandler;
import io.quarkus.vertx.http.runtime.webjar.WebJarStaticHandler;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Recorder
public class DevUIRecorder {
    public void createJsonRpcRouter(BeanContainer beanContainer, Map<String, Map<JsonRpcMethodName, JsonRpcMethod>> extensionMethodsMap) {
        JsonRpcRouter jsonRpcRouter = (JsonRpcRouter)beanContainer.beanInstance(JsonRpcRouter.class, new Annotation[0]);
        jsonRpcRouter.populateJsonRPCMethods(extensionMethodsMap);
    }

    public Handler<RoutingContext> communicationHandler() {
        return new DevUIWebSocket();
    }

    public Handler<RoutingContext> uiHandler(String finalDestination, String path, List<FileSystemStaticHandler.StaticWebRootConfiguration> webRootConfigurations, ShutdownContext shutdownContext) {
        WebJarStaticHandler handler = new WebJarStaticHandler(finalDestination, path, webRootConfigurations);
        shutdownContext.addShutdownTask((Runnable)new ShutdownContext.CloseRunnable((Closeable)handler));
        return handler;
    }

    public Handler<RoutingContext> buildTimeStaticHandler(String basePath, Map<String, String> urlAndPath) {
        return new DevUIBuildTimeStaticHandler(basePath, urlAndPath);
    }

    public Handler<RoutingContext> vaadinRouterHandler(String basePath) {
        return new VaadinRouterHandler(basePath);
    }

    public Handler<RoutingContext> mvnpmHandler(Set<URL> mvnpmJarFiles) {
        return new MvnpmHandler(mvnpmJarFiles);
    }
}

