/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.comms;

import io.quarkus.arc.Arc;
import io.quarkus.devui.runtime.comms.ReflectionInfo;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcKeys;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethod;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethodName;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcReader;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcWriter;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.subscription.Cancellable;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@ApplicationScoped
public class JsonRpcRouter {
    private final Map<Integer, Cancellable> subscriptions = new ConcurrentHashMap<Integer, Cancellable>();
    private final Map<String, ReflectionInfo> jsonRpcToJava = new HashMap<String, ReflectionInfo>();
    private static final String DOT = ".";
    private static final String UNSUBSCRIBE = "unsubscribe";

    public void populateJsonRPCMethods(Map<String, Map<JsonRpcMethodName, JsonRpcMethod>> extensionMethodsMap) {
        for (Map.Entry<String, Map<JsonRpcMethodName, JsonRpcMethod>> extension : extensionMethodsMap.entrySet()) {
            String extensionName = extension.getKey();
            Map<JsonRpcMethodName, JsonRpcMethod> jsonRpcMethods = extension.getValue();
            for (Map.Entry<JsonRpcMethodName, JsonRpcMethod> method : jsonRpcMethods.entrySet()) {
                JsonRpcMethodName methodName = method.getKey();
                JsonRpcMethod jsonRpcMethod = method.getValue();
                Object providerInstance = Arc.container().select(jsonRpcMethod.getClazz(), new Annotation[0]).get();
                try {
                    Method javaMethod;
                    Map<String, Class> params = null;
                    if (jsonRpcMethod.hasParams()) {
                        params = jsonRpcMethod.getParams();
                        javaMethod = providerInstance.getClass().getMethod(jsonRpcMethod.getMethodName(), params.values().toArray(new Class[0]));
                    } else {
                        javaMethod = providerInstance.getClass().getMethod(jsonRpcMethod.getMethodName(), new Class[0]);
                    }
                    ReflectionInfo reflectionInfo = new ReflectionInfo(jsonRpcMethod.getClazz(), providerInstance, javaMethod, params);
                    String jsonRpcMethodName = extensionName + DOT + methodName;
                    this.jsonRpcToJava.put(jsonRpcMethodName, reflectionInfo);
                }
                catch (NoSuchMethodException | SecurityException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public void addSocket(ServerWebSocket socket) {
        socket.textMessageHandler(e -> socket.writeTextMessage(this.route((String)e, socket)));
    }

    private String route(String message, ServerWebSocket s) {
        JsonRpcReader jsonRpcRequest = JsonRpcReader.read(message);
        JsonObject jsonRpcResponse = this.route(jsonRpcRequest, s);
        return jsonRpcResponse.encodePrettily();
    }

    private JsonObject route(JsonRpcReader jsonRpcRequest, ServerWebSocket s) {
        String jsonRpcMethodName = jsonRpcRequest.getMethod();
        if (jsonRpcMethodName.equalsIgnoreCase(UNSUBSCRIBE)) {
            JsonObject jsonRpcResponse = JsonRpcWriter.writeResponse(jsonRpcRequest.getId(), null, JsonRpcKeys.MessageType.Void);
            if (this.subscriptions.containsKey(jsonRpcRequest.getId())) {
                Cancellable cancellable = this.subscriptions.remove(jsonRpcRequest.getId());
                cancellable.cancel();
            }
            return jsonRpcResponse;
        }
        if (this.jsonRpcToJava.containsKey(jsonRpcMethodName)) {
            ReflectionInfo reflectionInfo = this.jsonRpcToJava.get(jsonRpcMethodName);
            Object providerInstance = Arc.container().select(reflectionInfo.bean, new Annotation[0]).get();
            try {
                JsonObject jsonRpcResponse;
                Object result;
                if (jsonRpcRequest.hasParams()) {
                    Object[] args = this.getArgsAsObjects(reflectionInfo.params, jsonRpcRequest);
                    result = reflectionInfo.method.invoke(providerInstance, args);
                } else {
                    result = reflectionInfo.method.invoke(providerInstance, new Object[0]);
                }
                if (reflectionInfo.isSubscription()) {
                    Multi subscription = (Multi)result;
                    Cancellable cancellable = subscription.subscribe().with(t -> {
                        JsonObject jsonResponse = JsonRpcWriter.writeResponse(jsonRpcRequest.getId(), t, JsonRpcKeys.MessageType.SubscriptionMessage);
                        s.writeTextMessage(jsonResponse.encodePrettily());
                    });
                    this.subscriptions.put(jsonRpcRequest.getId(), cancellable);
                    jsonRpcResponse = JsonRpcWriter.writeResponse(jsonRpcRequest.getId(), null, JsonRpcKeys.MessageType.Void);
                } else {
                    jsonRpcResponse = JsonRpcWriter.writeResponse(jsonRpcRequest.getId(), result, JsonRpcKeys.MessageType.Response);
                }
                return jsonRpcResponse;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
        return JsonRpcWriter.writeMethodNotFoundResponse(jsonRpcRequest.getId(), jsonRpcMethodName);
    }

    private Object[] getArgsAsObjects(Map<String, Class> params, JsonRpcReader jsonRpcRequest) {
        ArrayList objects = new ArrayList();
        for (Map.Entry<String, Class> expectedParams : params.entrySet()) {
            String paramName = expectedParams.getKey();
            Class paramType = expectedParams.getValue();
            Object param = jsonRpcRequest.getParam(paramName);
            Object casted = paramType.cast(param);
            objects.add(casted);
        }
        return objects.toArray(Object[]::new);
    }
}

