/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.options;

import io.quarkus.vertx.http.runtime.CertificateConfig;
import io.quarkus.vertx.http.runtime.options.HttpServerOptionsUtils;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.KeyStoreOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.TrustOptions;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class TlsUtils {
    private TlsUtils() {
    }

    public static KeyCertOptions computeKeyStoreOptions(CertificateConfig certificates, Optional<String> keyStorePassword, Optional<String> keyStoreAliasPassword) throws IOException {
        if (certificates.keyFiles.isPresent() || certificates.files.isPresent()) {
            if (certificates.keyFiles.isEmpty()) {
                throw new IllegalArgumentException("You must specify the key files when specifying the certificate files");
            }
            if (certificates.files.isEmpty()) {
                throw new IllegalArgumentException("You must specify the certificate files when specifying the key files");
            }
            if (certificates.files.get().size() != certificates.keyFiles.get().size()) {
                throw new IllegalArgumentException("The number of certificate files and key files must be the same, and be given in the same order");
            }
            return TlsUtils.createPemKeyCertOptions(certificates.files.get(), certificates.keyFiles.get());
        }
        if (certificates.keyStoreFile.isPresent()) {
            String type = TlsUtils.getKeyStoreType(certificates.keyStoreFile.get(), certificates.keyStoreFileType);
            return TlsUtils.createKeyStoreOptions(certificates.keyStoreFile.get(), keyStorePassword, type, certificates.keyStoreProvider, HttpServerOptionsUtils.or(certificates.keyStoreAlias, certificates.keyStoreKeyAlias), keyStoreAliasPassword);
        }
        return null;
    }

    public static TrustOptions computeTrustOptions(CertificateConfig certificates, Optional<String> trustStorePassword) throws IOException {
        Path singleTrustStoreFile = TlsUtils.getSingleTrustStoreFile(certificates);
        if (singleTrustStoreFile != null) {
            String type = TlsUtils.getTruststoreType(singleTrustStoreFile, certificates.trustStoreFileType);
            if (type.equalsIgnoreCase("pem")) {
                byte[] cert = HttpServerOptionsUtils.getFileContent(singleTrustStoreFile);
                return new PemTrustOptions().addCertValue(Buffer.buffer((byte[])cert));
            }
            if ((type.equalsIgnoreCase("pkcs12") || type.equalsIgnoreCase("jks")) && certificates.trustStorePassword.isEmpty() && trustStorePassword.isEmpty()) {
                throw new IllegalArgumentException("No trust store password provided");
            }
            return TlsUtils.createKeyStoreOptions(singleTrustStoreFile, trustStorePassword, type, certificates.trustStoreProvider, certificates.trustStoreCertAlias, Optional.empty());
        }
        if (certificates.trustStoreFiles.isPresent() && !certificates.trustStoreFiles.get().isEmpty()) {
            PemTrustOptions pemKeyCertOptions = new PemTrustOptions();
            for (Path path : certificates.trustStoreFiles.get()) {
                byte[] cert = HttpServerOptionsUtils.getFileContent(path);
                pemKeyCertOptions.addCertValue(Buffer.buffer((byte[])cert));
            }
            return pemKeyCertOptions;
        }
        return null;
    }

    private static Path getSingleTrustStoreFile(CertificateConfig certificates) {
        Path singleTrustStoreFile = null;
        if (certificates.trustStoreFile.isPresent()) {
            singleTrustStoreFile = certificates.trustStoreFile.get();
        }
        if (certificates.trustStoreFiles.isPresent()) {
            if (singleTrustStoreFile != null) {
                throw new IllegalArgumentException("You cannot specify both `trustStoreFile` and `trustStoreFiles`");
            }
            if (certificates.trustStoreFiles.get().size() == 1) {
                singleTrustStoreFile = certificates.trustStoreFiles.get().get(0);
            }
        }
        return singleTrustStoreFile;
    }

    static String getTruststoreType(Path singleTrustStoreFile, Optional<String> userType) {
        String type = userType.isPresent() ? userType.get().toLowerCase() : TlsUtils.getTruststoreTypeFromFileName(singleTrustStoreFile);
        return type;
    }

    private static String getKeystoreTypeFromFileName(Path path) {
        String name = path.getFileName().toString().toLowerCase();
        if (name.endsWith(".p12") || name.endsWith(".pkcs12") || name.endsWith(".pfx")) {
            return "pkcs12";
        }
        if (name.endsWith(".jks") || name.endsWith(".keystore")) {
            return "jks";
        }
        if (name.endsWith(".key") || name.endsWith(".crt") || name.endsWith(".pem")) {
            return "pem";
        }
        throw new IllegalArgumentException("Could not determine the keystore type from the file name: " + String.valueOf(path) + ". Configure the `quarkus.http.ssl.certificate.key-store-file-type` property.");
    }

    private static String getTruststoreTypeFromFileName(Path path) {
        String name = path.getFileName().toString().toLowerCase();
        if (name.endsWith(".p12") || name.endsWith(".pkcs12") || name.endsWith(".pfx")) {
            return "pkcs12";
        }
        if (name.endsWith(".jks") || name.endsWith(".truststore")) {
            return "jks";
        }
        if (name.endsWith(".ca") || name.endsWith(".crt") || name.endsWith(".pem")) {
            return "pem";
        }
        throw new IllegalArgumentException("Could not determine the truststore type from the file name: " + String.valueOf(path) + ". Configure the `quarkus.http.ssl.certificate.trust-store-file-type` property.");
    }

    private static KeyStoreOptions createKeyStoreOptions(Path path, Optional<String> password, String type, Optional<String> provider, Optional<String> alias, Optional<String> aliasPassword) throws IOException {
        byte[] data = HttpServerOptionsUtils.getFileContent(path);
        return new KeyStoreOptions().setPassword((String)password.orElse(null)).setValue(Buffer.buffer((byte[])data)).setType(type.toUpperCase()).setProvider((String)provider.orElse(null)).setAlias((String)alias.orElse(null)).setAliasPassword((String)aliasPassword.orElse(null));
    }

    static String getKeyStoreType(Path path, Optional<String> fileType) {
        String type = fileType.isPresent() ? fileType.get().toLowerCase() : TlsUtils.getKeystoreTypeFromFileName(path);
        return type;
    }

    private static PemKeyCertOptions createPemKeyCertOptions(List<Path> certFile, List<Path> keyFile) throws IOException {
        ArrayList<Buffer> certificates = new ArrayList<Buffer>();
        ArrayList<Buffer> keys = new ArrayList<Buffer>();
        for (Path p : certFile) {
            byte[] cert = HttpServerOptionsUtils.getFileContent(p);
            certificates.add(Buffer.buffer((byte[])cert));
        }
        for (Path p : keyFile) {
            byte[] key = HttpServerOptionsUtils.getFileContent(p);
            keys.add(Buffer.buffer((byte[])key));
        }
        return new PemKeyCertOptions().setCertValues(certificates).setKeyValues(keys);
    }
}

