/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.runtime.LaunchMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class PortSystemProperties {
    private final Map<String, String> portPropertiesToRestore = new HashMap<String, String>();

    public void set(String subProperty, int actualPort, LaunchMode launchMode) {
        String portPropertyValue = String.valueOf(actualPort);
        String portPropertyName = "quarkus." + subProperty + ".port";
        String testPropName = "quarkus." + subProperty + ".test-port";
        this.set(portPropertyName, testPropName, portPropertyValue, launchMode);
        if ("https".equals(subProperty)) {
            this.set("quarkus.http.ssl-port", "quarkus.http.test-ssl-port", portPropertyValue, launchMode);
        }
    }

    private void set(String portPropertyName, String testPropName, String portPropertyValue, LaunchMode launchMode) {
        this.set((String)portPropertyName, portPropertyValue);
        if (launchMode == LaunchMode.TEST) {
            this.set(testPropName, portPropertyValue);
        }
        if (launchMode.isDevOrTest()) {
            portPropertyName = "%" + launchMode.getDefaultProfile() + "." + (String)portPropertyName;
            this.set((String)portPropertyName, portPropertyValue);
        }
    }

    private void set(String propertyName, String propertyValue) {
        String prevPropertyValue = System.setProperty(propertyName, propertyValue);
        if (!Objects.equals(prevPropertyValue, propertyValue)) {
            this.portPropertiesToRestore.put(propertyName, prevPropertyValue);
        }
    }

    public void restore() {
        this.portPropertiesToRestore.forEach((key, value) -> {
            if (value == null) {
                System.clearProperty(key);
            } else {
                System.setProperty(key, value);
            }
        });
        this.portPropertiesToRestore.clear();
    }
}

