/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;

public final class HttpSecurityUtils {
    public static final String ROUTING_CONTEXT_ATTRIBUTE = "quarkus.http.routing.context";
    static final String SECURITY_IDENTITIES_ATTRIBUTE = "io.quarkus.security.identities";
    static final String COMMON_NAME = "CN";

    private HttpSecurityUtils() {
    }

    public static Map<String, SecurityIdentity> getSecurityIdentities(SecurityIdentity identity) {
        RoutingContext routingContext = HttpSecurityUtils.getRoutingContextAttribute(identity);
        if (routingContext == null) {
            return null;
        }
        return HttpSecurityUtils.getSecurityIdentities(routingContext);
    }

    public static Map<String, SecurityIdentity> getSecurityIdentities(RoutingContext routingContext) {
        return (Map)routingContext.get(SECURITY_IDENTITIES_ATTRIBUTE);
    }

    public static AuthenticationRequest setRoutingContextAttribute(AuthenticationRequest request, RoutingContext context) {
        request.setAttribute(ROUTING_CONTEXT_ATTRIBUTE, (Object)context);
        return request;
    }

    public static RoutingContext getRoutingContextAttribute(AuthenticationRequest request) {
        return (RoutingContext)request.getAttribute(ROUTING_CONTEXT_ATTRIBUTE);
    }

    public static RoutingContext getRoutingContextAttribute(SecurityIdentity identity) {
        return (RoutingContext)identity.getAttribute(RoutingContext.class.getName());
    }

    public static RoutingContext getRoutingContextAttribute(Map<String, Object> authenticationRequestAttributes) {
        return (RoutingContext)authenticationRequestAttributes.get(ROUTING_CONTEXT_ATTRIBUTE);
    }

    public static String getCommonName(X500Principal principal) {
        return HttpSecurityUtils.getRdnValue(principal, COMMON_NAME);
    }

    static String getRdnValue(X500Principal principal, String rdnType) {
        try {
            LdapName ldapDN = new LdapName(principal.getName());
            for (Rdn rdn : ldapDN.getRdns()) {
                if (!rdnType.equalsIgnoreCase(rdn.getType())) continue;
                return rdn.getValue().toString();
            }
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        return null;
    }
}

