/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.netty.util.AsciiString;
import io.quarkus.vertx.http.runtime.ForwardingProxyOptions;
import io.quarkus.vertx.http.runtime.ProxyConfig;
import io.quarkus.vertx.http.runtime.TrustedProxyCheck;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

class ForwardedParser {
    private static final Logger log = Logger.getLogger(ForwardedParser.class);
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final AsciiString FORWARDED = AsciiString.cached((String)"Forwarded");
    private static final AsciiString X_FORWARDED_SSL = AsciiString.cached((String)"X-Forwarded-Ssl");
    private static final AsciiString X_FORWARDED_PROTO = AsciiString.cached((String)"X-Forwarded-Proto");
    private static final AsciiString X_FORWARDED_PORT = AsciiString.cached((String)"X-Forwarded-Port");
    private static final AsciiString X_FORWARDED_FOR = AsciiString.cached((String)"X-Forwarded-For");
    private static final AsciiString X_FORWARDED_TRUSTED_PROXY = AsciiString.cached((String)"X-Forwarded-Trusted-Proxy");
    private static final Pattern FORWARDED_HOST_PATTERN = Pattern.compile("host=\"?([^;,\"]+)\"?", 2);
    private static final Pattern FORWARDED_PROTO_PATTERN = Pattern.compile("proto=\"?([^;,\"]+)\"?", 2);
    private static final Pattern FORWARDED_FOR_PATTERN = Pattern.compile("for=\"?([^;,\"]+)\"?", 2);
    private static final int PORT_MIN_VALID_VALUE = 0;
    private static final int PORT_MAX_VALID_VALUE = 65535;
    private final HttpServerRequest delegate;
    private final ForwardingProxyOptions forwardingProxyOptions;
    private final TrustedProxyCheck trustedProxyCheck;
    private static final AsciiString HOST_HEADER = AsciiString.cached((String)"Host");
    private boolean calculated;
    private String host;
    private int port = -1;
    private String scheme;
    private String uri;
    private String absoluteURI;
    private SocketAddress remoteAddress;
    private HostAndPort authority;

    ForwardedParser(HttpServerRequest delegate, ForwardingProxyOptions forwardingProxyOptions, TrustedProxyCheck trustedProxyCheck) {
        this.delegate = delegate;
        this.forwardingProxyOptions = forwardingProxyOptions;
        this.trustedProxyCheck = trustedProxyCheck;
    }

    public String scheme() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.scheme;
    }

    String host() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.host;
    }

    boolean isSSL() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.scheme.equals(HTTPS_SCHEME);
    }

    HostAndPort authority() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.authority;
    }

    String absoluteURI() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.absoluteURI;
    }

    SocketAddress remoteAddress() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.remoteAddress;
    }

    String uri() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.uri;
    }

    private void calculate() {
        this.calculated = true;
        this.remoteAddress = this.delegate.remoteAddress();
        this.scheme = this.delegate.scheme();
        this.setHostAndPort(this.delegate.host(), this.port);
        this.uri = this.delegate.uri();
        boolean isProxyAllowed = this.trustedProxyCheck.isProxyAllowed();
        if (isProxyAllowed) {
            if (this.forwardingProxyOptions.allowForwarded && this.forwardingProxyOptions.allowXForwarded) {
                Forwarded forwardedHeaders = null;
                Forwarded xForwardedHeaders = null;
                if (ProxyConfig.ForwardedPrecedence.FORWARDED == this.forwardingProxyOptions.forwardedPrecedence) {
                    xForwardedHeaders = this.processXForwarded();
                    forwardedHeaders = this.processForwarded();
                } else {
                    forwardedHeaders = this.processForwarded();
                    xForwardedHeaders = this.processXForwarded();
                }
                if (this.forwardingProxyOptions.strictForwardedControl) {
                    log.debug((Object)"Strict forwarded control is enabled, checking if common Forwarded and X-Forwarded properties match");
                    if (!xForwardedHeaders.modifiedPropertiesMatch(forwardedHeaders)) {
                        this.delegate.response().setStatusCode(400);
                        this.delegate.end();
                        return;
                    }
                    log.debug((Object)"Common Forwarded and X-Forwarded properties match");
                }
            } else if (this.forwardingProxyOptions.allowForwarded) {
                this.processForwarded();
            } else if (this.forwardingProxyOptions.allowXForwarded) {
                this.processXForwarded();
            }
        }
        if (this.scheme.equals(HTTP_SCHEME) && this.port == 80 || this.scheme.equals(HTTPS_SCHEME) && this.port == 443) {
            this.port = -1;
        }
        this.authority = HostAndPort.create((String)this.host, (int)(this.port >= 0 ? this.port : -1));
        this.host = this.host + (String)(this.port >= 0 ? ":" + this.port : "");
        this.delegate.headers().set((CharSequence)HOST_HEADER, (CharSequence)this.host);
        if (this.forwardingProxyOptions.enableTrustedProxyHeader) {
            if (this.delegate.headers().contains((CharSequence)X_FORWARDED_TRUSTED_PROXY)) {
                log.warn((Object)("The header " + String.valueOf(X_FORWARDED_TRUSTED_PROXY) + " was already set. Overwriting it."));
            }
            this.delegate.headers().set((CharSequence)X_FORWARDED_TRUSTED_PROXY, (CharSequence)Boolean.toString(isProxyAllowed));
        } else if (this.delegate.headers().contains((CharSequence)X_FORWARDED_TRUSTED_PROXY)) {
            log.warn((Object)("The header " + String.valueOf(X_FORWARDED_TRUSTED_PROXY) + " was already set. Removing it."));
            this.delegate.headers().remove((CharSequence)X_FORWARDED_TRUSTED_PROXY);
        }
        this.absoluteURI = this.scheme + "://" + this.host + this.uri;
        log.debugf("Recalculated absoluteURI to %s", (Object)this.absoluteURI);
    }

    private Forwarded processForwarded() {
        Forwarded forwardedValues = new Forwarded();
        String forwarded = this.delegate.getHeader((CharSequence)FORWARDED);
        if (forwarded == null) {
            return forwardedValues;
        }
        Matcher matcher = FORWARDED_PROTO_PATTERN.matcher(forwarded);
        if (matcher.find()) {
            this.scheme = matcher.group(1).trim();
            this.port = -1;
            log.debugf("Using Forwarded 'proto' to set scheme to %s", (Object)this.scheme);
            forwardedValues.setScheme(this.scheme);
            forwardedValues.setPort(this.port);
        }
        if ((matcher = FORWARDED_HOST_PATTERN.matcher(forwarded)).find()) {
            this.setHostAndPort(matcher.group(1).trim(), this.port);
            log.debugf("Using Forwarded 'host' to set host to %s and port to %d", (Object)this.host, (Object)this.port);
            forwardedValues.setHost(this.host);
            forwardedValues.setPort(this.port);
        }
        if ((matcher = FORWARDED_FOR_PATTERN.matcher(forwarded)).find()) {
            this.remoteAddress = this.parseFor(matcher.group(1).trim(), this.remoteAddress != null ? this.remoteAddress.port() : this.port);
            forwardedValues.setRemoteHost(this.remoteAddress.host());
            forwardedValues.setRemotePort(this.remoteAddress.port());
            log.debugf("Using Forwarded 'for' to set for host to %s and for port to %d", (Object)this.remoteAddress.host(), (Object)this.remoteAddress.port());
        }
        return forwardedValues;
    }

    private Forwarded processXForwarded() {
        String forHeader;
        String portHeader;
        String prefixHeader;
        String hostHeader;
        String forwardedSsl;
        boolean isForwardedSslOn;
        Forwarded xForwardedValues = new Forwarded();
        String protocolHeader = this.delegate.getHeader((CharSequence)X_FORWARDED_PROTO);
        if (protocolHeader != null) {
            this.scheme = this.getFirstElement(protocolHeader);
            this.port = -1;
            log.debugf("Using X-Forwarded-Proto to set scheme to %s", (Object)this.scheme);
            xForwardedValues.setScheme(this.scheme);
            xForwardedValues.setPort(this.port);
        }
        boolean bl = isForwardedSslOn = (forwardedSsl = this.delegate.getHeader((CharSequence)X_FORWARDED_SSL)) != null && forwardedSsl.equalsIgnoreCase("on");
        if (isForwardedSslOn) {
            this.scheme = HTTPS_SCHEME;
            this.port = -1;
            log.debugf("Using X-Forwarded-Ssl to set scheme to %s", (Object)this.scheme);
            xForwardedValues.setScheme(this.scheme);
            xForwardedValues.setPort(this.port);
        }
        if (this.forwardingProxyOptions.enableForwardedHost && (hostHeader = this.delegate.getHeader((CharSequence)this.forwardingProxyOptions.forwardedHostHeader)) != null) {
            this.port = -1;
            this.setHostAndPort(this.getFirstElement(hostHeader), this.port);
            log.debugf("Using %s to set host to %s and port to %d", (Object)hostHeader, (Object)this.host, (Object)this.port);
            xForwardedValues.setHost(this.host);
            xForwardedValues.setPort(this.port);
        }
        if (this.forwardingProxyOptions.enableForwardedPrefix && (prefixHeader = this.delegate.getHeader((CharSequence)this.forwardingProxyOptions.forwardedPrefixHeader)) != null) {
            log.debugf("Using %s to prefix URI %s with prefix %s", (Object)this.forwardingProxyOptions.forwardedPrefixHeader, (Object)this.uri, (Object)prefixHeader);
            this.uri = this.appendPrefixToUri(prefixHeader, this.uri);
        }
        if ((portHeader = this.delegate.getHeader((CharSequence)X_FORWARDED_PORT)) != null) {
            this.port = this.parsePort(this.getFirstElement(portHeader), this.port);
            log.debugf("Using X-Forwarded-Port to set port to %d", this.port);
            xForwardedValues.setPort(this.port);
        }
        if ((forHeader = this.delegate.getHeader((CharSequence)X_FORWARDED_FOR)) != null) {
            this.remoteAddress = this.parseFor(this.getFirstElement(forHeader), this.remoteAddress != null ? this.remoteAddress.port() : this.port);
            xForwardedValues.setRemoteHost(this.remoteAddress.host());
            xForwardedValues.setRemotePort(this.remoteAddress.port());
            log.debugf("Using X-Forwarded-For to set for host to %s and for port to %d", (Object)this.remoteAddress.host(), (Object)this.remoteAddress.port());
        }
        return xForwardedValues;
    }

    private void setHostAndPort(String hostToParse, int defaultPort) {
        if (hostToParse == null) {
            hostToParse = "";
        }
        String[] hostAndPort = this.parseHostAndPort(hostToParse);
        this.host = hostAndPort[0];
        this.delegate.headers().set((CharSequence)HOST_HEADER, (CharSequence)this.host);
        this.port = this.parsePort(hostAndPort[1], defaultPort);
    }

    private SocketAddress parseFor(String forToParse, int defaultPort) {
        String[] hostAndPort = this.parseHostAndPort(forToParse);
        String host = hostAndPort[0];
        int port = this.parsePort(hostAndPort[1], defaultPort);
        return new SocketAddressImpl(port, host);
    }

    private String getFirstElement(String value) {
        int index = value.indexOf(44);
        return index == -1 ? value : value.substring(0, index);
    }

    private String[] parseHostAndPort(String hostToParse) {
        String[] hostAndPort = new String[]{hostToParse, ""};
        int portSeparatorIdx = hostToParse.lastIndexOf(58);
        int squareBracketIdx = hostToParse.lastIndexOf(93);
        if (squareBracketIdx > -1 && portSeparatorIdx > squareBracketIdx) {
            hostAndPort[0] = hostToParse.substring(0, portSeparatorIdx);
            hostAndPort[1] = hostToParse.substring(portSeparatorIdx + 1);
        } else {
            long numberOfColons = hostToParse.chars().filter(ch -> ch == 58).count();
            if (numberOfColons == 1L && !hostToParse.endsWith(":")) {
                hostAndPort[0] = hostToParse.substring(0, portSeparatorIdx);
                hostAndPort[1] = hostToParse.substring(portSeparatorIdx + 1);
            }
        }
        return hostAndPort;
    }

    private int parsePort(String portToParse, int defaultPort) {
        if (portToParse != null && portToParse.length() > 0) {
            try {
                int port = Integer.parseInt(portToParse);
                if (port < 0 || port > 65535) {
                    log.errorf("Failed to validate a port from \"forwarded\"-type headers, using the default port %d", (Object)defaultPort);
                    return defaultPort;
                }
                return port;
            }
            catch (NumberFormatException ignored) {
                log.errorf("Failed to parse a port from \"forwarded\"-type headers, using the default port %d", (Object)defaultPort);
            }
        }
        return defaultPort;
    }

    private String appendPrefixToUri(String prefix, String uri) {
        String parsed = this.stripSlashes(prefix);
        return parsed.isEmpty() ? uri : "/" + parsed + uri;
    }

    private String stripSlashes(String uri) {
        String result;
        if (!uri.isEmpty()) {
            int beginIndex = 0;
            if (uri.startsWith("/")) {
                beginIndex = 1;
            }
            int endIndex = uri.length();
            if (uri.endsWith("/") && uri.length() > 1) {
                endIndex = uri.length() - 1;
            }
            result = uri.substring(beginIndex, endIndex);
        } else {
            result = uri;
        }
        return result;
    }

    static class Forwarded {
        private static String SCHEME = "scheme";
        private static String HOST = "host";
        private static String PORT = "port";
        private static String REMOTE_HOST = "remote host";
        private static String REMOTE_PORT = "remote port";
        private Map<String, Object> forwarded = new HashMap<String, Object>();

        Forwarded() {
        }

        public void setScheme(String scheme) {
            this.forwarded.put(SCHEME, scheme);
        }

        public void setHost(String host) {
            this.forwarded.put(HOST, host);
        }

        public void setPort(Integer port) {
            this.forwarded.put(PORT, port);
        }

        public void setRemoteHost(String host) {
            this.forwarded.put(REMOTE_HOST, host);
        }

        public void setRemotePort(Integer port) {
            this.forwarded.put(REMOTE_PORT, port);
        }

        public boolean modifiedPropertiesMatch(Forwarded fw) {
            HashSet<String> keys = new HashSet<String>(this.forwarded.keySet());
            keys.retainAll(fw.forwarded.keySet());
            for (String key : keys) {
                if (this.forwarded.get(key).equals(fw.forwarded.get(key))) continue;
                log.debugf("Forwarded and X-Forwarded %s values do not match.", (Object)key);
                return false;
            }
            return true;
        }
    }
}

