/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.credential.PasswordCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TrustedAuthenticationRequest;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import io.quarkus.vertx.http.runtime.FormAuthConfig;
import io.quarkus.vertx.http.runtime.FormAuthRuntimeConfig;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.quarkus.vertx.http.runtime.security.PersistentLoginManager;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.RoutingContext;
import jakarta.inject.Inject;
import java.net.URI;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class FormAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static final String FORM = "form";
    private static final Logger log = Logger.getLogger(FormAuthenticationMechanism.class);
    private final String loginPage;
    private final String errorPage;
    private final String postLocation;
    private final String usernameParameter;
    private final String passwordParameter;
    private final String locationCookie;
    private final String landingPage;
    private final boolean redirectToLandingPage;
    private final boolean redirectToErrorPage;
    private final boolean redirectToLoginPage;
    private final CookieSameSite cookieSameSite;
    private final String cookiePath;
    private final PersistentLoginManager loginManager;
    static volatile String encryptionKey;

    @Inject
    FormAuthenticationMechanism(HttpConfiguration httpConfiguration, HttpBuildTimeConfig buildTimeConfig) {
        String key;
        if (!httpConfiguration.encryptionKey.isPresent()) {
            if (encryptionKey != null) {
                key = encryptionKey;
            } else {
                byte[] data = new byte[32];
                new SecureRandom().nextBytes(data);
                key = encryptionKey = Base64.getEncoder().encodeToString(data);
                log.warn((Object)("Encryption key was not specified for persistent FORM auth, using temporary key " + key));
            }
        } else {
            key = httpConfiguration.encryptionKey.get();
        }
        FormAuthConfig form = buildTimeConfig.auth.form;
        FormAuthRuntimeConfig runtimeForm = httpConfiguration.auth.form;
        this.loginManager = new PersistentLoginManager(key, runtimeForm.cookieName, runtimeForm.timeout.toMillis(), runtimeForm.newCookieInterval.toMillis(), runtimeForm.httpOnlyCookie, runtimeForm.cookieSameSite.name(), runtimeForm.cookiePath.orElse(null));
        this.loginPage = FormAuthenticationMechanism.startWithSlash(runtimeForm.loginPage.orElse(null));
        this.errorPage = FormAuthenticationMechanism.startWithSlash(runtimeForm.errorPage.orElse(null));
        this.landingPage = FormAuthenticationMechanism.startWithSlash(runtimeForm.landingPage.orElse(null));
        this.postLocation = FormAuthenticationMechanism.startWithSlash(form.postLocation);
        this.usernameParameter = runtimeForm.usernameParameter;
        this.passwordParameter = runtimeForm.passwordParameter;
        this.locationCookie = runtimeForm.locationCookie;
        this.cookiePath = runtimeForm.cookiePath.orElse(null);
        boolean redirectAfterLogin = runtimeForm.redirectAfterLogin;
        this.redirectToLandingPage = this.landingPage != null && redirectAfterLogin;
        this.redirectToLoginPage = this.loginPage != null;
        this.redirectToErrorPage = this.errorPage != null;
        this.cookieSameSite = CookieSameSite.valueOf((String)runtimeForm.cookieSameSite.name());
    }

    public FormAuthenticationMechanism(String loginPage, String postLocation, String usernameParameter, String passwordParameter, String errorPage, String landingPage, boolean redirectAfterLogin, String locationCookie, String cookieSameSite, String cookiePath, PersistentLoginManager loginManager) {
        this.loginPage = loginPage;
        this.postLocation = postLocation;
        this.usernameParameter = usernameParameter;
        this.passwordParameter = passwordParameter;
        this.locationCookie = locationCookie;
        this.errorPage = errorPage;
        this.landingPage = landingPage;
        this.redirectToLandingPage = landingPage != null && redirectAfterLogin;
        this.redirectToLoginPage = loginPage != null;
        this.redirectToErrorPage = errorPage != null;
        this.cookieSameSite = CookieSameSite.valueOf((String)cookieSameSite);
        this.cookiePath = cookiePath;
        this.loginManager = loginManager;
    }

    public Uni<SecurityIdentity> runFormAuth(final RoutingContext exchange, final IdentityProviderManager securityContext) {
        exchange.request().setExpectMultipart(true);
        return Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super SecurityIdentity>>(){

            @Override
            public void accept(final UniEmitter<? super SecurityIdentity> uniEmitter) {
                exchange.request().endHandler((Handler)new Handler<Void>(){

                    public void handle(Void event) {
                        try {
                            MultiMap res = exchange.request().formAttributes();
                            String jUsername = res.get(FormAuthenticationMechanism.this.usernameParameter);
                            String jPassword = res.get(FormAuthenticationMechanism.this.passwordParameter);
                            if (jUsername == null || jPassword == null) {
                                log.debugf("Could not authenticate as username or password was not present in the posted result for %s", (Object)exchange);
                                uniEmitter.complete(null);
                                return;
                            }
                            securityContext.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new UsernamePasswordAuthenticationRequest(jUsername, new PasswordCredential(jPassword.toCharArray())), exchange)).subscribe().with((Consumer)new Consumer<SecurityIdentity>(){

                                @Override
                                public void accept(SecurityIdentity identity) {
                                    try {
                                        FormAuthenticationMechanism.this.loginManager.save(identity, exchange, null, exchange.request().isSSL());
                                        if (FormAuthenticationMechanism.this.redirectToLandingPage || exchange.request().getCookie(FormAuthenticationMechanism.this.locationCookie) != null) {
                                            FormAuthenticationMechanism.this.handleRedirectBack(exchange);
                                        } else {
                                            exchange.response().setStatusCode(200);
                                            exchange.response().end();
                                        }
                                        uniEmitter.complete(null);
                                    }
                                    catch (Throwable t) {
                                        log.error((Object)"Unable to complete post authentication", t);
                                        uniEmitter.fail(t);
                                    }
                                }
                            }, (Consumer)new Consumer<Throwable>(){

                                @Override
                                public void accept(Throwable throwable) {
                                    uniEmitter.fail(throwable);
                                }
                            });
                        }
                        catch (Throwable t) {
                            uniEmitter.fail(t);
                        }
                    }
                });
                exchange.request().resume();
            }
        });
    }

    protected void handleRedirectBack(RoutingContext exchange) {
        Object location;
        Cookie redirect = exchange.request().getCookie(this.locationCookie);
        if (redirect != null) {
            this.verifyRedirectBackLocation(exchange.request().absoluteURI(), redirect.getValue());
            redirect.setSecure(exchange.request().isSSL());
            redirect.setSameSite(this.cookieSameSite);
            location = redirect.getValue();
            exchange.response().addCookie(redirect.setMaxAge(0L));
        } else {
            if (this.landingPage == null) {
                throw new IllegalStateException("Landing page is no set, please make sure 'quarkus.http.auth.form.landing-page' is configured properly.");
            }
            location = exchange.request().scheme() + "://" + String.valueOf(exchange.request().authority()) + this.landingPage;
        }
        exchange.response().setStatusCode(302);
        exchange.response().headers().add((CharSequence)HttpHeaderNames.LOCATION, (CharSequence)location);
        exchange.response().end();
    }

    protected void verifyRedirectBackLocation(String requestURIString, String redirectUriString) {
        URI requestUri = URI.create(requestURIString);
        URI redirectUri = URI.create(redirectUriString);
        if (!requestUri.getAuthority().equals(redirectUri.getAuthority()) || !requestUri.getScheme().equals(redirectUri.getScheme())) {
            log.errorf("Location cookie value %s does not match the current request URI %s's scheme, host or port", (Object)redirectUriString, (Object)requestURIString);
            throw new AuthenticationCompletionException();
        }
    }

    protected void storeInitialLocation(RoutingContext exchange) {
        exchange.response().addCookie(Cookie.cookie((String)this.locationCookie, (String)exchange.request().absoluteURI()).setPath(this.cookiePath).setSameSite(this.cookieSameSite).setSecure(exchange.request().isSSL()));
    }

    protected void servePage(RoutingContext exchange, String location) {
        FormAuthenticationMechanism.sendRedirect(exchange, location);
    }

    static void sendRedirect(RoutingContext exchange, String location) {
        String loc = exchange.request().scheme() + "://" + String.valueOf(exchange.request().authority()) + location;
        exchange.response().headers().add((CharSequence)HttpHeaderNames.LOCATION, (CharSequence)loc);
        exchange.response().setStatusCode(302);
        exchange.response().end();
    }

    static Uni<ChallengeData> getRedirect(RoutingContext exchange, String location) {
        String loc = exchange.request().scheme() + "://" + String.valueOf(exchange.request().authority()) + location;
        return Uni.createFrom().item((Object)new ChallengeData(302, "Location", loc));
    }

    @Override
    public Uni<SecurityIdentity> authenticate(final RoutingContext context, IdentityProviderManager identityProviderManager) {
        if (context.normalizedPath().endsWith(this.postLocation) && context.request().method().equals((Object)HttpMethod.POST)) {
            context.put(HttpAuthenticationMechanism.class.getName(), (Object)this);
            return this.runFormAuth(context, identityProviderManager);
        }
        final PersistentLoginManager.RestoreResult result = this.loginManager.restore(context);
        if (result != null) {
            context.put(HttpAuthenticationMechanism.class.getName(), (Object)this);
            Uni ret = identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new TrustedAuthenticationRequest(result.getPrincipal()), context));
            return ret.onItem().invoke((Consumer)new Consumer<SecurityIdentity>(){

                @Override
                public void accept(SecurityIdentity securityIdentity) {
                    FormAuthenticationMechanism.this.loginManager.save(securityIdentity, context, result, context.request().isSSL());
                }
            });
        }
        return Uni.createFrom().optional(Optional.empty());
    }

    @Override
    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        if (context.normalizedPath().endsWith(this.postLocation) && context.request().method().equals((Object)HttpMethod.POST)) {
            if (this.redirectToErrorPage) {
                log.debugf("Serving form auth error page %s for %s", (Object)this.errorPage, (Object)context);
                return FormAuthenticationMechanism.getRedirect(context, this.errorPage);
            }
        } else if (this.redirectToLoginPage) {
            log.debugf("Serving login form %s for %s", (Object)this.loginPage, (Object)context);
            this.storeInitialLocation(context);
            return FormAuthenticationMechanism.getRedirect(context, this.loginPage);
        }
        return Uni.createFrom().item((Object)new ChallengeData(HttpResponseStatus.UNAUTHORIZED.code(), null, null));
    }

    @Override
    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return new HashSet<Class<? extends AuthenticationRequest>>(Arrays.asList(UsernamePasswordAuthenticationRequest.class, TrustedAuthenticationRequest.class));
    }

    @Override
    public Uni<HttpCredentialTransport> getCredentialTransport(RoutingContext context) {
        return Uni.createFrom().item((Object)new HttpCredentialTransport(HttpCredentialTransport.Type.POST, this.postLocation, FORM));
    }

    private static String startWithSlash(String page) {
        if (page == null) {
            return null;
        }
        return page.startsWith("/") ? page : "/" + page;
    }
}

