/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AnnotationProxyBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.web.Route;
import io.quarkus.vertx.web.RoutingExchange;
import io.quarkus.vertx.web.deployment.AnnotatedRouteHandlerBuildItem;
import io.quarkus.vertx.web.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.web.runtime.RoutingExchangeImpl;
import io.quarkus.vertx.web.runtime.VertxWebRecorder;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class VertxWebProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)VertxWebProcessor.class.getName());
    private static final DotName ROUTE = DotName.createSimple((String)Route.class.getName());
    private static final DotName ROUTES = DotName.createSimple((String)Route.Routes.class.getName());
    private static final DotName ROUTING_CONTEXT = DotName.createSimple((String)RoutingContext.class.getName());
    private static final DotName RX_ROUTING_CONTEXT = DotName.createSimple((String)io.vertx.reactivex.ext.web.RoutingContext.class.getName());
    private static final DotName ROUTING_EXCHANGE = DotName.createSimple((String)RoutingExchange.class.getName());
    private static final String HANDLER_SUFFIX = "_RouteHandler";
    HttpConfiguration httpConfiguration;

    VertxWebProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("vertx-web");
    }

    @BuildStep
    void unremovableBeans(BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(ROUTE)));
        unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(ROUTES)));
    }

    @BuildStep
    void validateBeanDeployment(ValidationPhaseBuildItem validationPhase, BuildProducer<AnnotatedRouteHandlerBuildItem> routeHandlerBusinessMethods, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        AnnotationStore annotationStore = (AnnotationStore)validationPhase.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        for (BeanInfo bean : (List)validationPhase.getContext().get(BuildExtension.Key.BEANS)) {
            if (!bean.isClassBean()) continue;
            for (MethodInfo method : ((AnnotationTarget)bean.getTarget().get()).asClass().methods()) {
                AnnotationInstance routesAnnotation;
                LinkedList<AnnotationInstance> routes = new LinkedList<AnnotationInstance>();
                AnnotationInstance routeAnnotation = annotationStore.getAnnotation((AnnotationTarget)method, ROUTE);
                if (routeAnnotation != null) {
                    this.validateMethod(bean, method);
                    routes.add(routeAnnotation);
                }
                if (routes.isEmpty() && (routesAnnotation = annotationStore.getAnnotation((AnnotationTarget)method, ROUTES)) != null) {
                    this.validateMethod(bean, method);
                    Collections.addAll(routes, routesAnnotation.value().asNestedArray());
                }
                if (routes.isEmpty()) continue;
                LOGGER.debugf("Found route handler business method %s declared on %s", (Object)method, (Object)bean);
                routeHandlerBusinessMethods.produce((BuildItem)new AnnotatedRouteHandlerBuildItem(bean, method, routes));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    BodyHandlerBuildItem bodyHandler(VertxWebRecorder recorder, HttpConfiguration httpConfiguration) {
        return new BodyHandlerBuildItem((Handler<RoutingContext>)recorder.createBodyHandler(httpConfiguration));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void addAdditionalRoutes(VertxWebRecorder recorder, List<AnnotatedRouteHandlerBuildItem> routeHandlerBusinessMethods, final BuildProducer<GeneratedClassBuildItem> generatedClass, AnnotationProxyBuildItem annotationProxy, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BodyHandlerBuildItem bodyHandler, BuildProducer<RouteBuildItem> routeProducer) throws IOException {
        ClassOutput classOutput = new ClassOutput(){

            public void write(String name, byte[] data) {
                generatedClass.produce((BuildItem)new GeneratedClassBuildItem(true, name, data));
            }
        };
        for (AnnotatedRouteHandlerBuildItem businessMethod : routeHandlerBusinessMethods) {
            String handlerClass = this.generateHandler(businessMethod.getBean(), businessMethod.getMethod(), classOutput);
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{handlerClass}));
            Handler routingHandler = recorder.createHandler(handlerClass);
            for (AnnotationInstance routeAnnotation : businessMethod.getRoutes()) {
                Route route = (Route)annotationProxy.builder(routeAnnotation, Route.class).build(classOutput);
                Function routeFunction = recorder.createRouteFunction(route, bodyHandler.getHandler());
                AnnotationValue typeValue = routeAnnotation.value("type");
                HandlerType handlerType = HandlerType.NORMAL;
                if (typeValue != null) {
                    String typeString;
                    switch (typeString = typeValue.asEnum()) {
                        case "NORMAL": {
                            handlerType = HandlerType.NORMAL;
                            break;
                        }
                        case "BLOCKING": {
                            handlerType = HandlerType.BLOCKING;
                            break;
                        }
                        case "FAILURE": {
                            handlerType = HandlerType.FAILURE;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unkown type " + typeString);
                        }
                    }
                }
                routeProducer.produce((BuildItem)new RouteBuildItem(routeFunction, routingHandler, handlerType));
            }
        }
    }

    @BuildStep
    AnnotationsTransformerBuildItem annotationTransformer() {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                if (context.getAnnotations().isEmpty() && (context.getTarget().asClass().annotations().containsKey(ROUTE) || context.getTarget().asClass().annotations().containsKey(ROUTES))) {
                    LOGGER.debugf("Found route handler business methods on a class %s with no scope annotation - adding @Singleton", (Object)context.getTarget());
                    context.transform().add(Singleton.class, new AnnotationValue[0]).done();
                }
            }
        });
    }

    private void validateMethod(BeanInfo bean, MethodInfo method) {
        DotName paramTypeName;
        if (!method.returnType().kind().equals((Object)Type.Kind.VOID)) {
            throw new IllegalStateException(String.format("Route handler business method must return void [method: %s, bean: %s]", method, bean));
        }
        List params = method.parameters();
        boolean hasInvalidParam = true;
        if (params.size() == 1 && (ROUTING_CONTEXT.equals((Object)(paramTypeName = ((Type)params.get(0)).name())) || RX_ROUTING_CONTEXT.equals((Object)paramTypeName) || ROUTING_EXCHANGE.equals((Object)paramTypeName))) {
            hasInvalidParam = false;
        }
        if (hasInvalidParam) {
            throw new IllegalStateException(String.format("Route handler business method must accept exactly one parameter of type RoutingContext/RoutingExchange: %s [method: %s, bean: %s]", params, method, bean));
        }
    }

    private String generateHandler(BeanInfo bean, MethodInfo method, ClassOutput classOutput) {
        MethodDescriptor methodDescriptor;
        ResultHandle paramHandle;
        String baseName = bean.getImplClazz().enclosingClass() != null ? DotNames.simpleName((DotName)bean.getImplClazz().enclosingClass()) + "_" + DotNames.simpleName((DotName)bean.getImplClazz().name()) : DotNames.simpleName((DotName)bean.getImplClazz().name());
        String targetPackage = DotNames.packageName((DotName)bean.getImplClazz().name());
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(method.name()).append("_").append(method.returnType().name().toString());
        for (Type i : method.parameters()) {
            sigBuilder.append(i.name().toString());
        }
        String generatedName = targetPackage.replace('.', '/') + "/" + baseName + HANDLER_SUFFIX + "_" + method.name() + "_" + HashUtil.sha1((String)sigBuilder.toString());
        ClassCreator invokerCreator = ClassCreator.builder().classOutput(classOutput).className(generatedName).interfaces(new Class[]{Handler.class}).build();
        MethodCreator invoke = invokerCreator.getMethodCreator("handle", Void.TYPE, new Class[]{Object.class});
        ResultHandle containerHandle = invoke.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle beanHandle = invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"bean", InjectableBean.class, (Class[])new Class[]{String.class}), containerHandle, new ResultHandle[]{invoke.load(bean.getIdentifier())});
        ResultHandle instanceHandle = invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{InjectableBean.class}), containerHandle, new ResultHandle[]{beanHandle});
        ResultHandle beanInstanceHandle = invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
        if (((Type)method.parameters().get(0)).name().equals((Object)ROUTING_CONTEXT)) {
            paramHandle = invoke.getMethodParam(0);
            methodDescriptor = MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{RoutingContext.class});
        } else if (((Type)method.parameters().get(0)).name().equals((Object)RX_ROUTING_CONTEXT)) {
            paramHandle = invoke.newInstance(MethodDescriptor.ofConstructor(io.vertx.reactivex.ext.web.RoutingContext.class, (Class[])new Class[]{RoutingContext.class}), new ResultHandle[]{invoke.getMethodParam(0)});
            methodDescriptor = MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{io.vertx.reactivex.ext.web.RoutingContext.class});
        } else {
            paramHandle = invoke.newInstance(MethodDescriptor.ofConstructor(RoutingExchangeImpl.class, (Class[])new Class[]{RoutingContext.class}), new ResultHandle[]{invoke.getMethodParam(0)});
            methodDescriptor = MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{RoutingExchange.class});
        }
        invoke.invokeVirtualMethod(methodDescriptor, beanInstanceHandle, new ResultHandle[]{paramHandle});
        if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
            invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"destroy", Void.TYPE, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
        }
        invoke.returnValue(null);
        invokerCreator.close();
        return generatedName.replace('/', '.');
    }
}

