/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web.deployment;

import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.gizmo.WhileLoop;
import io.quarkus.hibernate.validator.spi.BeanValidationAnnotationsBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RequireBodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.VertxWebRouterBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.deployment.devmode.RouteDescriptionBuildItem;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.quarkus.vertx.web.Route;
import io.quarkus.vertx.web.deployment.AnnotatedRouteFilterBuildItem;
import io.quarkus.vertx.web.deployment.AnnotatedRouteHandlerBuildItem;
import io.quarkus.vertx.web.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.web.deployment.DotNames;
import io.quarkus.vertx.web.deployment.HandlerDescriptor;
import io.quarkus.vertx.web.deployment.Methods;
import io.quarkus.vertx.web.runtime.RouteHandler;
import io.quarkus.vertx.web.runtime.RouteMatcher;
import io.quarkus.vertx.web.runtime.RoutingExchangeImpl;
import io.quarkus.vertx.web.runtime.UniFailureCallback;
import io.quarkus.vertx.web.runtime.VertxWebRecorder;
import io.quarkus.vertx.web.runtime.devmode.ResourceNotFoundRecorder;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.reactivex.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class VertxWebProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)VertxWebProcessor.class.getName());
    private static final String HANDLER_SUFFIX = "_RouteHandler";
    private static final String VALUE_PATH = "path";
    private static final String VALUE_REGEX = "regex";
    private static final String VALUE_PRODUCES = "produces";
    private static final String VALUE_CONSUMES = "consumes";
    private static final String VALUE_METHODS = "methods";
    private static final String VALUE_ORDER = "order";
    private static final String VALUE_TYPE = "type";
    private static final String SLASH = "/";
    private static final List<ParameterInjector> PARAM_INJECTORS = VertxWebProcessor.initParamInjectors();
    private static final List<DotName> TYPES_IGNORED_FOR_REFLECTION = Arrays.asList(io.quarkus.arc.processor.DotNames.STRING, DotNames.BUFFER, DotNames.JSON_ARRAY, DotNames.JSON_OBJECT);

    VertxWebProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.VERTX_WEB);
    }

    @BuildStep
    void unremovableBeans(BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassAnnotation((DotName)DotNames.ROUTE));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassAnnotation((DotName)DotNames.ROUTES));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassAnnotation((DotName)DotNames.ROUTE_FILTER));
    }

    @BuildStep
    void validateBeanDeployment(BeanArchiveIndexBuildItem beanArchive, ValidationPhaseBuildItem validationPhase, TransformedAnnotationsBuildItem transformedAnnotations, BuildProducer<AnnotatedRouteHandlerBuildItem> routeHandlerBusinessMethods, BuildProducer<AnnotatedRouteFilterBuildItem> routeFilterBusinessMethods, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        AnnotationStore annotationStore = (AnnotationStore)validationPhase.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        for (BeanInfo bean : validationPhase.getContext().beans().classBeans()) {
            ClassInfo beanClass = ((AnnotationTarget)bean.getTarget().get()).asClass();
            AnnotationInstance routeBaseAnnotation = beanClass.classAnnotation(DotNames.ROUTE_BASE);
            for (MethodInfo method : beanClass.methods()) {
                AnnotationInstance filterAnnotation;
                AnnotationInstance routesAnnotation;
                LinkedList<AnnotationInstance> routes = new LinkedList<AnnotationInstance>();
                AnnotationInstance routeAnnotation = annotationStore.getAnnotation((AnnotationTarget)method, DotNames.ROUTE);
                if (routeAnnotation != null) {
                    this.validateRouteMethod(bean, method, transformedAnnotations, beanArchive.getIndex(), routeAnnotation);
                    routes.add(routeAnnotation);
                }
                if (routes.isEmpty() && (routesAnnotation = annotationStore.getAnnotation((AnnotationTarget)method, DotNames.ROUTES)) != null) {
                    for (AnnotationInstance annotation : routesAnnotation.value().asNestedArray()) {
                        this.validateRouteMethod(bean, method, transformedAnnotations, beanArchive.getIndex(), annotation);
                        routes.add(annotation);
                    }
                }
                if (!routes.isEmpty()) {
                    LOGGER.debugf("Found route handler business method %s declared on %s", (Object)method, (Object)bean);
                    routeHandlerBusinessMethods.produce((BuildItem)new AnnotatedRouteHandlerBuildItem(bean, method, routes, routeBaseAnnotation));
                }
                if ((filterAnnotation = annotationStore.getAnnotation((AnnotationTarget)method, DotNames.ROUTE_FILTER)) == null) continue;
                if (!routes.isEmpty()) {
                    errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException(String.format("@Route and @RouteFilter cannot be declared on business method %s declared on %s", method, bean))}));
                    continue;
                }
                this.validateRouteFilterMethod(bean, method);
                routeFilterBusinessMethods.produce((BuildItem)new AnnotatedRouteFilterBuildItem(bean, method, filterAnnotation));
                LOGGER.debugf("Found route filter business method %s declared on %s", (Object)method, (Object)bean);
            }
        }
    }

    @BuildStep
    BodyHandlerBuildItem bodyHandler(io.quarkus.vertx.http.deployment.BodyHandlerBuildItem realOne) {
        return new BodyHandlerBuildItem((Handler<io.vertx.ext.web.RoutingContext>)realOne.getHandler());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void addAdditionalRoutes(VertxWebRecorder recorder, List<AnnotatedRouteHandlerBuildItem> routeHandlerBusinessMethods, List<AnnotatedRouteFilterBuildItem> routeFilterBusinessMethods, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, io.quarkus.vertx.http.deployment.BodyHandlerBuildItem bodyHandler, BuildProducer<RouteBuildItem> routeProducer, BuildProducer<FilterBuildItem> filterProducer, List<RequireBodyHandlerBuildItem> bodyHandlerRequired, BeanArchiveIndexBuildItem beanArchive, TransformedAnnotationsBuildItem transformedAnnotations, ShutdownContextBuildItem shutdown, LaunchModeBuildItem launchMode, BuildProducer<RouteDescriptionBuildItem> descriptions, Capabilities capabilities, Optional<BeanValidationAnnotationsBuildItem> beanValidationAnnotations) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
        IndexView index = beanArchive.getIndex();
        HashMap<RouteMatcher, MethodInfo> matchers = new HashMap<RouteMatcher, MethodInfo>();
        boolean validatorAvailable = capabilities.isPresent(Capability.HIBERNATE_VALIDATOR);
        for (AnnotatedRouteHandlerBuildItem businessMethod : routeHandlerBusinessMethods) {
            AnnotationInstance routeBaseAnnotation = businessMethod.getRouteBase();
            String pathPrefix = null;
            String[] baseProduces = null;
            String[] baseConsumes = null;
            if (routeBaseAnnotation != null) {
                AnnotationValue consumesValue;
                AnnotationValue producesValue;
                AnnotationValue pathPrefixValue = routeBaseAnnotation.value(VALUE_PATH);
                if (pathPrefixValue != null) {
                    pathPrefix = pathPrefixValue.asString();
                }
                if ((producesValue = routeBaseAnnotation.value(VALUE_PRODUCES)) != null) {
                    baseProduces = producesValue.asStringArray();
                }
                if ((consumesValue = routeBaseAnnotation.value(VALUE_CONSUMES)) != null) {
                    baseConsumes = consumesValue.asStringArray();
                }
            }
            HashMap<String, Handler> routeHandlers = new HashMap<String, Handler>();
            for (AnnotationInstance route : businessMethod.getRoutes()) {
                String routeString = route.toString(true);
                Handler routeHandler = (Handler)routeHandlers.get(routeString);
                AnnotationValue regexValue = route.value(VALUE_REGEX);
                AnnotationValue pathValue = route.value(VALUE_PATH);
                AnnotationValue orderValue = route.valueWithDefault(index, VALUE_ORDER);
                AnnotationValue producesValue = route.valueWithDefault(index, VALUE_PRODUCES);
                AnnotationValue consumesValue = route.valueWithDefault(index, VALUE_CONSUMES);
                AnnotationValue methodsValue = route.valueWithDefault(index, VALUE_METHODS);
                String path = null;
                String regex = null;
                String[] produces = producesValue.asStringArray();
                String[] consumes = consumesValue.asStringArray();
                AnnotationValue typeValue = route.value(VALUE_TYPE);
                Route.HandlerType routeHandlerType = typeValue == null ? Route.HandlerType.NORMAL : Route.HandlerType.from((String)typeValue.asEnum());
                HttpMethod[] methods = (HttpMethod[])Arrays.stream(methodsValue.asEnumArray()).map(HttpMethod::valueOf).toArray(HttpMethod[]::new);
                Integer order = orderValue.asInt();
                if (regexValue == null) {
                    if (pathPrefix != null) {
                        StringBuilder prefixedPath = new StringBuilder();
                        prefixedPath.append(pathPrefix);
                        if (pathValue == null) {
                            prefixedPath.append(SLASH);
                            prefixedPath.append(VertxWebProcessor.dashify(businessMethod.getMethod().name()));
                        } else {
                            if (!pathValue.asString().startsWith(SLASH)) {
                                prefixedPath.append(SLASH);
                            }
                            prefixedPath.append(pathValue.asString());
                        }
                        path = prefixedPath.toString();
                    } else if (routeHandlerType != Route.HandlerType.FAILURE) {
                        String string = path = pathValue != null ? pathValue.asString() : VertxWebProcessor.dashify(businessMethod.getMethod().name());
                    }
                    if (path != null && !path.startsWith(SLASH)) {
                        path = SLASH + path;
                    }
                } else {
                    regex = regexValue.asString();
                }
                if (route.value(VALUE_PRODUCES) == null && baseProduces != null) {
                    produces = baseProduces;
                }
                if (route.value(VALUE_CONSUMES) == null && baseConsumes != null) {
                    consumes = baseConsumes;
                }
                HandlerType handlerType = HandlerType.NORMAL;
                if (typeValue != null) {
                    switch (routeHandlerType) {
                        case NORMAL: {
                            handlerType = HandlerType.NORMAL;
                            break;
                        }
                        case BLOCKING: {
                            handlerType = HandlerType.BLOCKING;
                            break;
                        }
                        case FAILURE: {
                            handlerType = HandlerType.FAILURE;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown type " + routeHandlerType);
                        }
                    }
                }
                if (businessMethod.getMethod().annotation(DotNames.BLOCKING) != null) {
                    if (handlerType == HandlerType.NORMAL) {
                        handlerType = HandlerType.BLOCKING;
                    } else if (handlerType == HandlerType.FAILURE) {
                        throw new IllegalStateException("Invalid combination - a reactive route cannot use @Blocking and use the type `failure` at the same time: " + businessMethod.getMethod().toString());
                    }
                }
                if (routeHandler == null) {
                    String handlerClass = this.generateHandler(new HandlerDescriptor(businessMethod.getMethod(), beanValidationAnnotations.orElse(null), handlerType), businessMethod.getBean(), businessMethod.getMethod(), (ClassOutput)classOutput, transformedAnnotations, routeString, reflectiveHierarchy, produces.length > 0 ? produces[0] : null, validatorAvailable, index);
                    reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{handlerClass}));
                    routeHandler = recorder.createHandler(handlerClass);
                    routeHandlers.put(routeString, routeHandler);
                }
                RouteMatcher matcher = new RouteMatcher(path, regex, produces, consumes, methods, order.intValue());
                matchers.put(matcher, businessMethod.getMethod());
                Function routeFunction = recorder.createRouteFunction(matcher, bodyHandler.getHandler());
                routeProducer.produce((BuildItem)new RouteBuildItem(routeFunction, routeHandler, handlerType));
                if (!launchMode.getLaunchMode().equals((Object)LaunchMode.DEVELOPMENT)) continue;
                if (methods.length == 0) {
                    methods = HttpMethod.values();
                }
                descriptions.produce((BuildItem)new RouteDescriptionBuildItem(businessMethod.getMethod().declaringClass().name().withoutPackagePrefix() + "#" + businessMethod.getMethod().name() + "()", regex != null ? regex : path, Arrays.stream(methods).map(Object::toString).collect(Collectors.joining(", ")), produces, consumes));
            }
        }
        for (AnnotatedRouteFilterBuildItem filterMethod : routeFilterBusinessMethods) {
            String handlerClass = this.generateHandler(new HandlerDescriptor(filterMethod.getMethod(), beanValidationAnnotations.orElse(null), HandlerType.NORMAL), filterMethod.getBean(), filterMethod.getMethod(), (ClassOutput)classOutput, transformedAnnotations, filterMethod.getRouteFilter().toString(true), reflectiveHierarchy, null, validatorAvailable, index);
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{handlerClass}));
            Handler routingHandler = recorder.createHandler(handlerClass);
            AnnotationValue priorityValue = filterMethod.getRouteFilter().value();
            filterProducer.produce((BuildItem)new FilterBuildItem(routingHandler, priorityValue != null ? priorityValue.asInt() : 10));
        }
        this.detectConflictingRoutes(matchers);
        recorder.clearCacheOnShutdown((ShutdownContext)shutdown);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void routeNotFound(Capabilities capabilities, ResourceNotFoundRecorder recorder, VertxWebRouterBuildItem router, List<RouteDescriptionBuildItem> descriptions, HttpRootPathBuildItem httpRoot, List<NotFoundPageDisplayableEndpointBuildItem> additionalEndpoints) {
        if (capabilities.isMissing(Capability.RESTEASY)) {
            recorder.registerNotFoundHandler(router.getRouter(), httpRoot.getRootPath(), descriptions.stream().map(RouteDescriptionBuildItem::getDescription).collect(Collectors.toList()), additionalEndpoints.stream().map(NotFoundPageDisplayableEndpointBuildItem::getEndpoint).collect(Collectors.toList()));
        }
    }

    @BuildStep
    AutoAddScopeBuildItem autoAddScope() {
        return AutoAddScopeBuildItem.builder().containsAnnotations(new DotName[]{DotNames.ROUTE, DotNames.ROUTES, DotNames.ROUTE_FILTER}).defaultScope(BuiltinScope.SINGLETON).reason("Found route handler business methods").build();
    }

    private void validateRouteFilterMethod(BeanInfo bean, MethodInfo method) {
        if (!method.returnType().kind().equals((Object)Type.Kind.VOID)) {
            throw new IllegalStateException(String.format("Route filter method must return void [method: %s, bean: %s]", method, bean));
        }
        List params = method.parameters();
        if (params.size() != 1 || !((Type)params.get(0)).name().equals((Object)DotNames.ROUTING_CONTEXT)) {
            throw new IllegalStateException(String.format("Route filter method must accept exactly one parameter of type %s: %s [method: %s, bean: %s]", DotNames.ROUTING_CONTEXT, params, method, bean));
        }
    }

    private void validateRouteMethod(BeanInfo bean, MethodInfo method, TransformedAnnotationsBuildItem transformedAnnotations, IndexView index, AnnotationInstance routeAnnotation) {
        List params = method.parameters();
        if (params.isEmpty()) {
            if (method.returnType().kind() == Type.Kind.VOID && params.isEmpty()) {
                throw new IllegalStateException(String.format("Route method that returns void must accept at least one injectable parameter [method: %s, bean: %s]", method, bean));
            }
        } else {
            Route.HandlerType handlerType;
            AnnotationValue typeValue = routeAnnotation.value(VALUE_TYPE);
            Route.HandlerType handlerType2 = handlerType = typeValue == null ? Route.HandlerType.NORMAL : Route.HandlerType.from((String)typeValue.asEnum());
            if ((method.returnType().name().equals((Object)DotNames.UNI) || method.returnType().name().equals((Object)DotNames.MULTI)) && method.returnType().kind() == Type.Kind.CLASS) {
                throw new IllegalStateException(String.format("Route business method returning a Uni/Multi must have a generic parameter [method: %s, bean: %s]", method, bean));
            }
            int idx = 0;
            int failureParams = 0;
            for (Type paramType : params) {
                Set paramAnnotations;
                List<ParameterInjector> injectors = this.getMatchingInjectors(paramType, paramAnnotations = Annotations.getParameterAnnotations((Function)transformedAnnotations, (MethodInfo)method, (int)idx), index);
                if (injectors.isEmpty()) {
                    throw new IllegalStateException(String.format("No parameter injector found for parameter %s of route method %s declared on %s", idx, method, bean));
                }
                if (injectors.size() > 1) {
                    throw new IllegalStateException(String.format("Multiple parameter injectors found for parameter %s of route method %s declared on %s", idx, method, bean));
                }
                ParameterInjector injector = injectors.get(0);
                if (injector.getTargetHandlerType() != null && !injector.getTargetHandlerType().equals((Object)handlerType)) {
                    throw new IllegalStateException(String.format("HandlerType.%s is not legal for parameter %s of route method %s declared on %s", injector.getTargetHandlerType(), idx, method, bean));
                }
                if (Route.HandlerType.FAILURE == handlerType && VertxWebProcessor.isThrowable(paramType, index)) {
                    ++failureParams;
                }
                ++idx;
            }
            if (failureParams > 1) {
                throw new IllegalStateException(String.format("A failure handler may only define one failure parameter - route method %s declared on %s", method, bean));
            }
        }
    }

    private String generateHandler(HandlerDescriptor desc, BeanInfo bean, MethodInfo method, ClassOutput classOutput, TransformedAnnotationsBuildItem transformedAnnotations, String hashSuffix, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, String defaultProduces, boolean validatorAvailable, IndexView index) {
        if (desc.requireValidation() && !validatorAvailable) {
            throw new IllegalStateException("A route requires validation, but the Hibernate Validator extension is not present");
        }
        String baseName = bean.getImplClazz().enclosingClass() != null ? io.quarkus.arc.processor.DotNames.simpleName((DotName)bean.getImplClazz().enclosingClass()) + "_" + io.quarkus.arc.processor.DotNames.simpleName((DotName)bean.getImplClazz().name()) : io.quarkus.arc.processor.DotNames.simpleName((DotName)bean.getImplClazz().name());
        String targetPackage = io.quarkus.arc.processor.DotNames.packageName((DotName)bean.getImplClazz().name());
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(method.name()).append("_").append(method.returnType().name().toString());
        for (Type i : method.parameters()) {
            sigBuilder.append(i.name().toString());
        }
        String generatedName = targetPackage.replace('.', '/') + SLASH + baseName + HANDLER_SUFFIX + "_" + method.name() + "_" + HashUtil.sha1((String)(sigBuilder.toString() + hashSuffix));
        ClassCreator invokerCreator = ClassCreator.builder().classOutput(classOutput).className(generatedName).interfaces(new Class[]{RouteHandler.class}).build();
        FieldCreator beanField = (FieldCreator)invokerCreator.getFieldCreator("bean", InjectableBean.class).setModifiers(18);
        FieldCreator contextField = null;
        FieldCreator containerField = null;
        if (BuiltinScope.APPLICATION.is(bean.getScope()) || BuiltinScope.SINGLETON.is(bean.getScope())) {
            contextField = (FieldCreator)invokerCreator.getFieldCreator("context", InjectableContext.class).setModifiers(18);
        } else {
            containerField = (FieldCreator)invokerCreator.getFieldCreator("container", ArcContainer.class).setModifiers(18);
        }
        FieldCreator validatorField = null;
        if (desc.isProducedResponseValidated()) {
            validatorField = (FieldCreator)invokerCreator.getFieldCreator("validator", "javax.validation.Validator").setModifiers(17);
        }
        this.implementConstructor(bean, invokerCreator, beanField, contextField, containerField, validatorField);
        this.implementInvoke(desc, bean, method, invokerCreator, beanField, contextField, containerField, validatorField, transformedAnnotations, reflectiveHierarchy, defaultProduces, index);
        invokerCreator.close();
        return generatedName.replace('/', '.');
    }

    void implementConstructor(BeanInfo bean, ClassCreator invokerCreator, FieldCreator beanField, FieldCreator contextField, FieldCreator containerField, FieldCreator validatorField) {
        MethodCreator constructor = invokerCreator.getMethodCreator("<init>", Void.TYPE, new Class[0]);
        constructor.invokeSpecialMethod(Methods.OBJECT_CONSTRUCTOR, constructor.getThis(), new ResultHandle[0]);
        ResultHandle containerHandle = constructor.invokeStaticMethod(Methods.ARC_CONTAINER, new ResultHandle[0]);
        ResultHandle beanHandle = constructor.invokeInterfaceMethod(Methods.ARC_CONTAINER_BEAN, containerHandle, new ResultHandle[]{constructor.load(bean.getIdentifier())});
        constructor.writeInstanceField(beanField.getFieldDescriptor(), constructor.getThis(), beanHandle);
        if (contextField != null) {
            constructor.writeInstanceField(contextField.getFieldDescriptor(), constructor.getThis(), constructor.invokeInterfaceMethod(Methods.ARC_CONTAINER_GET_ACTIVE_CONTEXT, containerHandle, new ResultHandle[]{constructor.invokeInterfaceMethod(Methods.BEAN_GET_SCOPE, beanHandle, new ResultHandle[0])}));
        } else {
            constructor.writeInstanceField(containerField.getFieldDescriptor(), constructor.getThis(), containerHandle);
        }
        if (validatorField != null) {
            constructor.writeInstanceField(validatorField.getFieldDescriptor(), constructor.getThis(), constructor.invokeStaticMethod(Methods.VALIDATION_GET_VALIDATOR, new ResultHandle[]{containerHandle}));
        }
        constructor.returnValue(null);
    }

    void implementInvoke(HandlerDescriptor descriptor, BeanInfo bean, MethodInfo method, ClassCreator invokerCreator, FieldCreator beanField, FieldCreator contextField, FieldCreator containerField, FieldCreator validatorField, TransformedAnnotationsBuildItem transformedAnnotations, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, String defaultProduces, IndexView index) {
        ResultHandle response;
        Type failureType;
        MethodCreator invoke = invokerCreator.getMethodCreator("invoke", Void.TYPE, new Class[]{io.vertx.ext.web.RoutingContext.class});
        ResultHandle beanHandle = invoke.readInstanceField(beanField.getFieldDescriptor(), invoke.getThis());
        AssignableResultHandle beanInstanceHandle = invoke.createVariable(Object.class);
        AssignableResultHandle creationlContextHandle = invoke.createVariable(CreationalContextImpl.class);
        if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
            invoke.assign(creationlContextHandle, invoke.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{beanHandle}));
            invoke.assign(beanInstanceHandle, invoke.invokeInterfaceMethod(Methods.INJECTABLE_REF_PROVIDER_GET, beanHandle, new ResultHandle[]{creationlContextHandle}));
        } else {
            ResultHandle contextInvokeHandle;
            if (contextField != null) {
                contextInvokeHandle = invoke.readInstanceField(contextField.getFieldDescriptor(), invoke.getThis());
            } else {
                ResultHandle containerInvokeHandle = invoke.readInstanceField(containerField.getFieldDescriptor(), invoke.getThis());
                contextInvokeHandle = invoke.invokeInterfaceMethod(Methods.ARC_CONTAINER_GET_ACTIVE_CONTEXT, containerInvokeHandle, new ResultHandle[]{invoke.invokeInterfaceMethod(Methods.BEAN_GET_SCOPE, beanHandle, new ResultHandle[0])});
                invoke.ifNull(contextInvokeHandle).trueBranch().throwException(ContextNotActiveException.class, "Context not active: " + bean.getScope().getDotName());
            }
            invoke.assign(beanInstanceHandle, invoke.invokeInterfaceMethod(Methods.CONTEXT_GET_IF_PRESENT, contextInvokeHandle, new ResultHandle[]{beanHandle}));
            BytecodeCreator doesNotExist = invoke.ifNull((ResultHandle)beanInstanceHandle).trueBranch();
            doesNotExist.assign(beanInstanceHandle, doesNotExist.invokeInterfaceMethod(Methods.CONTEXT_GET, contextInvokeHandle, new ResultHandle[]{beanHandle, doesNotExist.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{beanHandle})}));
        }
        List parameters = method.parameters();
        ResultHandle[] paramHandles = new ResultHandle[parameters.size()];
        String returnType = descriptor.getReturnType().name().toString();
        String[] parameterTypes = new String[parameters.size()];
        ResultHandle routingContext = invoke.getMethodParam(0);
        int idx = 0;
        for (Type paramType : parameters) {
            Set paramAnnotations = Annotations.getParameterAnnotations((Function)transformedAnnotations, (MethodInfo)method, (int)idx);
            paramHandles[idx] = this.getMatchingInjectors(paramType, paramAnnotations, index).get(0).getResultHandle(method, paramType, paramAnnotations, routingContext, invoke, idx, reflectiveHierarchy);
            parameterTypes[idx] = paramType.name().toString();
            ++idx;
        }
        MethodDescriptor methodDescriptor = MethodDescriptor.ofMethod((String)bean.getImplClazz().name().toString(), (String)method.name(), (String)returnType, (String[])parameterTypes);
        invoke.invokeStaticMethod(Methods.ROUTE_HANDLERS_SET_CONTENT_TYPE, new ResultHandle[]{routingContext, defaultProduces == null ? invoke.loadNull() : invoke.load(defaultProduces)});
        if (descriptor.getHandlerType() == HandlerType.FAILURE && (failureType = this.getFailureType(parameters, index)) != null) {
            ResultHandle failure = invoke.invokeInterfaceMethod(Methods.FAILURE, routingContext, new ResultHandle[0]);
            BytecodeCreator failureIsNull = invoke.ifNull(failure).trueBranch();
            failureIsNull.invokeInterfaceMethod(Methods.NEXT, routingContext, new ResultHandle[0]);
            failureIsNull.returnValue(null);
            ResultHandle failureClass = invoke.invokeVirtualMethod(Methods.GET_CLASS, failure, new ResultHandle[0]);
            BytecodeCreator failureTypeIsNotAssignable = invoke.ifFalse(invoke.invokeVirtualMethod(Methods.IS_ASSIGNABLE_FROM, invoke.loadClass(failureType.name().toString()), new ResultHandle[]{failureClass})).trueBranch();
            failureTypeIsNotAssignable.invokeInterfaceMethod(Methods.NEXT, routingContext, new ResultHandle[0]);
            failureTypeIsNotAssignable.returnValue(null);
        }
        AssignableResultHandle res = descriptor.isReturningUni() ? invoke.createVariable(Uni.class) : (descriptor.isReturningMulti() ? invoke.createVariable(Multi.class) : invoke.createVariable(Object.class));
        invoke.assign(res, invoke.loadNull());
        if (!descriptor.requireValidation()) {
            ResultHandle value = invoke.invokeVirtualMethod(methodDescriptor, (ResultHandle)beanInstanceHandle, paramHandles);
            if (value != null) {
                invoke.assign(res, value);
            }
        } else {
            TryBlock block = invoke.tryBlock();
            ResultHandle value = block.invokeVirtualMethod(methodDescriptor, (ResultHandle)beanInstanceHandle, paramHandles);
            if (value != null) {
                block.assign(res, value);
            }
            CatchBlockCreator caught = block.addCatch("javax.validation.ConstraintViolationException");
            caught.invokeStaticMethod(Methods.VALIDATION_HANDLE_VIOLATION_EXCEPTION, new ResultHandle[]{caught.getCaughtException(), invoke.getMethodParam(0)});
            caught.returnValue(caught.loadNull());
        }
        MethodDescriptor end = Methods.getEndMethodForContentType(descriptor);
        if (descriptor.isReturningUni()) {
            response = invoke.invokeInterfaceMethod(Methods.RESPONSE, routingContext, new ResultHandle[0]);
            FunctionCreator successCallback = this.getUniOnItemCallback(descriptor, invoke, routingContext, end, response, validatorField);
            ResultHandle failureCallback = this.getUniOnFailureCallback(invoke, routingContext);
            ResultHandle sub = invoke.invokeInterfaceMethod(Methods.UNI_SUBSCRIBE, (ResultHandle)res, new ResultHandle[0]);
            invoke.invokeVirtualMethod(Methods.UNI_SUBSCRIBE_WITH, sub, new ResultHandle[]{successCallback.getInstance(), failureCallback});
            VertxWebProcessor.registerForReflection(descriptor.getContentType(), reflectiveHierarchy);
        } else if (descriptor.isReturningMulti()) {
            BranchResult isItSSE = invoke.ifTrue(invoke.invokeStaticMethod(Methods.IS_SSE, new ResultHandle[]{res}));
            BytecodeCreator isSSE = isItSSE.trueBranch();
            this.handleSSEMulti(descriptor, isSSE, routingContext, (ResultHandle)res);
            isSSE.close();
            BytecodeCreator isNotSSE = isItSSE.falseBranch();
            BranchResult isItJson = isNotSSE.ifTrue(isNotSSE.invokeStaticMethod(Methods.IS_JSON_ARRAY, new ResultHandle[]{res}));
            BytecodeCreator isJson = isItJson.trueBranch();
            this.handleJsonArrayMulti(descriptor, isJson, routingContext, (ResultHandle)res);
            isJson.close();
            BytecodeCreator isRegular = isItJson.falseBranch();
            this.handleRegularMulti(descriptor, isRegular, routingContext, (ResultHandle)res);
            isRegular.close();
            isNotSSE.close();
            VertxWebProcessor.registerForReflection(descriptor.getContentType(), reflectiveHierarchy);
        } else if (descriptor.getContentType() != null) {
            response = invoke.invokeInterfaceMethod(Methods.RESPONSE, routingContext, new ResultHandle[0]);
            ResultHandle content = this.getContentToWrite(descriptor, response, (ResultHandle)res, (BytecodeCreator)invoke, validatorField, invoke.getThis());
            invoke.invokeInterfaceMethod(end, response, new ResultHandle[]{content});
            VertxWebProcessor.registerForReflection(descriptor.getContentType(), reflectiveHierarchy);
        }
        if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
            invoke.invokeInterfaceMethod(Methods.INJECTABLE_BEAN_DESTROY, beanHandle, new ResultHandle[]{beanInstanceHandle, creationlContextHandle});
        }
        invoke.returnValue(null);
    }

    private Type getFailureType(List<Type> parameters, IndexView index) {
        for (Type paramType : parameters) {
            if (!VertxWebProcessor.isThrowable(paramType, index)) continue;
            return paramType;
        }
        return null;
    }

    private static boolean isThrowable(Type paramType, IndexView index) {
        ClassInfo aClass = index.getClassByName(paramType.name());
        while (aClass != null && aClass.superName() != null) {
            if (DotNames.EXCEPTION.equals((Object)aClass.superName()) || DotNames.THROWABLE.equals((Object)aClass.superName())) {
                return true;
            }
            aClass = index.getClassByName(aClass.superName());
        }
        return false;
    }

    private static void registerForReflection(Type contentType, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
        if (TYPES_IGNORED_FOR_REFLECTION.contains(contentType.name())) {
            return;
        }
        reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(contentType).ignoreTypePredicate(ReflectiveHierarchyBuildItem.DefaultIgnoreTypePredicate.INSTANCE.or(TYPES_IGNORED_FOR_REFLECTION::contains)).source(VertxWebProcessor.class.getSimpleName() + " > " + contentType).build());
    }

    private void handleRegularMulti(HandlerDescriptor descriptor, BytecodeCreator writer, ResultHandle rc, ResultHandle res) {
        if (Methods.isNoContent(descriptor)) {
            writer.invokeStaticMethod(Methods.MULTI_SUBSCRIBE_VOID, new ResultHandle[]{res, rc});
        } else if (descriptor.isContentTypeBuffer()) {
            writer.invokeStaticMethod(Methods.MULTI_SUBSCRIBE_BUFFER, new ResultHandle[]{res, rc});
        } else if (descriptor.isContentTypeMutinyBuffer()) {
            writer.invokeStaticMethod(Methods.MULTI_SUBSCRIBE_MUTINY_BUFFER, new ResultHandle[]{res, rc});
        } else if (descriptor.isContentTypeRxBuffer()) {
            writer.invokeStaticMethod(Methods.MULTI_SUBSCRIBE_RX_BUFFER, new ResultHandle[]{res, rc});
        } else if (descriptor.isContentTypeString()) {
            writer.invokeStaticMethod(Methods.MULTI_SUBSCRIBE_STRING, new ResultHandle[]{res, rc});
        } else {
            writer.invokeStaticMethod(Methods.MULTI_SUBSCRIBE_OBJECT, new ResultHandle[]{res, rc});
        }
    }

    private void handleSSEMulti(HandlerDescriptor descriptor, BytecodeCreator writer, ResultHandle rc, ResultHandle res) {
        if (Methods.isNoContent(descriptor)) {
            writer.invokeStaticMethod(Methods.MULTI_SUBSCRIBE_VOID, new ResultHandle[]{res, rc});
        } else if (descriptor.isContentTypeBuffer()) {
            writer.invokeStaticMethod(Methods.MULTI_SSE_SUBSCRIBE_BUFFER, new ResultHandle[]{res, rc});
        } else if (descriptor.isContentTypeMutinyBuffer()) {
            writer.invokeStaticMethod(Methods.MULTI_SSE_SUBSCRIBE_MUTINY_BUFFER, new ResultHandle[]{res, rc});
        } else if (descriptor.isContentTypeRxBuffer()) {
            writer.invokeStaticMethod(Methods.MULTI_SSE_SUBSCRIBE_RX_BUFFER, new ResultHandle[]{res, rc});
        } else if (descriptor.isContentTypeString()) {
            writer.invokeStaticMethod(Methods.MULTI_SSE_SUBSCRIBE_STRING, new ResultHandle[]{res, rc});
        } else {
            writer.invokeStaticMethod(Methods.MULTI_SSE_SUBSCRIBE_OBJECT, new ResultHandle[]{res, rc});
        }
    }

    private void handleJsonArrayMulti(HandlerDescriptor descriptor, BytecodeCreator writer, ResultHandle rc, ResultHandle res) {
        if (Methods.isNoContent(descriptor)) {
            writer.invokeStaticMethod(Methods.MULTI_JSON_SUBSCRIBE_VOID, new ResultHandle[]{res, rc});
        } else if (descriptor.isContentTypeString()) {
            writer.invokeStaticMethod(Methods.MULTI_JSON_SUBSCRIBE_STRING, new ResultHandle[]{res, rc});
        } else if (descriptor.isContentTypeBuffer() || descriptor.isContentTypeRxBuffer() || descriptor.isContentTypeMutinyBuffer()) {
            writer.invokeStaticMethod(Methods.MULTI_JSON_FAIL, new ResultHandle[]{rc});
        } else {
            writer.invokeStaticMethod(Methods.MULTI_JSON_SUBSCRIBE_OBJECT, new ResultHandle[]{res, rc});
        }
    }

    private FunctionCreator getUniOnItemCallback(HandlerDescriptor descriptor, MethodCreator invoke, ResultHandle rc, MethodDescriptor end, ResultHandle response, FieldCreator validatorField) {
        FunctionCreator callback = invoke.createFunction(Consumer.class);
        BytecodeCreator creator = callback.getBytecode();
        if (Methods.isNoContent(descriptor)) {
            creator.invokeInterfaceMethod(Methods.SET_STATUS, response, new ResultHandle[]{creator.load(204)});
            creator.invokeInterfaceMethod(Methods.END, response, new ResultHandle[0]);
        } else {
            ResultHandle item = creator.getMethodParam(0);
            BranchResult isItemNull = creator.ifNull(item);
            BytecodeCreator itemIfNotNull = isItemNull.falseBranch();
            ResultHandle content = this.getContentToWrite(descriptor, response, item, itemIfNotNull, validatorField, invoke.getThis());
            itemIfNotNull.invokeInterfaceMethod(end, response, new ResultHandle[]{content});
            itemIfNotNull.close();
            BytecodeCreator resultNull = isItemNull.trueBranch();
            ResultHandle npe = Methods.createNpeBecauseItemIfNull(resultNull);
            resultNull.invokeInterfaceMethod(Methods.FAIL, rc, new ResultHandle[]{npe});
            resultNull.close();
        }
        Methods.returnAndClose(creator);
        return callback;
    }

    private ResultHandle getUniOnFailureCallback(MethodCreator writer, ResultHandle routingContext) {
        return writer.newInstance(MethodDescriptor.ofConstructor(UniFailureCallback.class, (Class[])new Class[]{io.vertx.ext.web.RoutingContext.class}), new ResultHandle[]{routingContext});
    }

    private ResultHandle getContentToWrite(HandlerDescriptor descriptor, ResultHandle response, ResultHandle res, BytecodeCreator writer, FieldCreator validatorField, ResultHandle owner) {
        if (descriptor.isContentTypeString() || descriptor.isContentTypeBuffer()) {
            return res;
        }
        if (descriptor.isContentTypeRxBuffer()) {
            return writer.invokeVirtualMethod(Methods.RX_GET_DELEGATE, res, new ResultHandle[0]);
        }
        if (descriptor.isContentTypeMutinyBuffer()) {
            return writer.invokeVirtualMethod(Methods.MUTINY_GET_DELEGATE, res, new ResultHandle[0]);
        }
        Methods.setContentTypeToJson(response, writer);
        if (descriptor.isProducedResponseValidated()) {
            return Methods.validateProducedItem(response, writer, res, validatorField, owner);
        }
        return writer.invokeStaticMethod(Methods.JSON_ENCODE, new ResultHandle[]{res});
    }

    private static String dashify(String value) {
        StringBuilder ret = new StringBuilder();
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (i != 0 && i != chars.length - 1 && Character.isUpperCase(c)) {
                ret.append('-');
            }
            ret.append(Character.toLowerCase(c));
        }
        return ret.toString();
    }

    private void detectConflictingRoutes(Map<RouteMatcher, MethodInfo> matchers) {
        if (matchers.isEmpty()) {
            return;
        }
        HashSet groups = new HashSet();
        for (Map.Entry<RouteMatcher, MethodInfo> entry : matchers.entrySet()) {
            Set group = new LinkedHashSet<RouteMatcher>();
            ((HashSet)group).add(entry.getKey());
            matchers.entrySet().stream().filter(e -> {
                if (((RouteMatcher)e.getKey()).equals(entry.getKey())) {
                    return false;
                }
                if (((MethodInfo)e.getValue()).equals(entry.getValue())) {
                    return false;
                }
                if (((RouteMatcher)e.getKey()).getOrder() != ((RouteMatcher)entry.getKey()).getOrder()) {
                    return false;
                }
                return VertxWebProcessor.canMatchSameRequest((RouteMatcher)entry.getKey(), (RouteMatcher)e.getKey());
            }).map(Map.Entry::getKey).forEach(arg_0 -> group.add(arg_0));
            groups.add(group);
        }
        boolean conflictExists = false;
        for (Set group : groups) {
            if (group.size() <= 1) continue;
            Iterator it = group.iterator();
            RouteMatcher firstMatcher = (RouteMatcher)it.next();
            MethodInfo firstMethod = matchers.get(firstMatcher);
            conflictExists = true;
            StringBuilder conflictingRoutes = new StringBuilder();
            while (it.hasNext()) {
                RouteMatcher rm = (RouteMatcher)it.next();
                MethodInfo method = matchers.get(rm);
                conflictingRoutes.append("\n\t- ").append(method.declaringClass().name().toString()).append("#").append(method.name()).append("()");
            }
            LOGGER.warnf("Route %s#%s() can match the same request and has the same order [%s] as:%s", new Object[]{firstMethod.declaringClass().name(), firstMethod.name(), firstMatcher.getOrder(), conflictingRoutes});
        }
        if (conflictExists) {
            LOGGER.warn((Object)"You can use @Route#order() to ensure the routes are not executed in random order");
        }
    }

    static boolean canMatchSameRequest(RouteMatcher m1, RouteMatcher m2) {
        if (m1.getRegex() != null ? !Objects.equals(m1.getRegex(), m2.getRegex()) : m1.getPath() != null && !Objects.equals(m1.getPath(), m2.getPath())) {
            return false;
        }
        if (m1.getMethods().length > 0 && m2.getMethods().length > 0 && !Arrays.equals(m1.getMethods(), m2.getMethods())) {
            return false;
        }
        if (m1.getProduces().length > 0 && m2.getProduces().length > 0 && !Arrays.equals(m1.getProduces(), m2.getProduces())) {
            return false;
        }
        return m1.getConsumes().length <= 0 || m2.getConsumes().length <= 0 || Arrays.equals(m1.getConsumes(), m2.getConsumes());
    }

    private List<ParameterInjector> getMatchingInjectors(Type paramType, Set<AnnotationInstance> paramAnnotations, IndexView index) {
        ArrayList<ParameterInjector> injectors = new ArrayList<ParameterInjector>();
        for (ParameterInjector injector : PARAM_INJECTORS) {
            if (!injector.matches(paramType, paramAnnotations, index)) continue;
            injectors.add(injector);
        }
        return injectors;
    }

    static List<ParameterInjector> initParamInjectors() {
        ArrayList<ParameterInjector> injectors = new ArrayList<ParameterInjector>();
        injectors.add(ParameterInjector.builder().matchType(DotNames.ROUTING_CONTEXT).resultHandleProvider(new ResultHandleProvider(){

            @Override
            public ResultHandle get(MethodInfo method, Type paramType, Set<AnnotationInstance> annotations, ResultHandle routingContext, MethodCreator invoke, int position, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
                return routingContext;
            }
        }).build());
        injectors.add(ParameterInjector.builder().matchType(DotNames.RX_ROUTING_CONTEXT).resultHandleProvider(new ResultHandleProvider(){

            @Override
            public ResultHandle get(MethodInfo method, Type paramType, Set<AnnotationInstance> annotations, ResultHandle routingContext, MethodCreator invoke, int position, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
                return invoke.newInstance(MethodDescriptor.ofConstructor(RoutingContext.class, (Class[])new Class[]{io.vertx.ext.web.RoutingContext.class}), new ResultHandle[]{routingContext});
            }
        }).build());
        injectors.add(ParameterInjector.builder().matchType(DotNames.ROUTING_EXCHANGE).resultHandleProvider(new ResultHandleProvider(){

            @Override
            public ResultHandle get(MethodInfo method, Type paramType, Set<AnnotationInstance> annotations, ResultHandle routingContext, MethodCreator invoke, int position, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
                return invoke.newInstance(MethodDescriptor.ofConstructor(RoutingExchangeImpl.class, (Class[])new Class[]{io.vertx.ext.web.RoutingContext.class}), new ResultHandle[]{routingContext});
            }
        }).build());
        injectors.add(ParameterInjector.builder().matchType(DotNames.HTTP_SERVER_REQUEST).resultHandleProvider(new ResultHandleProvider(){

            @Override
            public ResultHandle get(MethodInfo method, Type paramType, Set<AnnotationInstance> annotations, ResultHandle routingContext, MethodCreator invoke, int position, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
                return invoke.invokeInterfaceMethod(Methods.REQUEST, routingContext, new ResultHandle[0]);
            }
        }).build());
        injectors.add(ParameterInjector.builder().matchType(DotNames.HTTP_SERVER_RESPONSE).resultHandleProvider(new ResultHandleProvider(){

            @Override
            public ResultHandle get(MethodInfo method, Type paramType, Set<AnnotationInstance> annotations, ResultHandle routingContext, MethodCreator invoke, int position, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
                return invoke.invokeInterfaceMethod(Methods.RESPONSE, routingContext, new ResultHandle[0]);
            }
        }).build());
        injectors.add(ParameterInjector.builder().matchType(DotNames.RX_HTTP_SERVER_REQUEST).resultHandleProvider(new ResultHandleProvider(){

            @Override
            public ResultHandle get(MethodInfo method, Type paramType, Set<AnnotationInstance> annotations, ResultHandle routingContext, MethodCreator invoke, int position, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
                return invoke.newInstance(MethodDescriptor.ofConstructor(io.vertx.reactivex.core.http.HttpServerRequest.class, (Class[])new Class[]{HttpServerRequest.class}), new ResultHandle[]{invoke.invokeInterfaceMethod(Methods.REQUEST, routingContext, new ResultHandle[0])});
            }
        }).build());
        injectors.add(ParameterInjector.builder().matchType(DotNames.RX_HTTP_SERVER_RESPONSE).resultHandleProvider(new ResultHandleProvider(){

            @Override
            public ResultHandle get(MethodInfo method, Type paramType, Set<AnnotationInstance> annotations, ResultHandle routingContext, MethodCreator invoke, int position, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
                return invoke.newInstance(MethodDescriptor.ofConstructor(io.vertx.reactivex.core.http.HttpServerResponse.class, (Class[])new Class[]{HttpServerResponse.class}), new ResultHandle[]{invoke.invokeInterfaceMethod(Methods.RESPONSE, routingContext, new ResultHandle[0])});
            }
        }).build());
        injectors.add(ParameterInjector.builder().matchPrimitiveWrappers().matchType(io.quarkus.arc.processor.DotNames.STRING).matchOptionalOf(io.quarkus.arc.processor.DotNames.STRING).matchListOf(io.quarkus.arc.processor.DotNames.STRING).requireAnnotations(DotNames.PARAM).resultHandleProvider(new ParamAndHeaderProvider(DotNames.PARAM, Methods.REQUEST_PARAMS, Methods.REQUEST_GET_PARAM)).build());
        injectors.add(ParameterInjector.builder().matchPrimitiveWrappers().matchType(io.quarkus.arc.processor.DotNames.STRING).matchOptionalOf(io.quarkus.arc.processor.DotNames.STRING).matchListOf(io.quarkus.arc.processor.DotNames.STRING).requireAnnotations(DotNames.HEADER).resultHandleProvider(new ParamAndHeaderProvider(DotNames.HEADER, Methods.REQUEST_HEADERS, Methods.REQUEST_GET_HEADER)).build());
        injectors.add(ParameterInjector.builder().matchType(io.quarkus.arc.processor.DotNames.STRING).matchType(DotNames.BUFFER).matchType(DotNames.JSON_OBJECT).matchType(DotNames.JSON_ARRAY).requireAnnotations(DotNames.BODY).resultHandleProvider(new ResultHandleProvider(){

            @Override
            public ResultHandle get(MethodInfo method, Type paramType, Set<AnnotationInstance> annotations, ResultHandle routingContext, MethodCreator invoke, int position, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
                if (paramType.name().equals((Object)io.quarkus.arc.processor.DotNames.STRING)) {
                    return invoke.invokeInterfaceMethod(Methods.GET_BODY_AS_STRING, routingContext, new ResultHandle[0]);
                }
                if (paramType.name().equals((Object)DotNames.BUFFER)) {
                    return invoke.invokeInterfaceMethod(Methods.GET_BODY, routingContext, new ResultHandle[0]);
                }
                if (paramType.name().equals((Object)DotNames.JSON_OBJECT)) {
                    return invoke.invokeInterfaceMethod(Methods.GET_BODY_AS_JSON, routingContext, new ResultHandle[0]);
                }
                if (paramType.name().equals((Object)DotNames.JSON_ARRAY)) {
                    return invoke.invokeInterfaceMethod(Methods.GET_BODY_AS_JSON_ARRAY, routingContext, new ResultHandle[0]);
                }
                throw new IllegalArgumentException("Unsupported param type: " + paramType);
            }
        }).build());
        injectors.add(ParameterInjector.builder().skipType(io.quarkus.arc.processor.DotNames.STRING).skipType(DotNames.BUFFER).skipType(DotNames.JSON_OBJECT).skipType(DotNames.JSON_ARRAY).requireAnnotations(DotNames.BODY).resultHandleProvider(new ResultHandleProvider(){

            @Override
            public ResultHandle get(MethodInfo method, Type paramType, Set<AnnotationInstance> annotations, ResultHandle routingContext, MethodCreator invoke, int position, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
                VertxWebProcessor.registerForReflection(paramType, (BuildProducer<ReflectiveHierarchyBuildItem>)reflectiveHierarchy);
                AssignableResultHandle ret = invoke.createVariable(Object.class);
                ResultHandle bodyAsJson = invoke.invokeInterfaceMethod(Methods.GET_BODY_AS_JSON, routingContext, new ResultHandle[0]);
                BranchResult bodyIfNotNull = invoke.ifNotNull(bodyAsJson);
                BytecodeCreator bodyNotNull = bodyIfNotNull.trueBranch();
                bodyNotNull.assign(ret, bodyNotNull.invokeVirtualMethod(Methods.JSON_OBJECT_MAP_TO, bodyAsJson, new ResultHandle[]{invoke.loadClass(paramType.name().toString())}));
                BytecodeCreator bodyNull = bodyIfNotNull.falseBranch();
                bodyNull.assign(ret, bodyNull.loadNull());
                return ret;
            }
        }).build());
        injectors.add(ParameterInjector.builder().targetHandlerType(Route.HandlerType.FAILURE).match(new TriPredicate<Type, Set<AnnotationInstance>, IndexView>(){

            @Override
            public boolean test(Type paramType, Set<AnnotationInstance> paramAnnotations, IndexView index) {
                return VertxWebProcessor.isThrowable(paramType, index) && !Annotations.contains(paramAnnotations, (DotName)DotNames.BODY);
            }
        }).resultHandleProvider(new ResultHandleProvider(){

            @Override
            public ResultHandle get(MethodInfo method, Type paramType, Set<AnnotationInstance> annotations, ResultHandle routingContext, MethodCreator invoke, int position, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
                return invoke.invokeInterfaceMethod(Methods.FAILURE, routingContext, new ResultHandle[0]);
            }
        }).build());
        return injectors;
    }

    private static IllegalStateException parameterNameNotAvailable(int position, MethodInfo method) {
        return new IllegalStateException("Unable to determine the name of the parameter at position " + position + " in method " + method.declaringClass().name() + "#" + method.name() + "() - compile the class with debug info enabled (-g) or parameter names recorded (-parameters), or specify the appropriate annotation value");
    }

    static void convertPrimitiveAndSet(AssignableResultHandle paramHandle, Type paramType, BytecodeCreator invoke, MethodInfo method, int position) {
        BytecodeCreator notNull = invoke.ifNotNull((ResultHandle)paramHandle).trueBranch();
        TryBlock tryBlock = notNull.tryBlock();
        CatchBlockCreator catchBlock = tryBlock.addCatch(Throwable.class);
        catchBlock.throwException(IllegalArgumentException.class, "Error converting parameter at position " + position + " of method " + method, catchBlock.getCaughtException());
        if (paramType.name().equals((Object)io.quarkus.arc.processor.DotNames.INTEGER)) {
            tryBlock.assign(paramHandle, tryBlock.invokeStaticMethod(Methods.INTEGER_VALUE_OF, new ResultHandle[]{paramHandle}));
        } else if (paramType.name().equals((Object)io.quarkus.arc.processor.DotNames.LONG)) {
            tryBlock.assign(paramHandle, tryBlock.invokeStaticMethod(Methods.LONG_VALUE_OF, new ResultHandle[]{paramHandle}));
        } else if (paramType.name().equals((Object)io.quarkus.arc.processor.DotNames.BOOLEAN)) {
            tryBlock.assign(paramHandle, tryBlock.invokeStaticMethod(Methods.BOOLEAN_VALUE_OF, new ResultHandle[]{paramHandle}));
        } else if (paramType.name().equals((Object)io.quarkus.arc.processor.DotNames.CHARACTER)) {
            ResultHandle firstChar = tryBlock.invokeVirtualMethod(Methods.STRING_CHAR_AT, (ResultHandle)paramHandle, new ResultHandle[]{tryBlock.load(0)});
            tryBlock.assign(paramHandle, tryBlock.invokeStaticMethod(Methods.CHARACTER_VALUE_OF, new ResultHandle[]{firstChar}));
        } else if (paramType.name().equals((Object)io.quarkus.arc.processor.DotNames.FLOAT)) {
            tryBlock.assign(paramHandle, tryBlock.invokeStaticMethod(Methods.FLOAT_VALUE_OF, new ResultHandle[]{paramHandle}));
        } else if (paramType.name().equals((Object)io.quarkus.arc.processor.DotNames.DOUBLE)) {
            tryBlock.assign(paramHandle, tryBlock.invokeStaticMethod(Methods.DOUBLE_VALUE_OF, new ResultHandle[]{paramHandle}));
        } else if (paramType.name().equals((Object)io.quarkus.arc.processor.DotNames.BYTE)) {
            tryBlock.assign(paramHandle, tryBlock.invokeStaticMethod(Methods.BYTE_VALUE_OF, new ResultHandle[]{paramHandle}));
        } else if (paramType.name().equals((Object)io.quarkus.arc.processor.DotNames.SHORT)) {
            tryBlock.assign(paramHandle, tryBlock.invokeStaticMethod(Methods.SHORT_VALUE_OF, new ResultHandle[]{paramHandle}));
        } else {
            throw new IllegalArgumentException("Unsupported param type: " + paramType);
        }
    }

    @FunctionalInterface
    static interface TriPredicate<A, B, C> {
        public boolean test(A var1, B var2, C var3);
    }

    static interface ResultHandleProvider {
        public ResultHandle get(MethodInfo var1, Type var2, Set<AnnotationInstance> var3, ResultHandle var4, MethodCreator var5, int var6, BuildProducer<ReflectiveHierarchyBuildItem> var7);
    }

    static class ParameterInjector {
        final TriPredicate<Type, Set<AnnotationInstance>, IndexView> predicate;
        final ResultHandleProvider provider;
        final Route.HandlerType targetHandlerType;

        static Builder builder() {
            return new Builder();
        }

        ParameterInjector(final Builder builder) {
            this.predicate = builder.predicate != null ? builder.predicate : new TriPredicate<Type, Set<AnnotationInstance>, IndexView>(){
                final List<Type> matchTypes;
                final List<Type> skipTypes;
                final List<DotName> requiredAnnotationNames;
                {
                    this.matchTypes = builder.matchTypes;
                    this.skipTypes = builder.skipTypes;
                    this.requiredAnnotationNames = builder.requiredAnnotationNames;
                }

                @Override
                public boolean test(Type paramType, Set<AnnotationInstance> paramAnnotations, IndexView index) {
                    if (this.skipTypes != null) {
                        for (Type skipType : this.skipTypes) {
                            if (skipType.kind() != paramType.kind()) continue;
                            if (skipType.kind() == Type.Kind.CLASS && skipType.name().equals((Object)paramType.name())) {
                                return false;
                            }
                            if (skipType.kind() != Type.Kind.PARAMETERIZED_TYPE || !skipType.name().equals((Object)paramType.name()) || !skipType.asParameterizedType().arguments().equals(paramType.asParameterizedType().arguments())) continue;
                            return false;
                        }
                    }
                    if (this.matchTypes != null) {
                        boolean matches = false;
                        for (Type matchType : this.matchTypes) {
                            if (matchType.kind() != paramType.kind()) continue;
                            if (matchType.kind() == Type.Kind.CLASS && matchType.name().equals((Object)paramType.name())) {
                                matches = true;
                                break;
                            }
                            if (matchType.kind() != Type.Kind.PARAMETERIZED_TYPE || !matchType.name().equals((Object)paramType.name()) || !matchType.asParameterizedType().arguments().equals(paramType.asParameterizedType().arguments())) continue;
                            matches = true;
                            break;
                        }
                        if (!matches) {
                            return false;
                        }
                    }
                    if (!this.requiredAnnotationNames.isEmpty()) {
                        for (DotName annotationName : this.requiredAnnotationNames) {
                            if (Annotations.contains(paramAnnotations, (DotName)annotationName)) continue;
                            return false;
                        }
                    }
                    return true;
                }
            };
            this.provider = builder.provider;
            this.targetHandlerType = builder.targetHandlerType;
        }

        boolean matches(Type paramType, Set<AnnotationInstance> paramAnnotations, IndexView index) {
            return this.predicate.test(paramType, paramAnnotations, index);
        }

        Route.HandlerType getTargetHandlerType() {
            return this.targetHandlerType;
        }

        ResultHandle getResultHandle(MethodInfo method, Type paramType, Set<AnnotationInstance> annotations, ResultHandle routingContext, MethodCreator invoke, int position, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
            return this.provider.get(method, paramType, annotations, routingContext, invoke, position, reflectiveHierarchy);
        }

        static class Builder {
            TriPredicate<Type, Set<AnnotationInstance>, IndexView> predicate;
            List<Type> matchTypes;
            List<Type> skipTypes;
            List<DotName> requiredAnnotationNames = Collections.emptyList();
            ResultHandleProvider provider;
            Route.HandlerType targetHandlerType;

            Builder() {
            }

            Builder matchType(DotName className) {
                return this.matchType(Type.create((DotName)className, (Type.Kind)Type.Kind.CLASS));
            }

            Builder matchType(Type type) {
                if (this.matchTypes == null) {
                    this.matchTypes = new ArrayList<Type>();
                }
                this.matchTypes.add(type);
                return this;
            }

            Builder matchPrimitiveWrappers() {
                List<DotName> primitiveNames = Arrays.asList(io.quarkus.arc.processor.DotNames.INTEGER, io.quarkus.arc.processor.DotNames.LONG, io.quarkus.arc.processor.DotNames.SHORT, io.quarkus.arc.processor.DotNames.BOOLEAN, io.quarkus.arc.processor.DotNames.BYTE, io.quarkus.arc.processor.DotNames.CHARACTER, io.quarkus.arc.processor.DotNames.DOUBLE, io.quarkus.arc.processor.DotNames.FLOAT);
                for (DotName name : primitiveNames) {
                    this.matchType(name);
                    this.matchOptionalOf(name);
                    this.matchListOf(name);
                }
                return this;
            }

            Builder matchOptionalOf(DotName className) {
                return this.matchOptionalOf(Type.create((DotName)className, (Type.Kind)Type.Kind.CLASS));
            }

            Builder matchListOf(DotName className) {
                return this.matchListOf(Type.create((DotName)className, (Type.Kind)Type.Kind.CLASS));
            }

            Builder matchOptionalOf(Type type) {
                return this.matchType((Type)ParameterizedType.create((DotName)io.quarkus.arc.processor.DotNames.OPTIONAL, (Type[])new Type[]{type}, null));
            }

            Builder matchListOf(Type type) {
                return this.matchType((Type)ParameterizedType.create((DotName)DotNames.LIST, (Type[])new Type[]{type}, null));
            }

            Builder skipType(DotName className) {
                return this.skipType(Type.create((DotName)className, (Type.Kind)Type.Kind.CLASS));
            }

            Builder skipType(Type type) {
                if (this.skipTypes == null) {
                    this.skipTypes = new ArrayList<Type>();
                }
                this.skipTypes.add(type);
                return this;
            }

            Builder requireAnnotations(DotName ... names) {
                this.requiredAnnotationNames = Arrays.asList(names);
                return this;
            }

            Builder resultHandleProvider(ResultHandleProvider provider) {
                this.provider = provider;
                return this;
            }

            Builder match(TriPredicate<Type, Set<AnnotationInstance>, IndexView> predicate) {
                this.predicate = predicate;
                return this;
            }

            Builder targetHandlerType(Route.HandlerType handlerType) {
                this.targetHandlerType = handlerType;
                return this;
            }

            ParameterInjector build() {
                return new ParameterInjector(this);
            }
        }
    }

    private static class ParamAndHeaderProvider
    implements ResultHandleProvider {
        private final DotName annotationName;
        private final MethodDescriptor multiMapAccessor;
        private final MethodDescriptor valueAccessor;

        public ParamAndHeaderProvider(DotName annotationName, MethodDescriptor multiMapAccessor, MethodDescriptor valueAccessor) {
            this.annotationName = annotationName;
            this.multiMapAccessor = multiMapAccessor;
            this.valueAccessor = valueAccessor;
        }

        @Override
        public ResultHandle get(MethodInfo method, Type paramType, Set<AnnotationInstance> annotations, ResultHandle routingContext, MethodCreator invoke, int position, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy) {
            String paramName;
            AnnotationValue paramAnnotationValue = Annotations.find(annotations, (DotName)this.annotationName).value();
            String string = paramName = paramAnnotationValue != null ? paramAnnotationValue.asString() : null;
            if (paramName == null || paramName.equals("<<element name>>")) {
                paramName = method.parameterName(position);
            }
            if (paramName == null) {
                throw VertxWebProcessor.parameterNameNotAvailable(position, method);
            }
            AssignableResultHandle paramHandle = invoke.createVariable(Object.class);
            if (paramType.name().equals((Object)DotNames.LIST)) {
                Type wrappedType = (Type)paramType.asParameterizedType().arguments().get(0);
                invoke.assign(paramHandle, invoke.invokeInterfaceMethod(Methods.MULTIMAP_GET_ALL, invoke.invokeInterfaceMethod(this.multiMapAccessor, invoke.invokeInterfaceMethod(Methods.REQUEST, routingContext, new ResultHandle[0]), new ResultHandle[0]), new ResultHandle[]{invoke.load(paramName)}));
                if (!wrappedType.name().equals((Object)io.quarkus.arc.processor.DotNames.STRING)) {
                    ResultHandle results = invoke.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{invoke.invokeInterfaceMethod(Methods.COLLECTION_SIZE, (ResultHandle)paramHandle, new ResultHandle[0])});
                    final ResultHandle iterator = invoke.invokeInterfaceMethod(Methods.COLLECTION_ITERATOR, (ResultHandle)paramHandle, new ResultHandle[0]);
                    WhileLoop loop = invoke.whileLoop((Function)new Function<BytecodeCreator, BranchResult>(){

                        @Override
                        public BranchResult apply(BytecodeCreator bc) {
                            return bc.ifTrue(bc.invokeInterfaceMethod(Methods.ITERATOR_HAS_NEXT, iterator, new ResultHandle[0]));
                        }
                    });
                    BytecodeCreator block = loop.block();
                    AssignableResultHandle element = block.createVariable(Object.class);
                    block.assign(element, block.invokeInterfaceMethod(Methods.ITERATOR_NEXT, iterator, new ResultHandle[0]));
                    VertxWebProcessor.convertPrimitiveAndSet(element, wrappedType, block, method, position);
                    block.invokeInterfaceMethod(Methods.COLLECTION_ADD, results, new ResultHandle[]{element});
                    invoke.assign(paramHandle, results);
                }
            } else {
                invoke.assign(paramHandle, invoke.invokeInterfaceMethod(this.valueAccessor, invoke.invokeInterfaceMethod(Methods.REQUEST, routingContext, new ResultHandle[0]), new ResultHandle[]{invoke.load(paramName)}));
                if (paramType.name().equals((Object)io.quarkus.arc.processor.DotNames.OPTIONAL)) {
                    Type wrappedType = (Type)paramType.asParameterizedType().arguments().get(0);
                    if (!wrappedType.name().equals((Object)io.quarkus.arc.processor.DotNames.STRING)) {
                        VertxWebProcessor.convertPrimitiveAndSet(paramHandle, wrappedType, (BytecodeCreator)invoke, method, position);
                    }
                    invoke.assign(paramHandle, invoke.invokeStaticMethod(Methods.OPTIONAL_OF_NULLABLE, new ResultHandle[]{paramHandle}));
                } else if (!paramType.name().equals((Object)io.quarkus.arc.processor.DotNames.STRING)) {
                    VertxWebProcessor.convertPrimitiveAndSet(paramHandle, paramType, (BytecodeCreator)invoke, method, position);
                }
            }
            return paramHandle;
        }
    }
}

