/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web.deployment;

import io.quarkus.vertx.web.deployment.DotNames;
import io.vertx.mutiny.core.buffer.Buffer;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

class HandlerDescriptor {
    private final MethodInfo method;

    HandlerDescriptor(MethodInfo method) {
        this.method = method;
    }

    Type getReturnType() {
        return this.method.returnType();
    }

    boolean isReturningVoid() {
        return this.method.returnType().kind().equals((Object)Type.Kind.VOID);
    }

    boolean isReturningUni() {
        return this.method.returnType().name().equals((Object)DotNames.UNI);
    }

    boolean isReturningMulti() {
        return this.method.returnType().name().equals((Object)DotNames.MULTI);
    }

    Type getContentType() {
        if (this.isReturningVoid()) {
            return null;
        }
        if (this.isReturningUni()) {
            return (Type)this.getReturnType().asParameterizedType().arguments().get(0);
        }
        if (this.isReturningMulti()) {
            return (Type)this.getReturnType().asParameterizedType().arguments().get(0);
        }
        return this.getReturnType();
    }

    boolean isContentTypeString() {
        Type type = this.getContentType();
        if (type == null) {
            return false;
        }
        return type.name().equals((Object)io.quarkus.arc.processor.DotNames.STRING);
    }

    boolean isContentTypeBuffer() {
        Type type = this.getContentType();
        if (type == null) {
            return false;
        }
        return type.name().equals((Object)DotNames.BUFFER);
    }

    boolean isContentTypeRxBuffer() {
        Type type = this.getContentType();
        if (type == null) {
            return false;
        }
        return type.name().equals((Object)DotName.createSimple((String)io.vertx.reactivex.core.buffer.Buffer.class.getName()));
    }

    boolean isContentTypeMutinyBuffer() {
        Type type = this.getContentType();
        if (type == null) {
            return false;
        }
        return type.name().equals((Object)DotName.createSimple((String)Buffer.class.getName()));
    }
}

