/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InjectableReferenceProvider;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.vertx.web.deployment.HandlerDescriptor;
import io.quarkus.vertx.web.runtime.MultiJsonArraySupport;
import io.quarkus.vertx.web.runtime.MultiSseSupport;
import io.quarkus.vertx.web.runtime.MultiSupport;
import io.quarkus.vertx.web.runtime.RouteHandlers;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniSubscribe;
import io.smallrye.mutiny.subscription.Cancellable;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.jandex.DotName;

class Methods {
    static final MethodDescriptor GET_HEADERS = MethodDescriptor.ofMethod(HttpServerResponse.class, (String)"headers", MultiMap.class, (Class[])new Class[0]);
    static final MethodDescriptor MULTIMAP_GET = MethodDescriptor.ofMethod(MultiMap.class, (String)"get", String.class, (Class[])new Class[]{String.class});
    static final MethodDescriptor MULTIMAP_SET = MethodDescriptor.ofMethod(MultiMap.class, (String)"set", MultiMap.class, (Class[])new Class[]{String.class, String.class});
    static final MethodDescriptor MULTIMAP_GET_ALL = MethodDescriptor.ofMethod(MultiMap.class, (String)"getAll", List.class, (Class[])new Class[]{String.class});
    static final MethodDescriptor REQUEST = MethodDescriptor.ofMethod(RoutingContext.class, (String)"request", HttpServerRequest.class, (Class[])new Class[0]);
    static final MethodDescriptor REQUEST_GET_PARAM = MethodDescriptor.ofMethod(HttpServerRequest.class, (String)"getParam", String.class, (Class[])new Class[]{String.class});
    static final MethodDescriptor REQUEST_GET_HEADER = MethodDescriptor.ofMethod(HttpServerRequest.class, (String)"getHeader", String.class, (Class[])new Class[]{String.class});
    static final MethodDescriptor GET_BODY = MethodDescriptor.ofMethod(RoutingContext.class, (String)"getBody", Buffer.class, (Class[])new Class[0]);
    static final MethodDescriptor GET_BODY_AS_STRING = MethodDescriptor.ofMethod(RoutingContext.class, (String)"getBodyAsString", String.class, (Class[])new Class[0]);
    static final MethodDescriptor GET_BODY_AS_JSON = MethodDescriptor.ofMethod(RoutingContext.class, (String)"getBodyAsJson", JsonObject.class, (Class[])new Class[0]);
    static final MethodDescriptor GET_BODY_AS_JSON_ARRAY = MethodDescriptor.ofMethod(RoutingContext.class, (String)"getBodyAsJsonArray", JsonArray.class, (Class[])new Class[0]);
    static final MethodDescriptor JSON_OBJECT_MAP_TO = MethodDescriptor.ofMethod(JsonObject.class, (String)"mapTo", Object.class, (Class[])new Class[]{Class.class});
    static final MethodDescriptor REQUEST_PARAMS = MethodDescriptor.ofMethod(HttpServerRequest.class, (String)"params", MultiMap.class, (Class[])new Class[0]);
    static final MethodDescriptor REQUEST_HEADERS = MethodDescriptor.ofMethod(HttpServerRequest.class, (String)"headers", MultiMap.class, (Class[])new Class[0]);
    static final MethodDescriptor RESPONSE = MethodDescriptor.ofMethod(RoutingContext.class, (String)"response", HttpServerResponse.class, (Class[])new Class[0]);
    static final MethodDescriptor FAIL = MethodDescriptor.ofMethod(RoutingContext.class, (String)"fail", Void.TYPE, (Class[])new Class[]{Throwable.class});
    static final MethodDescriptor UNI_SUBSCRIBE = MethodDescriptor.ofMethod(Uni.class, (String)"subscribe", UniSubscribe.class, (Class[])new Class[0]);
    static final MethodDescriptor UNI_SUBSCRIBE_WITH = MethodDescriptor.ofMethod(UniSubscribe.class, (String)"with", Cancellable.class, (Class[])new Class[]{Consumer.class, Consumer.class});
    static final MethodDescriptor MULTI_SUBSCRIBE_VOID = MethodDescriptor.ofMethod(MultiSupport.class, (String)"subscribeVoid", Void.TYPE, (Class[])new Class[]{Multi.class, RoutingContext.class});
    static final MethodDescriptor MULTI_SUBSCRIBE_STRING = MethodDescriptor.ofMethod(MultiSupport.class, (String)"subscribeString", Void.TYPE, (Class[])new Class[]{Multi.class, RoutingContext.class});
    static final MethodDescriptor MULTI_SUBSCRIBE_BUFFER = MethodDescriptor.ofMethod(MultiSupport.class, (String)"subscribeBuffer", Void.TYPE, (Class[])new Class[]{Multi.class, RoutingContext.class});
    static final MethodDescriptor MULTI_SUBSCRIBE_RX_BUFFER = MethodDescriptor.ofMethod(MultiSupport.class, (String)"subscribeRxBuffer", Void.TYPE, (Class[])new Class[]{Multi.class, RoutingContext.class});
    static final MethodDescriptor MULTI_SUBSCRIBE_MUTINY_BUFFER = MethodDescriptor.ofMethod(MultiSupport.class, (String)"subscribeMutinyBuffer", Void.TYPE, (Class[])new Class[]{Multi.class, RoutingContext.class});
    static final MethodDescriptor MULTI_SUBSCRIBE_OBJECT = MethodDescriptor.ofMethod(MultiSupport.class, (String)"subscribeObject", Void.TYPE, (Class[])new Class[]{Multi.class, RoutingContext.class});
    static final MethodDescriptor IS_SSE = MethodDescriptor.ofMethod(MultiSseSupport.class, (String)"isSSE", Boolean.TYPE, (Class[])new Class[]{Multi.class});
    static final MethodDescriptor MULTI_SSE_SUBSCRIBE_STRING = MethodDescriptor.ofMethod(MultiSseSupport.class, (String)"subscribeString", Void.TYPE, (Class[])new Class[]{Multi.class, RoutingContext.class});
    static final MethodDescriptor MULTI_SSE_SUBSCRIBE_BUFFER = MethodDescriptor.ofMethod(MultiSseSupport.class, (String)"subscribeBuffer", Void.TYPE, (Class[])new Class[]{Multi.class, RoutingContext.class});
    static final MethodDescriptor MULTI_SSE_SUBSCRIBE_RX_BUFFER = MethodDescriptor.ofMethod(MultiSseSupport.class, (String)"subscribeRxBuffer", Void.TYPE, (Class[])new Class[]{Multi.class, RoutingContext.class});
    static final MethodDescriptor MULTI_SSE_SUBSCRIBE_MUTINY_BUFFER = MethodDescriptor.ofMethod(MultiSseSupport.class, (String)"subscribeMutinyBuffer", Void.TYPE, (Class[])new Class[]{Multi.class, RoutingContext.class});
    static final MethodDescriptor MULTI_SSE_SUBSCRIBE_OBJECT = MethodDescriptor.ofMethod(MultiSseSupport.class, (String)"subscribeObject", Void.TYPE, (Class[])new Class[]{Multi.class, RoutingContext.class});
    static final MethodDescriptor IS_JSON_ARRAY = MethodDescriptor.ofMethod(MultiJsonArraySupport.class, (String)"isJsonArray", Boolean.TYPE, (Class[])new Class[]{Multi.class});
    static final MethodDescriptor MULTI_JSON_SUBSCRIBE_VOID = MethodDescriptor.ofMethod(MultiJsonArraySupport.class, (String)"subscribeVoid", Void.TYPE, (Class[])new Class[]{Multi.class, RoutingContext.class});
    static final MethodDescriptor MULTI_JSON_SUBSCRIBE_STRING = MethodDescriptor.ofMethod(MultiJsonArraySupport.class, (String)"subscribeString", Void.TYPE, (Class[])new Class[]{Multi.class, RoutingContext.class});
    static final MethodDescriptor MULTI_JSON_SUBSCRIBE_BUFFER = MethodDescriptor.ofMethod(MultiJsonArraySupport.class, (String)"subscribeBuffer", Void.TYPE, (Class[])new Class[]{Multi.class, RoutingContext.class});
    static final MethodDescriptor MULTI_JSON_SUBSCRIBE_RX_BUFFER = MethodDescriptor.ofMethod(MultiJsonArraySupport.class, (String)"subscribeRxBuffer", Void.TYPE, (Class[])new Class[]{Multi.class, RoutingContext.class});
    static final MethodDescriptor MULTI_JSON_SUBSCRIBE_MUTINY_BUFFER = MethodDescriptor.ofMethod(MultiJsonArraySupport.class, (String)"subscribeMutinyBuffer", Void.TYPE, (Class[])new Class[]{Multi.class, RoutingContext.class});
    static final MethodDescriptor MULTI_JSON_SUBSCRIBE_OBJECT = MethodDescriptor.ofMethod(MultiJsonArraySupport.class, (String)"subscribeObject", Void.TYPE, (Class[])new Class[]{Multi.class, RoutingContext.class});
    static final MethodDescriptor MULTI_JSON_FAIL = MethodDescriptor.ofMethod(MultiJsonArraySupport.class, (String)"fail", Void.TYPE, (Class[])new Class[]{RoutingContext.class});
    static final MethodDescriptor END = MethodDescriptor.ofMethod(HttpServerResponse.class, (String)"end", Void.TYPE, (Class[])new Class[0]);
    static final MethodDescriptor END_WITH_STRING = MethodDescriptor.ofMethod(HttpServerResponse.class, (String)"end", Void.TYPE, (Class[])new Class[]{String.class});
    static final MethodDescriptor END_WITH_BUFFER = MethodDescriptor.ofMethod(HttpServerResponse.class, (String)"end", Void.TYPE, (Class[])new Class[]{Buffer.class});
    static final MethodDescriptor SET_STATUS = MethodDescriptor.ofMethod(HttpServerResponse.class, (String)"setStatusCode", HttpServerResponse.class, (Class[])new Class[]{Integer.TYPE});
    static final MethodDescriptor RX_GET_DELEGATE = MethodDescriptor.ofMethod(io.vertx.reactivex.core.buffer.Buffer.class, (String)"getDelegate", Buffer.class, (Class[])new Class[0]);
    static final MethodDescriptor MUTINY_GET_DELEGATE = MethodDescriptor.ofMethod(io.vertx.mutiny.core.buffer.Buffer.class, (String)"getDelegate", Buffer.class, (Class[])new Class[0]);
    static final MethodDescriptor JSON_ENCODE = MethodDescriptor.ofMethod(Json.class, (String)"encode", String.class, (Class[])new Class[]{Object.class});
    static final MethodDescriptor ARC_CONTAINER = MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]);
    static final MethodDescriptor ARC_CONTAINER_GET_ACTIVE_CONTEXT = MethodDescriptor.ofMethod(ArcContainer.class, (String)"getActiveContext", InjectableContext.class, (Class[])new Class[]{Class.class});
    static final MethodDescriptor ARC_CONTAINER_BEAN = MethodDescriptor.ofMethod(ArcContainer.class, (String)"bean", InjectableBean.class, (Class[])new Class[]{String.class});
    static final MethodDescriptor BEAN_GET_SCOPE = MethodDescriptor.ofMethod(InjectableBean.class, (String)"getScope", Class.class, (Class[])new Class[0]);
    static final MethodDescriptor CONTEXT_GET = MethodDescriptor.ofMethod(Context.class, (String)"get", Object.class, (Class[])new Class[]{Contextual.class, CreationalContext.class});
    static final MethodDescriptor CONTEXT_GET_IF_PRESENT = MethodDescriptor.ofMethod(Context.class, (String)"get", Object.class, (Class[])new Class[]{Contextual.class});
    static final MethodDescriptor INJECTABLE_REF_PROVIDER_GET = MethodDescriptor.ofMethod(InjectableReferenceProvider.class, (String)"get", Object.class, (Class[])new Class[]{CreationalContext.class});
    static final MethodDescriptor INJECTABLE_BEAN_DESTROY = MethodDescriptor.ofMethod(InjectableBean.class, (String)"destroy", Void.TYPE, (Class[])new Class[]{Object.class, CreationalContext.class});
    static final MethodDescriptor OBJECT_CONSTRUCTOR = MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]);
    static final MethodDescriptor ROUTE_HANDLERS_SET_CONTENT_TYPE = MethodDescriptor.ofMethod(RouteHandlers.class, (String)"setContentType", Void.TYPE, (Class[])new Class[]{RoutingContext.class, String.class});
    static final MethodDescriptor OPTIONAL_OF_NULLABLE = MethodDescriptor.ofMethod(Optional.class, (String)"ofNullable", Optional.class, (Class[])new Class[]{Object.class});

    private Methods() {
    }

    static void returnAndClose(BytecodeCreator creator) {
        creator.returnValue(null);
        creator.close();
    }

    static boolean isNoContent(HandlerDescriptor descriptor) {
        return descriptor.getContentType().name().equals((Object)DotName.createSimple((String)Void.class.getName()));
    }

    static ResultHandle createNpeBecauseItemIfNull(BytecodeCreator writer) {
        return writer.newInstance(MethodDescriptor.ofConstructor(NullPointerException.class, (Class[])new Class[]{String.class}), new ResultHandle[]{writer.load("Invalid value returned by Uni: `null`")});
    }

    static MethodDescriptor getEndMethodForContentType(HandlerDescriptor descriptor) {
        if (descriptor.isContentTypeBuffer() || descriptor.isContentTypeRxBuffer() || descriptor.isContentTypeMutinyBuffer()) {
            return END_WITH_BUFFER;
        }
        return END_WITH_STRING;
    }

    static void setContentTypeToJson(ResultHandle response, BytecodeCreator invoke) {
        ResultHandle ct = invoke.load("Content-Type");
        ResultHandle headers = invoke.invokeInterfaceMethod(GET_HEADERS, response, new ResultHandle[0]);
        ResultHandle current = invoke.invokeInterfaceMethod(MULTIMAP_GET, headers, new ResultHandle[]{ct});
        BytecodeCreator branch = invoke.ifNull(current).trueBranch();
        branch.invokeInterfaceMethod(MULTIMAP_SET, headers, new ResultHandle[]{ct, branch.load("application/json")});
        branch.close();
    }
}

