/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web.deployment;

import io.quarkus.hibernate.validator.spi.BeanValidationAnnotationsBuildItem;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.quarkus.vertx.web.deployment.DotNames;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

class HandlerDescriptor {
    private final MethodInfo method;
    private final BeanValidationAnnotationsBuildItem validationAnnotations;
    private final HandlerType handlerType;
    private final Type contentType;

    HandlerDescriptor(MethodInfo method, BeanValidationAnnotationsBuildItem bvAnnotations, HandlerType handlerType) {
        this.method = method;
        this.validationAnnotations = bvAnnotations;
        this.handlerType = handlerType;
        Type returnType = method.returnType();
        this.contentType = returnType.kind() == Type.Kind.VOID ? null : (returnType.name().equals((Object)DotNames.UNI) || returnType.name().equals((Object)DotNames.MULTI) || returnType.name().equals((Object)DotNames.COMPLETION_STAGE) ? (Type)returnType.asParameterizedType().arguments().get(0) : returnType);
    }

    Type getReturnType() {
        return this.method.returnType();
    }

    boolean isReturningVoid() {
        return this.method.returnType().kind().equals((Object)Type.Kind.VOID);
    }

    boolean isReturningUni() {
        return this.method.returnType().name().equals((Object)DotNames.UNI);
    }

    boolean isReturningMulti() {
        return this.method.returnType().name().equals((Object)DotNames.MULTI);
    }

    boolean isReturningCompletionStage() {
        return this.method.returnType().name().equals((Object)DotNames.COMPLETION_STAGE);
    }

    boolean requireValidation() {
        if (this.validationAnnotations == null) {
            return false;
        }
        for (AnnotationInstance annotation : this.method.annotations()) {
            if (!this.validationAnnotations.getAllAnnotations().contains(annotation.name())) continue;
            return true;
        }
        return false;
    }

    boolean isProducedResponseValidated() {
        if (this.validationAnnotations == null) {
            return false;
        }
        for (AnnotationInstance annotation : this.method.annotations()) {
            if (!this.validationAnnotations.getValidAnnotation().equals((Object)annotation.name())) continue;
            return true;
        }
        return false;
    }

    Type getContentType() {
        return this.contentType;
    }

    boolean isContentTypeString() {
        Type type = this.getContentType();
        if (type == null) {
            return false;
        }
        return type.name().equals((Object)io.quarkus.arc.processor.DotNames.STRING);
    }

    boolean isContentTypeBuffer() {
        Type type = this.getContentType();
        if (type == null) {
            return false;
        }
        return type.name().equals((Object)DotNames.BUFFER);
    }

    boolean isContentTypeMutinyBuffer() {
        Type type = this.getContentType();
        if (type == null) {
            return false;
        }
        return type.name().equals((Object)DotNames.MUTINY_BUFFER);
    }

    HandlerType getHandlerType() {
        return this.handlerType;
    }
}

