/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web.runtime;

import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.MemorySize;
import io.quarkus.vertx.http.runtime.BodyConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.RouterProducer;
import io.quarkus.vertx.web.Route;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.function.Function;

@Recorder
public class VertxWebRecorder {
    public Handler<RoutingContext> createHandler(String handlerClassName) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = RouterProducer.class.getClassLoader();
            }
            Class<?> handlerClazz = cl.loadClass(handlerClassName);
            return (Handler)handlerClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create invoker: " + handlerClassName, e);
        }
    }

    public Function<Router, io.vertx.ext.web.Route> createRouteFunction(final Route routeAnnotation, final Handler<RoutingContext> bodyHandler) {
        return new Function<Router, io.vertx.ext.web.Route>(){

            @Override
            public io.vertx.ext.web.Route apply(Router router) {
                io.vertx.ext.web.Route route = !routeAnnotation.regex().isEmpty() ? router.routeWithRegex(routeAnnotation.regex()) : (!routeAnnotation.path().isEmpty() ? router.route(VertxWebRecorder.this.ensureStartWithSlash(routeAnnotation.path())) : router.route());
                if (routeAnnotation.methods().length > 0) {
                    for (HttpMethod httpMethod : routeAnnotation.methods()) {
                        route.method(httpMethod);
                    }
                }
                if (routeAnnotation.order() > 0) {
                    route.order(routeAnnotation.order());
                }
                if (routeAnnotation.produces().length > 0) {
                    for (String string : routeAnnotation.produces()) {
                        route.produces(string);
                    }
                }
                if (routeAnnotation.consumes().length > 0) {
                    for (String string : routeAnnotation.consumes()) {
                        route.consumes(string);
                    }
                }
                route.handler(bodyHandler);
                return route;
            }
        };
    }

    public Handler<RoutingContext> createBodyHandler(HttpConfiguration httpConfiguration) {
        final BodyHandler bodyHandler = BodyHandler.create();
        Optional maxBodySize = httpConfiguration.limits.maxBodySize;
        if (maxBodySize.isPresent()) {
            bodyHandler.setBodyLimit(((MemorySize)maxBodySize.get()).asLongValue());
        }
        BodyConfig bodyConfig = httpConfiguration.body;
        bodyHandler.setHandleFileUploads(bodyConfig.handleFileUploads);
        bodyHandler.setUploadsDirectory(bodyConfig.uploadsDirectory);
        bodyHandler.setDeleteUploadedFilesOnEnd(bodyConfig.deleteUploadedFilesOnEnd);
        bodyHandler.setMergeFormAttributes(bodyConfig.mergeFormAttributes);
        bodyHandler.setPreallocateBodyBuffer(bodyConfig.preallocateBodyBuffer);
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                event.request().resume();
                bodyHandler.handle((Object)event);
            }
        };
    }

    private String ensureStartWithSlash(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }
}

