/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Template;
import io.quarkus.vertx.ConsumeEvent;
import io.quarkus.vertx.runtime.ClusterConfiguration;
import io.quarkus.vertx.runtime.EventBusConfiguration;
import io.quarkus.vertx.runtime.EventConsumerInvoker;
import io.quarkus.vertx.runtime.VertxConfiguration;
import io.quarkus.vertx.runtime.VertxProducer;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Template
public class VertxTemplate {
    static volatile Vertx vertx;
    static volatile List<MessageConsumer<?>> messageConsumers;

    public RuntimeValue<Vertx> configureVertx(BeanContainer container, VertxConfiguration config, Map<String, ConsumeEvent> messageConsumerConfigurations, LaunchMode launchMode, ShutdownContext shutdown) {
        this.initialize(config);
        this.registerMessageConsumers(messageConsumerConfigurations);
        VertxProducer producer = (VertxProducer)container.instance(VertxProducer.class, new Annotation[0]);
        producer.initialize(vertx);
        if (launchMode == LaunchMode.DEVELOPMENT) {
            shutdown.addShutdownTask(new Runnable(){

                @Override
                public void run() {
                    VertxTemplate.this.unregisterMessageConsumers();
                }
            });
        } else {
            shutdown.addShutdownTask(new Runnable(){

                @Override
                public void run() {
                    VertxTemplate.this.destroy();
                }
            });
        }
        return new RuntimeValue((Object)vertx);
    }

    void initialize(VertxConfiguration conf) {
        block7: {
            if (vertx != null) {
                return;
            }
            if (conf == null) {
                vertx = Vertx.vertx();
                return;
            }
            VertxOptions options = this.convertToVertxOptions(conf);
            if (!conf.useAsyncDNS) {
                System.setProperty("vertx.disableDnsResolver", "true");
            }
            System.setProperty("vertx.cacheDirBase", System.getProperty("java.io.tmpdir"));
            if (options.isClustered()) {
                AtomicReference failure = new AtomicReference();
                CountDownLatch latch = new CountDownLatch(1);
                Vertx.clusteredVertx((VertxOptions)options, ar -> {
                    if (ar.failed()) {
                        failure.set(ar.cause());
                    } else {
                        vertx = (Vertx)ar.result();
                    }
                    latch.countDown();
                });
                try {
                    latch.await();
                    if (failure.get() != null) {
                        throw new IllegalStateException("Unable to initialize the Vert.x instance", (Throwable)failure.get());
                    }
                    break block7;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("Unable to initialize the Vert.x instance", e);
                }
            }
            vertx = Vertx.vertx((VertxOptions)options);
        }
        messageConsumers = new ArrayList();
    }

    private VertxOptions convertToVertxOptions(VertxConfiguration conf) {
        VertxOptions options = new VertxOptions();
        this.setEventBusOptions(conf, options);
        this.initializeClusterOptions(conf, options);
        options.setFileSystemOptions(new FileSystemOptions().setFileCachingEnabled(conf.caching).setClassPathResolvingEnabled(conf.classpathResolving));
        options.setWorkerPoolSize(conf.workerPoolSize);
        options.setBlockedThreadCheckInterval(conf.warningExceptionTime.toMillis());
        options.setInternalBlockingPoolSize(conf.internalBlockingPoolSize);
        if (conf.eventLoopsPoolSize.isPresent()) {
            options.setEventLoopPoolSize(conf.eventLoopsPoolSize.getAsInt());
        }
        options.setWarningExceptionTime(conf.warningExceptionTime.toNanos());
        return options;
    }

    void destroy() {
        if (vertx != null) {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference problem = new AtomicReference();
            vertx.close(ar -> {
                if (ar.failed()) {
                    problem.set(ar.cause());
                }
                latch.countDown();
            });
            try {
                latch.await();
                if (problem.get() != null) {
                    throw new IllegalStateException("Error when closing Vertx instance", (Throwable)problem.get());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted when closing Vertx instance", e);
            }
            vertx = null;
            messageConsumers = null;
        }
    }

    private void initializeClusterOptions(VertxConfiguration conf, VertxOptions options) {
        ClusterConfiguration cluster = conf.cluster;
        options.setClustered(cluster.clustered);
        options.setClusterPingReplyInterval(cluster.pingReplyInterval.toMillis());
        options.setClusterPingInterval(cluster.pingInterval.toMillis());
        if (cluster.host != null) {
            options.setClusterHost(cluster.host);
        }
        if (cluster.port.isPresent()) {
            options.setClusterPort(cluster.port.getAsInt());
        }
        cluster.publicHost.ifPresent(arg_0 -> ((VertxOptions)options).setClusterPublicHost(arg_0));
        if (cluster.publicPort.isPresent()) {
            options.setClusterPort(cluster.publicPort.getAsInt());
        }
    }

    private void setEventBusOptions(VertxConfiguration conf, VertxOptions options) {
        JksOptions o;
        EventBusConfiguration eb = conf.eventbus;
        EventBusOptions opts = new EventBusOptions();
        opts.setAcceptBacklog(eb.acceptBacklog.orElse(-1));
        opts.setClientAuth(ClientAuth.valueOf((String)eb.clientAuth.toUpperCase()));
        opts.setConnectTimeout((int)Math.min(Integer.MAX_VALUE, eb.connectTimeout.toMillis()));
        opts.setIdleTimeout(eb.idleTimeout.isPresent() ? (int)Math.max(1L, Math.min(Integer.MAX_VALUE, eb.idleTimeout.get().getSeconds())) : 0);
        opts.setSendBufferSize(eb.sendBufferSize.orElse(-1));
        opts.setSoLinger(eb.soLinger.orElse(-1));
        opts.setSsl(eb.ssl);
        opts.setReceiveBufferSize(eb.receiveBufferSize.orElse(-1));
        opts.setReconnectAttempts(eb.reconnectAttempts);
        opts.setReconnectInterval(eb.reconnectInterval.toMillis());
        opts.setReuseAddress(eb.reuseAddress);
        opts.setReusePort(eb.reusePort);
        opts.setTrafficClass(eb.trafficClass.orElse(-1));
        opts.setTcpKeepAlive(eb.tcpKeepAlive);
        opts.setTcpNoDelay(eb.tcpNoDelay);
        opts.setTrustAll(eb.trustAll);
        if (eb.keyCertificatePem != null) {
            ArrayList certs = new ArrayList();
            ArrayList keys = new ArrayList();
            eb.keyCertificatePem.certs.ifPresent(s -> certs.addAll(Pattern.compile(",").splitAsStream((CharSequence)s).map(String::trim).collect(Collectors.toList())));
            eb.keyCertificatePem.keys.ifPresent(s -> keys.addAll(Pattern.compile(",").splitAsStream((CharSequence)s).map(String::trim).collect(Collectors.toList())));
            PemKeyCertOptions o2 = new PemKeyCertOptions().setCertPaths(certs).setKeyPaths(keys);
            opts.setPemKeyCertOptions(o2);
        }
        if (eb.keyCertificateJks != null) {
            o = new JksOptions();
            eb.keyCertificateJks.path.ifPresent(arg_0 -> ((JksOptions)o).setPath(arg_0));
            eb.keyCertificateJks.password.ifPresent(arg_0 -> ((JksOptions)o).setPassword(arg_0));
            opts.setKeyStoreOptions(o);
        }
        if (eb.keyCertificatePfx != null) {
            o = new PfxOptions();
            eb.keyCertificatePfx.path.ifPresent(arg_0 -> ((PfxOptions)o).setPath(arg_0));
            eb.keyCertificatePfx.password.ifPresent(arg_0 -> ((PfxOptions)o).setPassword(arg_0));
            opts.setPfxKeyCertOptions((PfxOptions)o);
        }
        if (eb.trustCertificatePem != null) {
            eb.trustCertificatePem.certs.ifPresent(s -> {
                PemTrustOptions o = new PemTrustOptions();
                Pattern.compile(",").splitAsStream((CharSequence)s).map(String::trim).forEach(arg_0 -> ((PemTrustOptions)o).addCertPath(arg_0));
                opts.setPemTrustOptions(o);
            });
        }
        if (eb.trustCertificateJks != null) {
            o = new JksOptions();
            eb.trustCertificateJks.path.ifPresent(arg_0 -> ((JksOptions)o).setPath(arg_0));
            eb.trustCertificateJks.password.ifPresent(arg_0 -> ((JksOptions)o).setPassword(arg_0));
            opts.setTrustStoreOptions(o);
        }
        if (eb.trustCertificatePfx != null) {
            o = new PfxOptions();
            eb.trustCertificatePfx.path.ifPresent(arg_0 -> ((PfxOptions)o).setPath(arg_0));
            eb.trustCertificatePfx.password.ifPresent(arg_0 -> ((PfxOptions)o).setPassword(arg_0));
            opts.setPfxTrustOptions((PfxOptions)o);
        }
        options.setEventBusOptions(opts);
    }

    void registerMessageConsumers(Map<String, ConsumeEvent> messageConsumerConfigurations) {
        if (!messageConsumerConfigurations.isEmpty()) {
            EventBus eventBus = vertx.eventBus();
            CountDownLatch latch = new CountDownLatch(messageConsumerConfigurations.size());
            for (Map.Entry<String, ConsumeEvent> entry : messageConsumerConfigurations.entrySet()) {
                EventConsumerInvoker invoker = this.createInvoker(entry.getKey());
                String address = entry.getValue().value();
                MessageConsumer consumer = entry.getValue().local() ? eventBus.localConsumer(address) : eventBus.consumer(address);
                consumer.handler(m -> invoker.invoke((Message<Object>)m));
                consumer.completionHandler(ar -> {
                    if (ar.succeeded()) {
                        latch.countDown();
                    }
                });
                messageConsumers.add(consumer);
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Unable to register all message consumer methods", e);
            }
        }
    }

    void unregisterMessageConsumers() {
        CountDownLatch latch = new CountDownLatch(messageConsumers.size());
        for (MessageConsumer<?> messageConsumer : messageConsumers) {
            messageConsumer.unregister(ar -> {
                if (ar.succeeded()) {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Unable to unregister all message consumer methods", e);
        }
        messageConsumers.clear();
    }

    private EventConsumerInvoker createInvoker(String invokerClassName) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = VertxProducer.class.getClassLoader();
            }
            Class<?> invokerClazz = cl.loadClass(invokerClassName);
            return (EventConsumerInvoker)invokerClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create invoker: " + invokerClassName, e);
        }
    }
}

