/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.runtime;

import io.quarkus.runtime.IOThreadDetector;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.ConsumeEvent;
import io.quarkus.vertx.runtime.EventConsumerInvoker;
import io.quarkus.vertx.runtime.VertxProducer;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageConsumer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class VertxRecorder {
    private static final Logger LOGGER = Logger.getLogger((String)VertxRecorder.class.getName());
    static volatile Vertx vertx;
    static volatile List<MessageConsumer<?>> messageConsumers;

    public void configureVertx(Supplier<Vertx> vertx, Map<String, ConsumeEvent> messageConsumerConfigurations, LaunchMode launchMode, ShutdownContext shutdown, Map<Class<?>, Class<?>> codecByClass) {
        VertxRecorder.vertx = vertx.get();
        messageConsumers = new ArrayList();
        this.registerMessageConsumers(messageConsumerConfigurations);
        this.registerCodecs(codecByClass);
        if (launchMode == LaunchMode.DEVELOPMENT) {
            shutdown.addShutdownTask(new Runnable(){

                @Override
                public void run() {
                    VertxRecorder.this.unregisterMessageConsumers();
                }
            });
        } else {
            shutdown.addShutdownTask(new Runnable(){

                @Override
                public void run() {
                    VertxRecorder.this.destroy();
                }
            });
        }
    }

    public IOThreadDetector detector() {
        return new IOThreadDetector(){

            public boolean isInIOThread() {
                return Context.isOnEventLoopThread();
            }
        };
    }

    public static Vertx getVertx() {
        return vertx;
    }

    void destroy() {
        messageConsumers = null;
    }

    void registerMessageConsumers(Map<String, ConsumeEvent> messageConsumerConfigurations) {
        if (!messageConsumerConfigurations.isEmpty()) {
            EventBus eventBus = vertx.eventBus();
            CountDownLatch latch = new CountDownLatch(messageConsumerConfigurations.size());
            for (Map.Entry<String, ConsumeEvent> entry : messageConsumerConfigurations.entrySet()) {
                EventConsumerInvoker invoker = this.createInvoker(entry.getKey());
                String address = entry.getValue().value();
                MessageConsumer consumer = entry.getValue().local() ? eventBus.localConsumer(address) : eventBus.consumer(address);
                consumer.handler(m -> {
                    try {
                        invoker.invoke((Message<Object>)m);
                    }
                    catch (Throwable e) {
                        m.fail(8185, e.getMessage());
                    }
                });
                consumer.completionHandler(ar -> {
                    if (ar.succeeded()) {
                        latch.countDown();
                    }
                });
                messageConsumers.add(consumer);
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Unable to register all message consumer methods", e);
            }
        }
    }

    void unregisterMessageConsumers() {
        CountDownLatch latch = new CountDownLatch(messageConsumers.size());
        for (MessageConsumer<?> messageConsumer : messageConsumers) {
            messageConsumer.unregister(ar -> {
                if (ar.succeeded()) {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Unable to unregister all message consumer methods", e);
        }
        messageConsumers.clear();
    }

    private EventConsumerInvoker createInvoker(String invokerClassName) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = VertxProducer.class.getClassLoader();
            }
            Class<?> invokerClazz = cl.loadClass(invokerClassName);
            return (EventConsumerInvoker)invokerClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create invoker: " + invokerClassName, e);
        }
    }

    private void registerCodecs(Map<Class<?>, Class<?>> codecByClass) {
        EventBus eventBus = vertx.eventBus();
        for (Map.Entry<Class<?>, Class<?>> codecEntry : codecByClass.entrySet()) {
            Class<?> target = codecEntry.getKey();
            Class<?> codec = codecEntry.getValue();
            try {
                if (MessageCodec.class.isAssignableFrom(codec)) {
                    MessageCodec messageCodec = (MessageCodec)codec.newInstance();
                    eventBus.registerDefaultCodec(target, messageCodec);
                    continue;
                }
                LOGGER.error((Object)String.format("The codec %s does not inherit from MessageCodec ", target.toString()));
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.error((Object)("Cannot instantiate the MessageCodec " + target.toString()), (Throwable)e);
            }
        }
    }

    public RuntimeValue<Vertx> forceStart(Supplier<Vertx> vertx) {
        return new RuntimeValue((Object)vertx.get());
    }
}

