/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.core.runtime.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.OpenSslServerContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.quarkus.vertx.core.runtime.graal.Target_io_vertx_core_net_impl_DefaultJDKCipherSuite;
import io.vertx.core.VertxException;
import io.vertx.core.impl.VertxInternal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;

@TargetClass(className="io.vertx.core.net.impl.SSLHelper")
final class Target_io_vertx_core_net_impl_SSLHelper {
    @Alias
    private boolean client;
    @Alias
    private Set<String> enabledCipherSuites;
    @Alias
    private boolean openSsl;
    @Alias
    private List<String> applicationProtocols;

    Target_io_vertx_core_net_impl_SSLHelper() {
    }

    @Alias
    private KeyManagerFactory getKeyMgrFactory(VertxInternal vertx) throws Exception {
        return null;
    }

    @Substitute
    private SslContext createContext(VertxInternal vertx, boolean useAlpn, X509KeyManager mgr, TrustManagerFactory trustMgrFactory) {
        try {
            SslContext ctx;
            KeyManagerFactory keyMgrFactory;
            SslContextBuilder builder;
            if (this.client) {
                builder = SslContextBuilder.forClient();
                keyMgrFactory = this.getKeyMgrFactory(vertx);
                if (keyMgrFactory != null) {
                    builder.keyManager(keyMgrFactory);
                }
            } else if (mgr != null) {
                builder = SslContextBuilder.forServer((PrivateKey)mgr.getPrivateKey(null), null, (X509Certificate[])mgr.getCertificateChain(null));
            } else {
                keyMgrFactory = this.getKeyMgrFactory(vertx);
                if (keyMgrFactory == null) {
                    throw new VertxException("Key/certificate is mandatory for SSL");
                }
                builder = SslContextBuilder.forServer((KeyManagerFactory)keyMgrFactory);
            }
            Collection<String> cipherSuites = this.enabledCipherSuites;
            if (this.openSsl) {
                throw new UnsupportedOperationException("OpenSSL not supported in native images");
            }
            builder.sslProvider(SslProvider.JDK);
            if (cipherSuites == null || cipherSuites.isEmpty()) {
                cipherSuites = Target_io_vertx_core_net_impl_DefaultJDKCipherSuite.get();
            }
            if (trustMgrFactory != null) {
                builder.trustManager(trustMgrFactory);
            }
            if (cipherSuites != null && cipherSuites.size() > 0) {
                builder.ciphers(cipherSuites);
            }
            if (useAlpn && this.applicationProtocols != null && this.applicationProtocols.size() > 0) {
                builder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, this.applicationProtocols));
            }
            if ((ctx = builder.build()) instanceof OpenSslServerContext) {
                throw new UnsupportedOperationException("OpenSSL not supported in native images");
            }
            return ctx;
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }
}

