/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.core.runtime;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.FastThreadLocal;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.runtime.ExecutorRecorder;
import io.quarkus.runtime.IOThreadDetector;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.ThreadPoolConfig;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.core.runtime.QuarkusExecutorFactory;
import io.quarkus.vertx.core.runtime.SSLConfigHelper;
import io.quarkus.vertx.core.runtime.VertxLogDelegateFactory;
import io.quarkus.vertx.core.runtime.VertxMDC;
import io.quarkus.vertx.core.runtime.config.AddressResolverConfiguration;
import io.quarkus.vertx.core.runtime.config.ClusterConfiguration;
import io.quarkus.vertx.core.runtime.config.EventBusConfiguration;
import io.quarkus.vertx.core.runtime.config.VertxConfiguration;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.quarkus.vertx.mdc.provider.LateBoundMDCProvider;
import io.quarkus.vertx.runtime.VertxCurrentContextFactory;
import io.quarkus.vertx.runtime.jackson.QuarkusJacksonFactory;
import io.smallrye.common.cpu.ProcessorInfo;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxBuilder;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.spi.ExecutorServiceFactory;
import io.vertx.core.spi.VertxThreadFactory;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.jboss.logmanager.MDCProvider;
import org.jboss.threads.ContextHandler;

@Recorder
public class VertxCoreRecorder {
    private static final String LOGGER_FACTORY_NAME_SYS_PROP = "vertx.logger-delegate-factory-class-name";
    private static final Logger LOGGER;
    public static final String VERTX_CACHE = "vertx-cache";
    static volatile VertxSupplier vertx;
    static volatile int blockingThreadPoolSize;
    private static volatile String webDeploymentId;
    private static final Set<Thread> devModeThreads;
    private static volatile ClassLoader currentDevModeNewThreadCreationClassLoader;

    public Supplier<Vertx> configureVertx(VertxConfiguration config, ThreadPoolConfig threadPoolConfig, LaunchMode launchMode, ShutdownContext shutdown, List<Consumer<VertxOptions>> customizers, ExecutorService executorProxy) {
        QuarkusExecutorFactory.sharedExecutor = executorProxy;
        if (launchMode != LaunchMode.DEVELOPMENT) {
            vertx = new VertxSupplier(launchMode, config, customizers, threadPoolConfig, shutdown);
            shutdown.addLastShutdownTask(new Runnable(){

                @Override
                public void run() {
                    VertxCoreRecorder.this.destroy();
                    QuarkusExecutorFactory.sharedExecutor = null;
                    currentDevModeNewThreadCreationClassLoader = null;
                }
            });
        } else {
            if (vertx == null) {
                vertx = new VertxSupplier(launchMode, config, customizers, threadPoolConfig, shutdown);
            } else if (VertxCoreRecorder.vertx.v != null) {
                this.tryCleanTccl();
            }
            shutdown.addLastShutdownTask(new Runnable(){

                @Override
                public void run() {
                    ArrayList<CountDownLatch> latches = new ArrayList<CountDownLatch>();
                    if (VertxCoreRecorder.vertx.v != null) {
                        HashSet ids = new HashSet(VertxCoreRecorder.vertx.v.deploymentIDs());
                        for (String id : ids) {
                            if (id.equals(webDeploymentId)) continue;
                            final CountDownLatch latch = new CountDownLatch(1);
                            latches.add(latch);
                            VertxCoreRecorder.vertx.v.undeploy(id, (Handler)new Handler<AsyncResult<Void>>(){

                                public void handle(AsyncResult<Void> event) {
                                    latch.countDown();
                                }
                            });
                        }
                        for (CountDownLatch latch : latches) {
                            try {
                                latch.await();
                            }
                            catch (InterruptedException e) {
                                LOGGER.error((Object)"Failed waiting for verticle undeploy", (Throwable)e);
                            }
                        }
                    }
                    QuarkusExecutorFactory.sharedExecutor = null;
                }
            });
        }
        return vertx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryCleanTccl() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Set<Thread> set = devModeThreads;
        synchronized (set) {
            currentDevModeNewThreadCreationClassLoader = cl;
            ArrayList<Thread> terminated = new ArrayList<Thread>();
            for (Thread t : devModeThreads) {
                if (t.getState() == Thread.State.TERMINATED) {
                    terminated.add(t);
                    continue;
                }
                t.setContextClassLoader(cl);
            }
            terminated.forEach(devModeThreads::remove);
        }
    }

    public IOThreadDetector detector() {
        return new IOThreadDetector(){

            public boolean isInIOThread() {
                return Context.isOnEventLoopThread();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutdownDevMode() {
        if (vertx != null) {
            final CountDownLatch latch = new CountDownLatch(1);
            vertx.get().close((Handler)new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> event) {
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                Set<Thread> set = devModeThreads;
                synchronized (set) {
                    devModeThreads.clear();
                    currentDevModeNewThreadCreationClassLoader = null;
                }
            }
        }
    }

    public static Supplier<Vertx> getVertx() {
        return vertx;
    }

    public static Vertx initialize(VertxConfiguration conf, VertxOptionsCustomizer customizer, ThreadPoolConfig threadPoolConfig, ShutdownContext shutdown, final LaunchMode launchMode) {
        Vertx vertx;
        VertxOptions options = new VertxOptions();
        if (conf != null) {
            VertxCoreRecorder.convertToVertxOptions(conf, options, threadPoolConfig, true, shutdown);
        }
        if (customizer != null) {
            customizer.customize(options);
        }
        final Optional<ClassLoader> nonDevModeTccl = VertxCoreRecorder.setupThreadFactoryTccl(launchMode);
        VertxThreadFactory vertxThreadFactory = new VertxThreadFactory(){

            public VertxThread newVertxThread(Runnable target, String name, boolean worker, long maxExecTime, TimeUnit maxExecTimeUnit) {
                return VertxCoreRecorder.createVertxThread(target, name, worker, maxExecTime, maxExecTimeUnit, launchMode, nonDevModeTccl);
            }
        };
        if (conf != null && conf.cluster() != null && conf.cluster().clustered()) {
            final CompletableFuture latch = new CompletableFuture();
            new VertxBuilder(options).threadFactory(vertxThreadFactory).executorServiceFactory((ExecutorServiceFactory)new QuarkusExecutorFactory(conf, launchMode)).init().clusteredVertx((Handler)new Handler<AsyncResult<Vertx>>(){

                public void handle(AsyncResult<Vertx> ar) {
                    if (ar.failed()) {
                        latch.completeExceptionally(ar.cause());
                    } else {
                        latch.complete((Vertx)ar.result());
                    }
                }
            });
            vertx = (Vertx)latch.join();
        } else {
            vertx = new VertxBuilder(options).threadFactory(vertxThreadFactory).executorServiceFactory((ExecutorServiceFactory)new QuarkusExecutorFactory(conf, launchMode)).init().vertx();
        }
        vertx.exceptionHandler((Handler)new Handler<Throwable>(){

            public void handle(Throwable error) {
                LOGGER.error((Object)"Uncaught exception received by Vert.x", error);
            }
        });
        LateBoundMDCProvider.setMDCProviderDelegate((MDCProvider)VertxMDC.INSTANCE);
        return VertxCoreRecorder.logVertxInitialization(vertx);
    }

    private static Optional<ClassLoader> setupThreadFactoryTccl(LaunchMode launchMode) {
        Optional<ClassLoader> nonDevModeTccl;
        if (launchMode == LaunchMode.DEVELOPMENT) {
            currentDevModeNewThreadCreationClassLoader = Thread.currentThread().getContextClassLoader();
            nonDevModeTccl = Optional.empty();
        } else {
            nonDevModeTccl = Optional.of(Thread.currentThread().getContextClassLoader());
        }
        return nonDevModeTccl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VertxThread createVertxThread(Runnable target, String name, boolean worker, long maxExecTime, TimeUnit maxExecTimeUnit, LaunchMode launchMode, Optional<ClassLoader> nonDevModeTccl) {
        VertxThread thread = VertxThreadFactory.INSTANCE.newVertxThread(target, name, worker, maxExecTime, maxExecTimeUnit);
        if (launchMode == LaunchMode.DEVELOPMENT) {
            Set<Thread> set = devModeThreads;
            synchronized (set) {
                VertxCoreRecorder.setNewThreadTccl(thread);
                devModeThreads.add((Thread)thread);
            }
        } else {
            thread.setContextClassLoader(nonDevModeTccl.get());
        }
        return thread;
    }

    private static Vertx logVertxInitialization(Vertx vertx) {
        LOGGER.debugf("Vertx has Native Transport Enabled: %s", (Object)vertx.isNativeTransportEnabled());
        return vertx;
    }

    private static VertxOptions convertToVertxOptions(VertxConfiguration conf, VertxOptions options, ThreadPoolConfig threadPoolConfig, boolean allowClustering, ShutdownContext shutdown) {
        if (!conf.useAsyncDNS()) {
            System.setProperty("vertx.disableDnsResolver", "true");
        }
        VertxCoreRecorder.setAddressResolverOptions(conf, options);
        if (allowClustering) {
            VertxCoreRecorder.setEventBusOptions(conf, options);
            VertxCoreRecorder.initializeClusterOptions(conf, options);
        }
        FileSystemOptions fileSystemOptions = new FileSystemOptions().setFileCachingEnabled(conf.caching()).setClassPathResolvingEnabled(conf.classpathResolving());
        String fileCacheDir = System.getProperty("vertx.cacheDirBase");
        if (fileCacheDir == null) {
            fileCacheDir = conf.cacheDirectory().orElse(null);
        }
        if (fileCacheDir == null) {
            boolean cacheDirRequired;
            File tmp = new File(System.getProperty("java.io.tmpdir", ".") + File.separator + VERTX_CACHE);
            boolean bl = cacheDirRequired = conf.caching() || conf.classpathResolving();
            if (!tmp.isDirectory() && cacheDirRequired) {
                String os;
                if (!tmp.mkdirs()) {
                    LOGGER.warnf("Unable to create Vert.x cache directory : %s", (Object)tmp.getAbsolutePath());
                }
                if (!((os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH)).contains("windows") || tmp.setReadable(true, false) && tmp.setWritable(true, false))) {
                    LOGGER.warnf("Unable to make the Vert.x cache directory (%s) world readable and writable", (Object)tmp.getAbsolutePath());
                }
            }
            if (cacheDirRequired) {
                final File cache = VertxCoreRecorder.getRandomDirectory(tmp);
                LOGGER.debugf("Vert.x Cache configured to: %s", (Object)cache.getAbsolutePath());
                fileSystemOptions.setFileCacheDir(cache.getAbsolutePath());
                if (shutdown != null) {
                    shutdown.addLastShutdownTask(new Runnable(){

                        @Override
                        public void run() {
                            VertxCoreRecorder.deleteDirectory(cache);
                        }
                    });
                }
            }
        } else {
            fileSystemOptions.setFileCacheDir(fileCacheDir);
        }
        options.setFileSystemOptions(fileSystemOptions);
        options.setWorkerPoolSize(ExecutorRecorder.getMaxSize((ThreadPoolConfig)threadPoolConfig));
        options.setInternalBlockingPoolSize(conf.internalBlockingPoolSize());
        blockingThreadPoolSize = conf.internalBlockingPoolSize();
        options.setBlockedThreadCheckInterval(conf.warningExceptionTime().toMillis());
        if (conf.eventLoopsPoolSize().isPresent()) {
            options.setEventLoopPoolSize(conf.eventLoopsPoolSize().getAsInt());
        } else {
            options.setEventLoopPoolSize(VertxCoreRecorder.calculateDefaultIOThreads());
        }
        options.setMaxEventLoopExecuteTime(conf.maxEventLoopExecuteTime().toMillis());
        options.setMaxEventLoopExecuteTimeUnit(TimeUnit.MILLISECONDS);
        options.setMaxWorkerExecuteTime(conf.maxWorkerExecuteTime().toMillis());
        options.setMaxWorkerExecuteTimeUnit(TimeUnit.MILLISECONDS);
        options.setWarningExceptionTime(conf.warningExceptionTime().toNanos());
        options.setPreferNativeTransport(conf.preferNativeTransport());
        return options;
    }

    private static File getRandomDirectory(File tmp) {
        File cache = new File(tmp, Long.toString(new Random().nextLong()));
        if (cache.isDirectory()) {
            return VertxCoreRecorder.getRandomDirectory(tmp);
        }
        return cache;
    }

    private static int calculateDefaultIOThreads() {
        int recommended = ProcessorInfo.availableProcessors();
        long mem = Runtime.getRuntime().maxMemory();
        long memInMb = mem / 0x100000L;
        long maxAllowed = memInMb / 10L;
        return (int)Math.max(2L, Math.min(maxAllowed, (long)recommended));
    }

    void destroy() {
        if (vertx != null && VertxCoreRecorder.vertx.v != null) {
            FastThreadLocal.destroy();
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference problem = new AtomicReference();
            VertxCoreRecorder.vertx.v.close((Handler)new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> ar) {
                    if (ar.failed()) {
                        problem.set(ar.cause());
                    }
                    latch.countDown();
                }
            });
            try {
                latch.await();
                if (problem.get() != null) {
                    throw new IllegalStateException("Error when closing Vert.x instance", (Throwable)problem.get());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Exception when closing Vert.x instance", e);
            }
            VertxMDC.INSTANCE.clear();
            LateBoundMDCProvider.setMDCProviderDelegate(null);
            vertx = null;
        }
    }

    private static void initializeClusterOptions(VertxConfiguration conf, VertxOptions options) {
        ClusterConfiguration cluster = conf.cluster();
        options.getEventBusOptions().setClusterPingReplyInterval(cluster.pingReplyInterval().toMillis());
        options.getEventBusOptions().setClusterPingInterval(cluster.pingInterval().toMillis());
        if (cluster.host() != null) {
            options.getEventBusOptions().setHost(cluster.host());
        }
        if (cluster.port().isPresent()) {
            options.getEventBusOptions().setPort(cluster.port().getAsInt());
        }
        if (cluster.publicHost().isPresent()) {
            options.getEventBusOptions().setClusterPublicHost(cluster.publicHost().get());
        }
        if (cluster.publicPort().isPresent()) {
            options.getEventBusOptions().setPort(cluster.publicPort().getAsInt());
        }
    }

    private static void setEventBusOptions(VertxConfiguration conf, VertxOptions options) {
        EventBusConfiguration eb = conf.eventbus();
        EventBusOptions opts = new EventBusOptions();
        opts.setAcceptBacklog(eb.acceptBacklog().orElse(-1));
        opts.setClientAuth(ClientAuth.valueOf((String)eb.clientAuth().toUpperCase()));
        opts.setConnectTimeout((int)Math.min(Integer.MAX_VALUE, eb.connectTimeout().toMillis()));
        opts.setIdleTimeout(eb.idleTimeout().isPresent() ? (int)Math.max(1L, Math.min(Integer.MAX_VALUE, eb.idleTimeout().get().getSeconds())) : 0);
        opts.setSendBufferSize(eb.sendBufferSize().orElse(-1));
        opts.setSoLinger(eb.soLinger().orElse(-1));
        opts.setSsl(eb.ssl());
        opts.setReceiveBufferSize(eb.receiveBufferSize().orElse(-1));
        opts.setReconnectAttempts(eb.reconnectAttempts());
        opts.setReconnectInterval(eb.reconnectInterval().toMillis());
        opts.setReuseAddress(eb.reuseAddress());
        opts.setReusePort(eb.reusePort());
        opts.setTrafficClass(eb.trafficClass().orElse(-1));
        opts.setTcpKeepAlive(eb.tcpKeepAlive());
        opts.setTcpNoDelay(eb.tcpNoDelay());
        opts.setTrustAll(eb.trustAll());
        SSLConfigHelper.configurePemKeyCertOptions((TCPSSLOptions)opts, eb.keyCertificatePem());
        SSLConfigHelper.configureJksKeyCertOptions((TCPSSLOptions)opts, eb.keyCertificateJks());
        SSLConfigHelper.configurePfxKeyCertOptions((TCPSSLOptions)opts, eb.keyCertificatePfx());
        SSLConfigHelper.configurePemTrustOptions((TCPSSLOptions)opts, eb.trustCertificatePem());
        SSLConfigHelper.configureJksKeyCertOptions((TCPSSLOptions)opts, eb.trustCertificateJks());
        SSLConfigHelper.configurePfxTrustOptions((TCPSSLOptions)opts, eb.trustCertificatePfx());
        options.setEventBusOptions(opts);
    }

    private static void setAddressResolverOptions(VertxConfiguration conf, VertxOptions options) {
        AddressResolverConfiguration ar = conf.resolver();
        AddressResolverOptions opts = new AddressResolverOptions();
        opts.setCacheMaxTimeToLive(ar.cacheMaxTimeToLive());
        opts.setCacheMinTimeToLive(ar.cacheMinTimeToLive());
        opts.setCacheNegativeTimeToLive(ar.cacheNegativeTimeToLive());
        opts.setMaxQueries(ar.maxQueries());
        opts.setQueryTimeout(ar.queryTimeout().toMillis());
        opts.setHostsRefreshPeriod(ar.hostRefreshPeriod());
        opts.setOptResourceEnabled(ar.optResourceEnabled());
        opts.setRdFlag(ar.rdFlag());
        opts.setNdots(ar.ndots());
        opts.setRoundRobinInetAddress(ar.roundRobinInetAddress());
        if (ar.hostsPath().isPresent()) {
            opts.setHostsPath(ar.hostsPath().get());
        }
        if (ar.servers().isPresent()) {
            opts.setServers(ar.servers().get());
        }
        if (ar.searchDomains().isPresent()) {
            opts.setSearchDomains(ar.searchDomains().get());
        }
        if (ar.rotateServers().isPresent()) {
            opts.setRotateServers(ar.rotateServers().get().booleanValue());
        }
        options.setAddressResolverOptions(opts);
    }

    public Supplier<EventLoopGroup> bossSupplier() {
        return new Supplier<EventLoopGroup>(){

            @Override
            public EventLoopGroup get() {
                vertx.get();
                return ((VertxImpl)VertxCoreRecorder.vertx.v).getAcceptorEventLoopGroup();
            }
        };
    }

    public Supplier<EventLoopGroup> mainSupplier() {
        return new Supplier<EventLoopGroup>(){

            @Override
            public EventLoopGroup get() {
                return vertx.get().nettyEventLoopGroup();
            }
        };
    }

    public Supplier<Integer> calculateEventLoopThreads(VertxConfiguration conf) {
        final int threads = conf.eventLoopsPoolSize().isPresent() ? conf.eventLoopsPoolSize().getAsInt() : VertxCoreRecorder.calculateDefaultIOThreads();
        return new Supplier<Integer>(){

            @Override
            public Integer get() {
                return threads;
            }
        };
    }

    public ThreadFactory createThreadFactory(final LaunchMode launchMode) {
        final Optional<ClassLoader> nonDevModeTccl = VertxCoreRecorder.setupThreadFactoryTccl(launchMode);
        final AtomicInteger threadCount = new AtomicInteger(0);
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                VertxThread thread = VertxCoreRecorder.createVertxThread(runnable, "executor-thread-" + threadCount.getAndIncrement(), true, 0L, null, launchMode, nonDevModeTccl);
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    public void resetMapper(ShutdownContext shutdown) {
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                QuarkusJacksonFactory.reset();
            }
        });
    }

    private static void setNewThreadTccl(VertxThread thread) {
        ClassLoader cl = currentDevModeNewThreadCreationClassLoader;
        if (cl == null) {
            cl = VertxCoreRecorder.class.getClassLoader();
        }
        thread.setContextClassLoader(cl);
    }

    public RuntimeValue<List<String>> getIgnoredArcContextKeysSupplier() {
        VertxCurrentContextFactory currentContextFactory = (VertxCurrentContextFactory)Arc.container().getCurrentContextFactory();
        return new RuntimeValue(currentContextFactory.keys());
    }

    public ContextHandler<Object> executionContextHandler(List<RuntimeValue<List<String>>> ignoredKeysSuppliers) {
        ArrayList ignoredKeys;
        if (ignoredKeysSuppliers.isEmpty()) {
            ignoredKeys = null;
        } else {
            ignoredKeys = new ArrayList();
            for (RuntimeValue<List<String>> ignoredKeysSupplier : ignoredKeysSuppliers) {
                ignoredKeys.addAll((Collection)ignoredKeysSupplier.getValue());
            }
        }
        return new ContextHandler<Object>(){

            public Object captureContext() {
                return Vertx.currentContext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runWith(Runnable task, Object context) {
                ContextInternal currentContext = (ContextInternal)Vertx.currentContext();
                if (context != null && context != currentContext) {
                    ConcurrentMap local;
                    ContextInternal vertxContext = (ContextInternal)context;
                    if (ignoredKeys != null && this.containsIgnoredKey(ignoredKeys, local = vertxContext.localContextData())) {
                        vertxContext = vertxContext.duplicate();
                        vertxContext.localContextData().putAll(local);
                        ignoredKeys.forEach(vertxContext.localContextData()::remove);
                        VertxContextSafetyToggle.setContextSafe((Context)vertxContext, true);
                    }
                    vertxContext.beginDispatch();
                    try {
                        task.run();
                    }
                    finally {
                        vertxContext.endDispatch(currentContext);
                    }
                } else {
                    task.run();
                }
            }

            private boolean containsIgnoredKey(List<String> keys, Map<Object, Object> localContextData) {
                if (keys.isEmpty()) {
                    return false;
                }
                if (keys.size() == 1) {
                    return localContextData.containsKey(keys.get(0));
                }
                for (String key : keys) {
                    if (!localContextData.containsKey(key)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Supplier<Vertx> recoverFailedStart(VertxConfiguration config, ThreadPoolConfig threadPoolConfig) {
        vertx = new VertxSupplier(LaunchMode.DEVELOPMENT, config, Collections.emptyList(), threadPoolConfig, null);
        return vertx;
    }

    public void configureQuarkusLoggerFactory() {
        String loggerClassName = System.getProperty(LOGGER_FACTORY_NAME_SYS_PROP);
        if (loggerClassName == null) {
            System.setProperty(LOGGER_FACTORY_NAME_SYS_PROP, VertxLogDelegateFactory.class.getName());
        }
    }

    public static void setWebDeploymentId(String webDeploymentId) {
        VertxCoreRecorder.webDeploymentId = webDeploymentId;
    }

    private static void deleteDirectory(File directory) {
        File[] children = directory.listFiles();
        if (children != null) {
            for (File child : children) {
                VertxCoreRecorder.deleteDirectory(child);
            }
        }
        directory.delete();
    }

    static {
        System.setProperty("vertx.disableTCCL", "true");
        LOGGER = Logger.getLogger((String)VertxCoreRecorder.class.getName());
        devModeThreads = new HashSet<Thread>();
    }

    static class VertxSupplier
    implements Supplier<Vertx> {
        final LaunchMode launchMode;
        final VertxConfiguration config;
        final VertxOptionsCustomizer customizer;
        final ThreadPoolConfig threadPoolConfig;
        final ShutdownContext shutdown;
        Vertx v;

        VertxSupplier(LaunchMode launchMode, VertxConfiguration config, List<Consumer<VertxOptions>> customizers, ThreadPoolConfig threadPoolConfig, ShutdownContext shutdown) {
            this.launchMode = launchMode;
            this.config = config;
            this.customizer = new VertxOptionsCustomizer(customizers);
            this.threadPoolConfig = threadPoolConfig;
            this.shutdown = shutdown;
        }

        @Override
        public synchronized Vertx get() {
            if (this.v == null) {
                this.v = VertxCoreRecorder.initialize(this.config, this.customizer, this.threadPoolConfig, this.shutdown, this.launchMode);
            }
            return this.v;
        }
    }

    static class VertxOptionsCustomizer {
        final List<Consumer<VertxOptions>> customizers;

        VertxOptionsCustomizer(List<Consumer<VertxOptions>> customizers) {
            this.customizers = customizers;
            if (Arc.container() != null) {
                List instances = Arc.container().listAll(io.quarkus.vertx.VertxOptionsCustomizer.class, new Annotation[0]);
                for (InstanceHandle customizer : instances) {
                    customizers.add((Consumer)customizer.get());
                }
            }
        }

        VertxOptions customize(VertxOptions options) {
            for (Consumer<VertxOptions> x : this.customizers) {
                x.accept(options);
            }
            return options;
        }
    }
}

