/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.webdependency.locator.deployment;

import io.mvnpm.importmap.Aggregator;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.spi.GeneratedStaticResourceBuildItem;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.quarkus.webdependency.locator.deployment.ImportMapBuildItem;
import io.quarkus.webdependency.locator.deployment.WebDependencyLocatorConfig;
import io.quarkus.webdependency.locator.runtime.WebDependencyLocatorRecorder;
import io.vertx.core.Handler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class WebDependencyLocatorProcessor {
    private static final Logger log = Logger.getLogger((String)WebDependencyLocatorProcessor.class.getName());
    private static final String WEBJARS_PREFIX = "META-INF/resources/webjars";
    private static final String WEBJARS_NAME = "webjars";
    private static final String WEBJARS_PATH = "webjars";
    private static final String MVNPM_PREFIX = "META-INF/resources/_static";
    private static final String MVNPM_NAME = "mvnpm";
    private static final String MVNPM_PATH = "_static";
    private static final String IMPORTMAP_ROOT = "_importmap";
    private static final String IMPORTMAP_FILENAME = "generated_importmap.js";
    private static final String HASH_BUNDLE = "#bundle";
    private static final String HASH_IMPORTMAP = "#importmap";
    private static final String IMPORTMAP_REPLACEMENT = "<script src='/_importmap/generated_importmap.js'></script>";
    private static final String TAB = "\t";
    private static final String TAB2 = "\t\t";
    private static final String SLASH = "/";
    private static final String STAR = "*";
    private static final String DOT_HTML = ".html";
    private static final String DOT_CSS = ".css";
    private static final String DOT_JS = ".js";

    @BuildStep
    public void feature(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.WEB_DEPENDENCY_LOCATOR));
    }

    @BuildStep
    public void findRelevantFiles(BuildProducer<GeneratedStaticResourceBuildItem> generatedStaticProducer, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedProducer, WebDependencyLocatorConfig config) throws IOException {
        QuarkusClassLoader.visitRuntimeResources((String)config.webRoot(), visit -> {
            Path web = visit.getPath();
            if (Files.isDirectory(web, new LinkOption[0])) {
                hotDeploymentWatchedProducer.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(config.webRoot() + "/**"));
                Path app = web.resolve(config.appRoot());
                ArrayList cssFiles = new ArrayList();
                ArrayList jsFiles = new ArrayList();
                if (Files.exists(app, new LinkOption[0])) {
                    hotDeploymentWatchedProducer.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(config.webRoot() + SLASH + config.appRoot() + "/**"));
                    try (Stream<Path> appstream = Files.walk(app, new FileVisitOption[0]);){
                        appstream.forEach(path -> {
                            if (Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(DOT_CSS)) {
                                cssFiles.add(web.relativize((Path)path));
                            } else if (Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(DOT_JS)) {
                                jsFiles.add(web.relativize((Path)path));
                            }
                        });
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                try (Stream<Path> webstream = Files.walk(web, new FileVisitOption[0]);){
                    webstream.forEach(path -> {
                        if (Files.isRegularFile(path, new LinkOption[0])) {
                            Object endpoint = SLASH + String.valueOf(web.relativize((Path)path));
                            endpoint = ((String)endpoint).replace('\\', '/');
                            try {
                                if (path.toString().endsWith(DOT_HTML)) {
                                    generatedStaticProducer.produce((BuildItem)new GeneratedStaticResourceBuildItem((String)endpoint, this.processHtml((Path)path, cssFiles, jsFiles)));
                                } else {
                                    generatedStaticProducer.produce((BuildItem)new GeneratedStaticResourceBuildItem((String)endpoint, path));
                                }
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        }
                    });
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
    }

    private byte[] processHtml(Path path, List<Path> cssFiles, List<Path> jsFiles) throws IOException {
        StringJoiner modifiedContent = new StringJoiner(System.lineSeparator());
        Files.lines(path).forEach(line -> {
            String modifiedLine = WebDependencyLocatorProcessor.processLine(line, cssFiles, jsFiles);
            modifiedContent.add(modifiedLine);
        });
        String result = modifiedContent.toString();
        return result.getBytes();
    }

    private static String processLine(String line, List<Path> cssFiles, List<Path> jsFiles) {
        if (line.contains(HASH_IMPORTMAP)) {
            line = "\t\t<script src='/_importmap/generated_importmap.js'></script>";
        }
        if (line.contains(HASH_BUNDLE)) {
            try (StringWriter sw = new StringWriter();){
                if (!cssFiles.isEmpty()) {
                    for (Path css : cssFiles) {
                        sw.write("\t\t<link href='" + css.toString().replace("\\", SLASH) + "' rel='stylesheet'>" + System.lineSeparator());
                    }
                }
                sw.write("\t\t<script src='/_importmap/generated_importmap.js'></script>");
                if (!jsFiles.isEmpty()) {
                    sw.write(System.lineSeparator());
                    sw.write("\t\t<script type='module'>" + System.lineSeparator());
                    for (Path js : jsFiles) {
                        sw.write("\t\t\timport '" + js.toString().replace("\\", SLASH) + "';" + System.lineSeparator());
                    }
                    sw.write("\t\t</script>");
                }
                line = sw.toString();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return line;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void findWebDependenciesAndCreateHandler(WebDependencyLocatorConfig config, VertxHttpBuildTimeConfig httpBuildTimeConfig, BuildProducer<RouteBuildItem> routes, BuildProducer<ImportMapBuildItem> im, CurateOutcomeBuildItem curateOutcome, WebDependencyLocatorRecorder recorder) throws Exception {
        LibInfo webjarsLibInfo = this.getLibInfo(curateOutcome, WEBJARS_PREFIX, "webjars");
        LibInfo mvnpmNameLibInfo = this.getLibInfo(curateOutcome, MVNPM_PREFIX, MVNPM_NAME);
        if (webjarsLibInfo != null || mvnpmNameLibInfo != null) {
            if (webjarsLibInfo != null && config.versionReroute()) {
                routes.produce((BuildItem)this.createRouteBuildItem(recorder, httpBuildTimeConfig, "webjars", webjarsLibInfo.nameVersionMap));
            }
            if (mvnpmNameLibInfo != null) {
                if (config.versionReroute()) {
                    routes.produce((BuildItem)this.createRouteBuildItem(recorder, httpBuildTimeConfig, MVNPM_PATH, mvnpmNameLibInfo.nameVersionMap));
                }
                Aggregator aggregator = new Aggregator(mvnpmNameLibInfo.jars);
                Map<String, String> importMappings = config.importMappings();
                if (!importMappings.containsKey(config.appRoot() + SLASH)) {
                    importMappings.put(config.appRoot() + SLASH, SLASH + config.appRoot() + SLASH);
                }
                if (!config.importMappings().isEmpty()) {
                    aggregator.addMappings(config.importMappings());
                }
                String importMap = aggregator.aggregateAsJson(false);
                im.produce((BuildItem)new ImportMapBuildItem(importMap));
                String path = this.getRootPath(httpBuildTimeConfig, IMPORTMAP_ROOT) + IMPORTMAP_FILENAME;
                Handler importMapHandler = recorder.getImportMapHandler(path, importMap);
                routes.produce((BuildItem)RouteBuildItem.builder().route("/_importmap/generated_importmap.js").handler(importMapHandler).build());
            }
        } else {
            log.warn((Object)"No WebJars or mvnpm jars were found in the project. Requests to the /webjars/ and/or /_static/ path will always return 404 (Not Found)");
        }
    }

    private RouteBuildItem createRouteBuildItem(WebDependencyLocatorRecorder recorder, VertxHttpBuildTimeConfig httpBuildTimeConfig, String path, Map<String, String> nameVersionMap) {
        Handler handler = recorder.getHandler(this.getRootPath(httpBuildTimeConfig, path), nameVersionMap);
        return RouteBuildItem.builder().route(SLASH + path + "/*").handler(handler).build();
    }

    private LibInfo getLibInfo(CurateOutcomeBuildItem curateOutcome, String prefix, String name) {
        List providers = QuarkusClassLoader.getElements((String)prefix, (boolean)false);
        if (!providers.isEmpty()) {
            HashMap<ArtifactKey, ClassPathElement> keys = new HashMap<ArtifactKey, ClassPathElement>(providers.size());
            for (ClassPathElement provider : providers) {
                if (provider.getDependencyKey() == null || !provider.isRuntime()) continue;
                keys.put(provider.getDependencyKey(), provider);
            }
            if (!keys.isEmpty()) {
                HashMap<String, String> map = new HashMap<String, String>(keys.size());
                HashSet<URL> jars = new HashSet<URL>();
                for (ResolvedDependency dep : curateOutcome.getApplicationModel().getDependencies()) {
                    ClassPathElement provider;
                    if (!dep.isRuntimeCp() || (provider = (ClassPathElement)keys.get(dep.getKey())) == null) continue;
                    provider.apply(tree -> {
                        Path nameDir;
                        Path dir = tree.getPath(prefix);
                        try (Stream<Path> dirPaths = Files.list(dir);){
                            nameDir = dirPaths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findFirst().get();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                        if (nameDir == null) {
                            log.warn((Object)("Failed to determine the name for " + name + " included in " + String.valueOf(tree.getOriginalTree().getRoots())));
                            return null;
                        }
                        String version = Files.isDirectory(nameDir.resolve(dep.getVersion()), new LinkOption[0]) ? dep.getVersion() : null;
                        map.put(nameDir.getFileName().toString(), version);
                        try {
                            jars.add(dep.getResolvedPaths().getSinglePath().toUri().toURL());
                        }
                        catch (MalformedURLException ex) {
                            throw new RuntimeException(ex);
                        }
                        return null;
                    });
                }
                return new LibInfo(map, jars);
            }
        }
        return null;
    }

    private String getRootPath(VertxHttpBuildTimeConfig httpBuildTimeConfig, String path) {
        String rootPath = httpBuildTimeConfig.rootPath();
        return rootPath.endsWith(SLASH) ? rootPath + path + SLASH : rootPath + SLASH + path + SLASH;
    }

    static class LibInfo {
        Map<String, String> nameVersionMap;
        Set<URL> jars;

        LibInfo(Map<String, String> nameVersionMap, Set<URL> jars) {
            this.nameVersionMap = nameVersionMap;
            this.jars = jars;
        }
    }
}

