/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.webjar.locator.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.webjar.locator.runtime.WebJarLocatorRecorder;
import java.util.Map;
import org.jboss.logging.Logger;
import org.webjars.WebJarAssetLocator;

public class WebJarLocatorStandaloneBuildStep {
    private static final Logger log = Logger.getLogger((String)WebJarLocatorStandaloneBuildStep.class.getName());

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void findWebjarsAndCreateHandler(HttpBuildTimeConfig httpConfig, BuildProducer<FeatureBuildItem> feature, BuildProducer<RouteBuildItem> routes, WebJarLocatorRecorder recorder) throws Exception {
        WebJarAssetLocator webJarLocator = new WebJarAssetLocator();
        Map webjarNameToVersionMap = webJarLocator.getWebJars();
        if (!webjarNameToVersionMap.isEmpty()) {
            String rootPath = httpConfig.rootPath;
            String webjarRootPath = rootPath.endsWith("/") ? rootPath + "webjars/" : rootPath + "/webjars/";
            feature.produce((BuildItem)new FeatureBuildItem(Feature.WEBJARS_LOCATOR));
            routes.produce((BuildItem)RouteBuildItem.builder().route(webjarRootPath + "*").handler(recorder.getHandler(webjarRootPath, webjarNameToVersionMap)).build());
        } else {
            log.warn((Object)"No WebJars were found in the project. Requests to the /webjars/ path will always return 404 (Not Found)");
        }
    }
}

