/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.client.deployment;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.undertow.deployment.ServletContextAttributeBuildItem;
import io.quarkus.websockets.client.deployment.AnnotatedWebsocketEndpointBuildItem;
import io.quarkus.websockets.client.deployment.ServerWebSocketContainerBuildItem;
import io.quarkus.websockets.client.deployment.ServerWebSocketContainerFactoryBuildItem;
import io.quarkus.websockets.client.deployment.WebSocketDeploymentInfoBuildItem;
import io.quarkus.websockets.client.deployment.WebsocketConfig;
import io.quarkus.websockets.client.runtime.ServerWebSocketContainerFactory;
import io.quarkus.websockets.client.runtime.WebsocketCoreRecorder;
import io.undertow.websockets.DefaultContainerConfigurator;
import io.undertow.websockets.ServerWebSocketContainer;
import io.undertow.websockets.UndertowContainerProvider;
import io.undertow.websockets.WebSocketDeploymentInfo;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.ContainerProvider;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class WebsocketClientProcessor {
    private static final DotName CLIENT_ENDPOINT = DotName.createSimple((String)ClientEndpoint.class.getName());
    private static final DotName SERVER_APPLICATION_CONFIG = DotName.createSimple((String)ServerApplicationConfig.class.getName());
    private static final DotName ENDPOINT = DotName.createSimple((String)Endpoint.class.getName());

    @BuildStep
    void holdConfig(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.WEBSOCKETS_CLIENT));
    }

    @BuildStep
    void scanForAnnotatedEndpoints(CombinedIndexBuildItem indexBuildItem, BuildProducer<AnnotatedWebsocketEndpointBuildItem> annotatedProducer) {
        IndexView index = indexBuildItem.getIndex();
        Collection clientEndpoints = index.getAnnotations(CLIENT_ENDPOINT);
        for (AnnotationInstance endpoint : clientEndpoints) {
            ClassInfo clazz;
            if (!(endpoint.target() instanceof ClassInfo) || Modifier.isAbstract((clazz = (ClassInfo)endpoint.target()).flags())) continue;
            annotatedProducer.produce((BuildItem)new AnnotatedWebsocketEndpointBuildItem(clazz.name().toString(), true));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public ServerWebSocketContainerBuildItem deploy(CombinedIndexBuildItem indexBuildItem, WebsocketCoreRecorder recorder, BuildProducer<ReflectiveClassBuildItem> reflection, List<AnnotatedWebsocketEndpointBuildItem> annotatedEndpoints, BeanContainerBuildItem beanContainerBuildItem, WebsocketConfig websocketConfig, BuildProducer<WebSocketDeploymentInfoBuildItem> infoBuildItemBuildProducer, Optional<ServerWebSocketContainerFactoryBuildItem> factoryBuildItem, BuildProducer<ServletContextAttributeBuildItem> servletContextAttributeBuildItemBuildProducer) throws Exception {
        HashSet<String> endpoints = new HashSet<String>();
        HashSet<String> config = new HashSet<String>();
        IndexView index = indexBuildItem.getIndex();
        Collection subclasses = index.getAllKnownImplementors(SERVER_APPLICATION_CONFIG);
        for (Object clazz : subclasses) {
            if (Modifier.isAbstract(clazz.flags())) continue;
            config.add(clazz.name().toString());
        }
        Collection epClasses = index.getAllKnownSubclasses(ENDPOINT);
        for (Object clazz : epClasses) {
            if (Modifier.isAbstract(clazz.flags())) continue;
            endpoints.add(clazz.name().toString());
        }
        if (annotatedEndpoints.isEmpty() && endpoints.isEmpty() && config.isEmpty()) {
            return null;
        }
        HashSet<String> annotated = new HashSet<String>();
        for (AnnotatedWebsocketEndpointBuildItem i : annotatedEndpoints) {
            annotated.add(i.className);
        }
        reflection.produce((BuildItem)new ReflectiveClassBuildItem(true, false, annotated.toArray(new String[annotated.size()])));
        WebsocketClientProcessor.registerCodersForReflection(reflection, index.getAnnotations(CLIENT_ENDPOINT));
        reflection.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{ClientEndpointConfig.Configurator.class.getName()}));
        RuntimeValue deploymentInfo = recorder.createDeploymentInfo(annotated, endpoints, config, websocketConfig.maxFrameSize, websocketConfig.dispatchToWorker);
        infoBuildItemBuildProducer.produce((BuildItem)new WebSocketDeploymentInfoBuildItem((RuntimeValue<WebSocketDeploymentInfo>)deploymentInfo));
        RuntimeValue serverContainer = recorder.createServerContainer(beanContainerBuildItem.getValue(), deploymentInfo, (ServerWebSocketContainerFactory)factoryBuildItem.map(ServerWebSocketContainerFactoryBuildItem::getFactory).orElse(null));
        servletContextAttributeBuildItemBuildProducer.produce((BuildItem)new ServletContextAttributeBuildItem(ServerContainer.class.getName(), (Object)serverContainer));
        return new ServerWebSocketContainerBuildItem((RuntimeValue<ServerWebSocketContainer>)serverContainer);
    }

    public static void registerCodersForReflection(BuildProducer<ReflectiveClassBuildItem> reflection, Collection<AnnotationInstance> endpoints) {
        for (AnnotationInstance endpoint : endpoints) {
            ClassInfo clazz;
            if (!(endpoint.target() instanceof ClassInfo) || Modifier.isAbstract((clazz = (ClassInfo)endpoint.target()).flags())) continue;
            WebsocketClientProcessor.registerForReflection(reflection, endpoint.value("encoders"));
            WebsocketClientProcessor.registerForReflection(reflection, endpoint.value("decoders"));
        }
    }

    static void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflection, AnnotationValue types) {
        if (types != null && types.asClassArray() != null) {
            for (Type type : types.asClassArray()) {
                reflection.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{type.name().toString()}));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ServiceStartBuildItem setupWorker(WebsocketCoreRecorder recorder, ExecutorBuildItem exec) {
        recorder.setupWorker((Executor)exec.getExecutorProxy());
        return new ServiceStartBuildItem("Websockets");
    }

    @BuildStep
    ServiceProviderBuildItem registerContainerProviderService() {
        return new ServiceProviderBuildItem(ContainerProvider.class.getName(), new String[]{UndertowContainerProvider.class.getName()});
    }

    @BuildStep
    ServiceProviderBuildItem registerConfiguratorServiceProvider() {
        return new ServiceProviderBuildItem(ServerEndpointConfig.Configurator.class.getName(), new String[]{DefaultContainerConfigurator.class.getName()});
    }

    @BuildStep
    void beanDefiningAnnotations(BuildProducer<BeanDefiningAnnotationBuildItem> annotations) {
        annotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(ENDPOINT));
        annotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(CLIENT_ENDPOINT));
    }
}

