/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.websockets.deployment;

import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.undertow.websockets.client.deployment.AnnotatedWebsocketEndpointBuildItem;
import io.quarkus.undertow.websockets.client.deployment.ServerWebSocketContainerBuildItem;
import io.quarkus.undertow.websockets.client.deployment.ServerWebSocketContainerFactoryBuildItem;
import io.quarkus.undertow.websockets.client.deployment.WebSocketDeploymentInfoBuildItem;
import io.quarkus.undertow.websockets.client.deployment.WebsocketClientProcessor;
import io.quarkus.undertow.websockets.runtime.WebsocketServerRecorder;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Optional;
import javax.websocket.server.ServerEndpoint;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class ServerWebSocketProcessor {
    private static final DotName SERVER_ENDPOINT = DotName.createSimple((String)ServerEndpoint.class.getName());

    @BuildStep
    void holdConfig(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.WEBSOCKETS));
    }

    @BuildStep
    void scanForAnnotatedEndpoints(CombinedIndexBuildItem indexBuildItem, BuildProducer<AnnotatedWebsocketEndpointBuildItem> annotatedProducer) {
        IndexView index = indexBuildItem.getIndex();
        Collection serverEndpoints = index.getAnnotations(SERVER_ENDPOINT);
        for (AnnotationInstance endpoint : serverEndpoints) {
            ClassInfo clazz;
            if (!(endpoint.target() instanceof ClassInfo) || Modifier.isAbstract((clazz = (ClassInfo)endpoint.target()).flags())) continue;
            annotatedProducer.produce((BuildItem)new AnnotatedWebsocketEndpointBuildItem(clazz.name().toString(), false));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public ServerWebSocketContainerFactoryBuildItem factory(WebsocketServerRecorder recorder) {
        return new ServerWebSocketContainerFactoryBuildItem(recorder.createFactory());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public FilterBuildItem deploy(CombinedIndexBuildItem indexBuildItem, WebsocketServerRecorder recorder, BuildProducer<ReflectiveClassBuildItem> reflection, Optional<WebSocketDeploymentInfoBuildItem> webSocketDeploymentInfoBuildItem, Optional<ServerWebSocketContainerBuildItem> serverWebSocketContainerBuildItem) throws Exception {
        if (webSocketDeploymentInfoBuildItem.isEmpty()) {
            return null;
        }
        IndexView index = indexBuildItem.getIndex();
        WebsocketClientProcessor.registerCodersForReflection(reflection, (Collection)index.getAnnotations(SERVER_ENDPOINT));
        return new FilterBuildItem(recorder.createHandler(webSocketDeploymentInfoBuildItem.get().getInfo(), serverWebSocketContainerBuildItem.get().getContainer()), 100);
    }

    @BuildStep
    void beanDefiningAnnotations(BuildProducer<BeanDefiningAnnotationBuildItem> annotations) {
        annotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(SERVER_ENDPOINT));
    }
}

