/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.deployment;

import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.KotlinDotNames;
import io.quarkus.arc.processor.KotlinUtils;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.websockets.next.WebSocketException;
import io.quarkus.websockets.next.deployment.CallbackArgument;
import io.quarkus.websockets.next.deployment.CallbackArgumentsBuildItem;
import io.quarkus.websockets.next.deployment.WebSocketDotNames;
import io.quarkus.websockets.next.deployment.WebSocketProcessor;
import io.quarkus.websockets.next.runtime.WebSocketConnectionBase;
import io.quarkus.websockets.next.runtime.WebSocketEndpoint;
import io.quarkus.websockets.next.runtime.WebSocketEndpointBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;

public class Callback {
    public final Target target;
    public final String endpointPath;
    public final AnnotationInstance annotation;
    public final BeanInfo bean;
    public final MethodInfo method;
    public final WebSocketEndpoint.ExecutionModel executionModel;
    public final MessageType messageType;
    public final List<CallbackArgument> arguments;

    public Callback(Target target, AnnotationInstance annotation, BeanInfo bean, MethodInfo method, WebSocketEndpoint.ExecutionModel executionModel, CallbackArgumentsBuildItem callbackArguments, TransformedAnnotationsBuildItem transformedAnnotations, String endpointPath, IndexView index) {
        this.target = target;
        this.bean = bean;
        this.method = method;
        this.annotation = annotation;
        this.executionModel = executionModel;
        this.messageType = WebSocketDotNames.ON_BINARY_MESSAGE.equals((Object)annotation.name()) ? MessageType.BINARY : (WebSocketDotNames.ON_TEXT_MESSAGE.equals((Object)annotation.name()) ? MessageType.TEXT : (WebSocketDotNames.ON_PONG_MESSAGE.equals((Object)annotation.name()) ? MessageType.PONG : MessageType.NONE));
        this.endpointPath = endpointPath;
        this.arguments = this.collectArguments(annotation, method, callbackArguments, transformedAnnotations, index);
    }

    public boolean isGlobal() {
        return this.endpointPath == null;
    }

    public boolean isClient() {
        return this.target == Target.CLIENT;
    }

    public boolean isServer() {
        return this.target == Target.SERVER;
    }

    public boolean isOnOpen() {
        return this.annotation.name().equals((Object)WebSocketDotNames.ON_OPEN);
    }

    public boolean isOnClose() {
        return this.annotation.name().equals((Object)WebSocketDotNames.ON_CLOSE);
    }

    public boolean isOnError() {
        return this.annotation.name().equals((Object)WebSocketDotNames.ON_ERROR);
    }

    public Type returnType() {
        return this.method.returnType();
    }

    public Type messageParamType() {
        return this.acceptsMessage() ? this.method.parameterType(0) : null;
    }

    public boolean isReturnTypeVoid() {
        return this.returnType().kind() == Type.Kind.VOID;
    }

    public boolean isReturnTypeUni() {
        return WebSocketDotNames.UNI.equals((Object)this.returnType().name());
    }

    public boolean isReturnTypeMulti() {
        return WebSocketDotNames.MULTI.equals((Object)this.returnType().name());
    }

    public boolean isKotlinSuspendFunction() {
        return KotlinUtils.isKotlinSuspendMethod((MethodInfo)this.method);
    }

    public boolean isKotlinSuspendFunctionReturningUnit() {
        return KotlinUtils.isKotlinSuspendMethod((MethodInfo)this.method) && KotlinUtils.getKotlinSuspendMethodResult((MethodInfo)this.method).name().equals((Object)KotlinDotNames.UNIT);
    }

    public boolean acceptsMessage() {
        return this.messageType != MessageType.NONE;
    }

    public boolean acceptsBinaryMessage() {
        return this.messageType == MessageType.BINARY || this.messageType == MessageType.PONG;
    }

    public boolean acceptsMulti() {
        return this.acceptsMessage() && this.method.parameterType(0).name().equals((Object)WebSocketDotNames.MULTI);
    }

    public MessageType messageType() {
        return this.messageType;
    }

    public boolean broadcast() {
        AnnotationValue broadcastValue = this.annotation.value("broadcast");
        return broadcastValue != null && broadcastValue.asBoolean();
    }

    public DotName getInputCodec() {
        return this.getCodec("codec");
    }

    public DotName getOutputCodec() {
        DotName output = this.getCodec("outputCodec");
        return output != null ? output : this.getInputCodec();
    }

    public String asString() {
        return this.method.declaringClass().name() + "#" + this.method.name() + "()";
    }

    private DotName getCodec(String valueName) {
        AnnotationValue codecValue = this.annotation.value(valueName);
        if (codecValue != null) {
            return codecValue.asClass().name();
        }
        return null;
    }

    public ResultHandle[] generateArguments(ResultHandle endpointThis, BytecodeCreator bytecode, TransformedAnnotationsBuildItem transformedAnnotations, IndexView index) {
        if (this.arguments.isEmpty()) {
            return new ResultHandle[0];
        }
        ResultHandle[] resultHandles = new ResultHandle[this.arguments.size()];
        int idx = 0;
        for (CallbackArgument argument : this.arguments) {
            resultHandles[idx] = argument.get(this.invocationBytecodeContext(this.annotation, (MethodParameterInfo)this.method.parameters().get(idx), transformedAnnotations, index, endpointThis, bytecode));
            ++idx;
        }
        return resultHandles;
    }

    private List<CallbackArgument> collectArguments(AnnotationInstance annotation, MethodInfo method, CallbackArgumentsBuildItem callbackArguments, TransformedAnnotationsBuildItem transformedAnnotations, IndexView index) {
        List parameters = method.parameters();
        if (parameters.isEmpty()) {
            return List.of();
        }
        ArrayList<CallbackArgument> arguments = new ArrayList<CallbackArgument>(parameters.size());
        for (MethodParameterInfo parameter : parameters) {
            List<CallbackArgument> found = callbackArguments.findMatching(this.parameterContext(annotation, parameter, transformedAnnotations, index));
            if (found.isEmpty()) {
                String msg = String.format("Unable to inject @%s callback parameter '%s' declared on %s: no injector found", DotNames.simpleName((DotName)annotation.name()), parameter.name() != null ? parameter.name() : "#" + parameter.position(), this.asString());
                throw new WebSocketException(msg);
            }
            if (found.size() > 1 && found.get(0).priotity() == found.get(1).priotity()) {
                String msg = String.format("Unable to inject @%s callback parameter '%s' declared on %s: ambiguous injectors found: %s", DotNames.simpleName((DotName)annotation.name()), parameter.name() != null ? parameter.name() : "#" + parameter.position(), this.asString(), found.stream().map(p -> p.getClass().getSimpleName() + ":" + p.priotity()));
                throw new WebSocketException(msg);
            }
            arguments.add(found.get(0));
        }
        return List.copyOf(arguments);
    }

    Type argumentType(Predicate<CallbackArgument> filter) {
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (!filter.test(this.arguments.get(i))) continue;
            return this.method.parameterType(i);
        }
        return null;
    }

    private CallbackArgument.ParameterContext parameterContext(final AnnotationInstance callbackAnnotation, final MethodParameterInfo parameter, final TransformedAnnotationsBuildItem transformedAnnotations, final IndexView index) {
        return new CallbackArgument.ParameterContext(){

            @Override
            public Target callbackTarget() {
                return Callback.this.target;
            }

            @Override
            public MethodParameterInfo parameter() {
                return parameter;
            }

            @Override
            public Set<AnnotationInstance> parameterAnnotations() {
                return Annotations.getParameterAnnotations(arg_0 -> ((TransformedAnnotationsBuildItem)transformedAnnotations).getAnnotations(arg_0), (MethodInfo)parameter.method(), (int)parameter.position());
            }

            @Override
            public AnnotationInstance callbackAnnotation() {
                return callbackAnnotation;
            }

            @Override
            public String endpointPath() {
                return Callback.this.endpointPath;
            }

            @Override
            public IndexView index() {
                return index;
            }
        };
    }

    private CallbackArgument.InvocationBytecodeContext invocationBytecodeContext(final AnnotationInstance callbackAnnotation, final MethodParameterInfo parameter, final TransformedAnnotationsBuildItem transformedAnnotations, final IndexView index, final ResultHandle endpointThis, final BytecodeCreator bytecode) {
        return new CallbackArgument.InvocationBytecodeContext(){

            @Override
            public Target callbackTarget() {
                return Callback.this.target;
            }

            @Override
            public AnnotationInstance callbackAnnotation() {
                return callbackAnnotation;
            }

            @Override
            public MethodParameterInfo parameter() {
                return parameter;
            }

            @Override
            public Set<AnnotationInstance> parameterAnnotations() {
                return Annotations.getParameterAnnotations(arg_0 -> ((TransformedAnnotationsBuildItem)transformedAnnotations).getAnnotations(arg_0), (MethodInfo)parameter.method(), (int)parameter.position());
            }

            @Override
            public String endpointPath() {
                return Callback.this.endpointPath;
            }

            @Override
            public IndexView index() {
                return index;
            }

            @Override
            public BytecodeCreator bytecode() {
                return bytecode;
            }

            @Override
            public ResultHandle getPayload() {
                return this.acceptsMessage() || callbackAnnotation.name().equals((Object)WebSocketDotNames.ON_ERROR) ? bytecode.getMethodParam(0) : null;
            }

            @Override
            public ResultHandle getDecodedMessage(Type parameterType) {
                return this.acceptsMessage() ? WebSocketProcessor.decodeMessage(endpointThis, bytecode, Callback.this.acceptsBinaryMessage(), parameterType, this.getPayload(), Callback.this) : null;
            }

            @Override
            public ResultHandle getConnection() {
                return bytecode.readInstanceField(FieldDescriptor.of(WebSocketEndpointBase.class, (String)"connection", WebSocketConnectionBase.class), endpointThis);
            }
        };
    }

    public static enum Target {
        CLIENT,
        SERVER,
        UNDEFINED;

    }

    public static enum MessageType {
        NONE,
        PONG,
        TEXT,
        BINARY;

    }
}

