/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.deployment;

import io.quarkus.gizmo2.Expr;
import io.quarkus.websockets.next.deployment.CallbackArgument;
import io.quarkus.websockets.next.deployment.WebSocketDotNames;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class ErrorCallbackArgument
implements CallbackArgument {
    ErrorCallbackArgument() {
    }

    @Override
    public boolean matches(CallbackArgument.ParameterContext context) {
        return context.callbackAnnotation().name().equals((Object)WebSocketDotNames.ON_ERROR) && this.isThrowable(context.index(), context.parameter().type().name());
    }

    @Override
    public Expr get(CallbackArgument.InvocationBytecodeContext context) {
        return context.getPayload();
    }

    boolean isThrowable(IndexView index, DotName clazzName) {
        if (clazzName.equals((Object)WebSocketDotNames.THROWABLE)) {
            return true;
        }
        ClassInfo clazz = index.getClassByName(clazzName);
        if (clazz == null) {
            throw new IllegalArgumentException("The class " + String.valueOf(clazzName) + " not found in the index");
        }
        if (clazz.superName().equals((Object)DotName.OBJECT_NAME) || clazz.superName().equals((Object)DotName.RECORD_NAME) || clazz.superName().equals((Object)DotName.ENUM_NAME)) {
            return false;
        }
        if (clazz.superName().equals((Object)WebSocketDotNames.THROWABLE)) {
            return true;
        }
        return this.isThrowable(index, clazz.superName());
    }

    public static boolean isError(CallbackArgument callbackArgument) {
        return callbackArgument instanceof ErrorCallbackArgument;
    }
}

