/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.deployment;

import io.quarkus.arc.processor.Annotations;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.websockets.next.WebSocketConnection;
import io.quarkus.websockets.next.WebSocketServerException;
import io.quarkus.websockets.next.deployment.CallbackArgument;
import io.quarkus.websockets.next.deployment.WebSocketDotNames;
import io.quarkus.websockets.next.deployment.WebSocketServerProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

class PathParamCallbackArgument
implements CallbackArgument {
    PathParamCallbackArgument() {
    }

    @Override
    public boolean matches(CallbackArgument.ParameterContext context) {
        String name = this.getParamName(context);
        if (name != null) {
            if (!context.parameter().type().name().equals((Object)WebSocketDotNames.STRING)) {
                throw new WebSocketServerException("Method parameter annotated with @PathParam must be java.lang.String: " + WebSocketServerProcessor.callbackToString(context.parameter().method()));
            }
            if (context.endpointPath() == null) {
                throw new WebSocketServerException("Global error handlers may not accept @PathParam parameters: " + WebSocketServerProcessor.callbackToString(context.parameter().method()));
            }
            List<String> pathParams = PathParamCallbackArgument.getPathParamNames(context.endpointPath());
            if (!pathParams.contains(name)) {
                throw new WebSocketServerException(String.format("@PathParam name [%s] must be used in the endpoint path [%s]: %s", name, context.endpointPath(), WebSocketServerProcessor.callbackToString(context.parameter().method())));
            }
            return true;
        }
        return false;
    }

    @Override
    public ResultHandle get(CallbackArgument.InvocationBytecodeContext context) {
        ResultHandle connection = context.getConnection();
        String paramName = this.getParamName(context);
        return context.bytecode().invokeInterfaceMethod(MethodDescriptor.ofMethod(WebSocketConnection.class, (String)"pathParam", String.class, (Class[])new Class[]{String.class}), connection, new ResultHandle[]{context.bytecode().load(paramName)});
    }

    private String getParamName(CallbackArgument.ParameterContext context) {
        AnnotationInstance pathParamAnnotation = Annotations.find(context.parameterAnnotations(), (DotName)WebSocketDotNames.PATH_PARAM);
        if (pathParamAnnotation != null) {
            AnnotationValue nameVal = pathParamAnnotation.value();
            String name = nameVal != null ? nameVal.asString() : context.parameter().name();
            if (name == null) {
                throw new WebSocketServerException(String.format("Unable to extract the path parameter name - method parameter names not recorded for %s: compile the class with -parameters", context.parameter().method().declaringClass().name()));
            }
            return name;
        }
        return null;
    }

    static List<String> getPathParamNames(String path) {
        ArrayList<String> names = new ArrayList<String>();
        Matcher m = WebSocketServerProcessor.TRANSLATED_PATH_PARAM_PATTERN.matcher(path);
        while (m.find()) {
            names.add(m.group().substring(1));
        }
        return names;
    }
}

