/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.ContextRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.CustomScopeBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.ContextConfigurator;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Types;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.quarkus.websockets.next.TextMessageCodec;
import io.quarkus.websockets.next.WebSocket;
import io.quarkus.websockets.next.WebSocketConnection;
import io.quarkus.websockets.next.WebSocketServerException;
import io.quarkus.websockets.next.WebSocketsRuntimeConfig;
import io.quarkus.websockets.next.deployment.CallbackArgument;
import io.quarkus.websockets.next.deployment.CallbackArgumentBuildItem;
import io.quarkus.websockets.next.deployment.CallbackArgumentsBuildItem;
import io.quarkus.websockets.next.deployment.ConnectionCallbackArgument;
import io.quarkus.websockets.next.deployment.ErrorCallbackArgument;
import io.quarkus.websockets.next.deployment.GeneratedEndpointBuildItem;
import io.quarkus.websockets.next.deployment.GlobalErrorHandlersBuildItem;
import io.quarkus.websockets.next.deployment.HandshakeRequestCallbackArgument;
import io.quarkus.websockets.next.deployment.MessageCallbackArgument;
import io.quarkus.websockets.next.deployment.PathParamCallbackArgument;
import io.quarkus.websockets.next.deployment.WebSocketDotNames;
import io.quarkus.websockets.next.deployment.WebSocketEndpointBuildItem;
import io.quarkus.websockets.next.runtime.Codecs;
import io.quarkus.websockets.next.runtime.ConnectionManager;
import io.quarkus.websockets.next.runtime.ContextSupport;
import io.quarkus.websockets.next.runtime.JsonTextMessageCodec;
import io.quarkus.websockets.next.runtime.WebSocketEndpoint;
import io.quarkus.websockets.next.runtime.WebSocketEndpointBase;
import io.quarkus.websockets.next.runtime.WebSocketServerRecorder;
import io.quarkus.websockets.next.runtime.WebSocketSessionContext;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniCreate;
import io.smallrye.mutiny.groups.UniOnFailure;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.SessionScoped;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;

public class WebSocketServerProcessor {
    static final String ENDPOINT_SUFFIX = "_WebSocketEndpoint";
    static final String NESTED_SEPARATOR = "$_";
    private static final Pattern PATH_PARAM_PATTERN = Pattern.compile("\\{[a-zA-Z0-9_]+\\}");
    public static final Pattern TRANSLATED_PATH_PARAM_PATTERN = Pattern.compile(":[a-zA-Z0-9_]+");

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("websockets-next");
    }

    @BuildStep
    BeanDefiningAnnotationBuildItem beanDefiningAnnotation() {
        return new BeanDefiningAnnotationBuildItem(WebSocketDotNames.WEB_SOCKET, DotNames.SINGLETON);
    }

    @BuildStep
    AutoAddScopeBuildItem addScopeToGlobalErrorHandlers() {
        return AutoAddScopeBuildItem.builder().containsAnnotations(new DotName[]{WebSocketDotNames.ON_ERROR}).unremovable().reason("Add @Singleton to a global WebSocket error handler").defaultScope(BuiltinScope.SINGLETON).build();
    }

    @BuildStep
    void unremovableBeans(BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{TextMessageCodec.class}));
    }

    @BuildStep
    public void collectEndpoints(BeanArchiveIndexBuildItem beanArchiveIndex, BeanDiscoveryFinishedBuildItem beanDiscoveryFinished, CallbackArgumentsBuildItem callbackArguments, TransformedAnnotationsBuildItem transformedAnnotations, BuildProducer<WebSocketEndpointBuildItem> endpoints, BuildProducer<GlobalErrorHandlersBuildItem> globalErrorHandlers) {
        IndexView index = beanArchiveIndex.getIndex();
        HashMap<DotName, GlobalErrorHandler> globalErrors = new HashMap<DotName, GlobalErrorHandler>();
        for (BeanInfo bean : beanDiscoveryFinished.beanStream().classBeans()) {
            ClassInfo beanClass = ((AnnotationTarget)bean.getTarget().get()).asClass();
            if (beanClass.annotation(WebSocketDotNames.WEB_SOCKET) != null) continue;
            for (WebSocketEndpointBuildItem.Callback callback : this.findErrorHandlers(index, beanClass, callbackArguments, transformedAnnotations, null)) {
                GlobalErrorHandler errorHandler = new GlobalErrorHandler(bean, callback);
                DotName errorTypeName = callback.argumentType(ErrorCallbackArgument::isError).name();
                if (globalErrors.containsKey(errorTypeName)) {
                    throw new WebSocketServerException(String.format("Multiple global @OnError callbacks may not accept the same error parameter: %s\n\t- %s\n\t- %s", errorTypeName, WebSocketServerProcessor.callbackToString(callback.method), WebSocketServerProcessor.callbackToString(((GlobalErrorHandler)globalErrors.get((Object)errorTypeName)).callback.method)));
                }
                globalErrors.put(errorTypeName, errorHandler);
            }
        }
        globalErrorHandlers.produce((BuildItem)new GlobalErrorHandlersBuildItem(List.copyOf(globalErrors.values())));
        HashMap<String, DotName> pathToEndpoint = new HashMap<String, DotName>();
        for (BeanInfo bean : beanDiscoveryFinished.beanStream().classBeans()) {
            DotName previous;
            ClassInfo beanClass = ((AnnotationTarget)bean.getTarget().get()).asClass();
            AnnotationInstance webSocketAnnotation = beanClass.annotation(WebSocketDotNames.WEB_SOCKET);
            if (webSocketAnnotation == null) continue;
            String path = WebSocketServerProcessor.getPath(webSocketAnnotation.value("path").asString());
            if (beanClass.nestingType() == ClassInfo.NestingType.INNER) {
                path = WebSocketServerProcessor.mergePath(this.getPathPrefix(index, beanClass.enclosingClass()), path);
            }
            if ((previous = pathToEndpoint.put(path, beanClass.name())) != null) {
                throw new WebSocketServerException(String.format("Multiple endpoints [%s, %s] define the same path: %s", previous, beanClass, path));
            }
            WebSocketEndpointBuildItem.Callback onOpen = this.findCallback(beanArchiveIndex.getIndex(), beanClass, WebSocketDotNames.ON_OPEN, callbackArguments, transformedAnnotations, path);
            WebSocketEndpointBuildItem.Callback onTextMessage = this.findCallback(beanArchiveIndex.getIndex(), beanClass, WebSocketDotNames.ON_TEXT_MESSAGE, callbackArguments, transformedAnnotations, path);
            WebSocketEndpointBuildItem.Callback onBinaryMessage = this.findCallback(beanArchiveIndex.getIndex(), beanClass, WebSocketDotNames.ON_BINARY_MESSAGE, callbackArguments, transformedAnnotations, path);
            WebSocketEndpointBuildItem.Callback onPongMessage = this.findCallback(beanArchiveIndex.getIndex(), beanClass, WebSocketDotNames.ON_PONG_MESSAGE, callbackArguments, transformedAnnotations, path, this::validateOnPongMessage);
            WebSocketEndpointBuildItem.Callback onClose = this.findCallback(beanArchiveIndex.getIndex(), beanClass, WebSocketDotNames.ON_CLOSE, callbackArguments, transformedAnnotations, path, this::validateOnClose);
            if (onOpen == null && onTextMessage == null && onBinaryMessage == null && onPongMessage == null) {
                throw new WebSocketServerException("The endpoint must declare at least one method annotated with @OnTextMessage, @OnBinaryMessage, @OnPongMessage or @OnOpen: " + beanClass);
            }
            AnnotationValue executionMode = webSocketAnnotation.value("executionMode");
            endpoints.produce((BuildItem)new WebSocketEndpointBuildItem(bean, path, executionMode != null ? WebSocket.ExecutionMode.valueOf((String)executionMode.asEnum()) : WebSocket.ExecutionMode.SERIAL, onOpen, onTextMessage, onBinaryMessage, onPongMessage, onClose, this.findErrorHandlers(index, beanClass, callbackArguments, transformedAnnotations, path)));
        }
    }

    @BuildStep
    CallbackArgumentsBuildItem collectCallbackArguments(List<CallbackArgumentBuildItem> callbackArguments) {
        ArrayList<CallbackArgument> sorted = new ArrayList<CallbackArgument>();
        for (CallbackArgumentBuildItem callbackArgument : callbackArguments) {
            sorted.add(callbackArgument.getProvider());
        }
        sorted.sort(Comparator.comparingInt(CallbackArgument::priotity).reversed());
        return new CallbackArgumentsBuildItem(sorted);
    }

    @BuildStep
    public void generateEndpoints(BeanArchiveIndexBuildItem index, List<WebSocketEndpointBuildItem> endpoints, CallbackArgumentsBuildItem argumentProviders, TransformedAnnotationsBuildItem transformedAnnotations, GlobalErrorHandlersBuildItem globalErrorHandlers, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<GeneratedEndpointBuildItem> generatedEndpoints, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, (Function)new Function<String, String>(){

            @Override
            public String apply(String name) {
                int idx = name.indexOf(WebSocketServerProcessor.ENDPOINT_SUFFIX);
                if (idx != -1) {
                    name = name.substring(0, idx);
                }
                if (name.contains(WebSocketServerProcessor.NESTED_SEPARATOR)) {
                    name = name.replace(WebSocketServerProcessor.NESTED_SEPARATOR, "$");
                }
                return name;
            }
        });
        for (WebSocketEndpointBuildItem endpoint : endpoints) {
            String generatedName = this.generateEndpoint(endpoint, argumentProviders, transformedAnnotations, index.getIndex(), (ClassOutput)classOutput, globalErrorHandlers);
            reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{generatedName}).constructors().build());
            generatedEndpoints.produce((BuildItem)new GeneratedEndpointBuildItem(generatedName, endpoint.path));
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    public void registerRoutes(WebSocketServerRecorder recorder, HttpRootPathBuildItem httpRootPath, List<GeneratedEndpointBuildItem> generatedEndpoints, BuildProducer<RouteBuildItem> routes) {
        for (GeneratedEndpointBuildItem endpoint : generatedEndpoints) {
            RouteBuildItem.Builder builder = RouteBuildItem.builder().route(httpRootPath.relativePath(endpoint.path)).handlerType(HandlerType.NORMAL).handler(recorder.createEndpointHandler(endpoint.className));
            routes.produce((BuildItem)builder.build());
        }
    }

    @BuildStep
    AdditionalBeanBuildItem additionalBeans() {
        return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{Codecs.class, JsonTextMessageCodec.class, ConnectionManager.class}).build();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void syntheticBeans(WebSocketServerRecorder recorder, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(WebSocketConnection.class).scope(SessionScoped.class)).setRuntimeInit().supplier(recorder.connectionSupplier()).unremovable()).done());
    }

    @BuildStep
    ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem registerSessionContext(ContextRegistrationPhaseBuildItem phase) {
        return new ContextRegistrationPhaseBuildItem.ContextConfiguratorBuildItem(new ContextConfigurator[]{phase.getContext().configure(SessionScoped.class).normal().contextClass(WebSocketSessionContext.class)});
    }

    @BuildStep
    CustomScopeBuildItem registerSessionScope() {
        return new CustomScopeBuildItem(DotName.createSimple((String)SessionScoped.class.getName()));
    }

    @BuildStep
    void builtinCallbackArguments(BuildProducer<CallbackArgumentBuildItem> providers) {
        providers.produce((BuildItem)new CallbackArgumentBuildItem(new MessageCallbackArgument()));
        providers.produce((BuildItem)new CallbackArgumentBuildItem(new ConnectionCallbackArgument()));
        providers.produce((BuildItem)new CallbackArgumentBuildItem(new PathParamCallbackArgument()));
        providers.produce((BuildItem)new CallbackArgumentBuildItem(new HandshakeRequestCallbackArgument()));
        providers.produce((BuildItem)new CallbackArgumentBuildItem(new ErrorCallbackArgument()));
    }

    static String mergePath(String prefix, String path) {
        if (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return prefix + (String)path;
    }

    static String getPath(String path) {
        StringBuilder sb = new StringBuilder();
        Matcher m = PATH_PARAM_PATTERN.matcher(path);
        while (m.find()) {
            String match = m.group();
            m.appendReplacement(sb, ":" + match.subSequence(1, match.length() - 1));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    static String callbackToString(MethodInfo callback) {
        return callback.declaringClass().name() + "#" + callback.name() + "()";
    }

    private String getPathPrefix(IndexView index, DotName enclosingClassName) {
        ClassInfo enclosingClass = index.getClassByName(enclosingClassName);
        if (enclosingClass == null) {
            throw new WebSocketServerException("Enclosing class not found in index: " + enclosingClass);
        }
        AnnotationInstance webSocketAnnotation = enclosingClass.annotation(WebSocketDotNames.WEB_SOCKET);
        if (webSocketAnnotation != null) {
            String path = WebSocketServerProcessor.getPath(webSocketAnnotation.value("path").asString());
            if (enclosingClass.nestingType() == ClassInfo.NestingType.INNER) {
                return WebSocketServerProcessor.mergePath(this.getPathPrefix(index, enclosingClass.enclosingClass()), path);
            }
            return path.endsWith("/") ? path.substring(path.length() - 1) : path;
        }
        return "";
    }

    private void validateOnPongMessage(WebSocketEndpointBuildItem.Callback callback) {
        if (callback.returnType().kind() != Type.Kind.VOID && !WebSocketServerProcessor.isUniVoid(callback.returnType())) {
            throw new WebSocketServerException("@OnPongMessage callback must return void or Uni<Void>: " + WebSocketServerProcessor.callbackToString(callback.method));
        }
        org.jboss.jandex.Type messageType = callback.argumentType(MessageCallbackArgument::isMessage);
        if (!messageType.name().equals((Object)WebSocketDotNames.BUFFER)) {
            throw new WebSocketServerException("@OnPongMessage callback must accept exactly one message parameter of type io.vertx.core.buffer.Buffer: " + WebSocketServerProcessor.callbackToString(callback.method));
        }
    }

    private void validateOnClose(WebSocketEndpointBuildItem.Callback callback) {
        if (callback.returnType().kind() != Type.Kind.VOID && !WebSocketServerProcessor.isUniVoid(callback.returnType())) {
            throw new WebSocketServerException("@OnClose callback must return void or Uni<Void>: " + WebSocketServerProcessor.callbackToString(callback.method));
        }
    }

    private String generateEndpoint(WebSocketEndpointBuildItem endpoint, CallbackArgumentsBuildItem argumentProviders, TransformedAnnotationsBuildItem transformedAnnotations, IndexView index, ClassOutput classOutput, GlobalErrorHandlersBuildItem globalErrorHandlers) {
        ResultHandle ret;
        ResultHandle[] args;
        TryBlock tryBlock;
        ResultHandle beanInstance;
        WebSocketEndpointBuildItem.Callback callback;
        ClassInfo implClazz = endpoint.bean.getImplClazz();
        Object baseName = implClazz.enclosingClass() != null ? DotNames.simpleName((DotName)implClazz.enclosingClass()) + NESTED_SEPARATOR + DotNames.simpleName((ClassInfo)implClazz) : DotNames.simpleName((DotName)implClazz.name());
        String generatedName = DotNames.internalPackageNameWithTrailingSlash((DotName)implClazz.name()) + (String)baseName + ENDPOINT_SUFFIX;
        ClassCreator endpointCreator = ClassCreator.builder().classOutput(classOutput).className(generatedName).superClass(WebSocketEndpointBase.class).build();
        MethodCreator constructor = endpointCreator.getConstructorCreator(new Class[]{WebSocketConnection.class, Codecs.class, WebSocketsRuntimeConfig.class, ContextSupport.class});
        constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(WebSocketEndpointBase.class, (Class[])new Class[]{WebSocketConnection.class, Codecs.class, WebSocketsRuntimeConfig.class, ContextSupport.class}), constructor.getThis(), new ResultHandle[]{constructor.getMethodParam(0), constructor.getMethodParam(1), constructor.getMethodParam(2), constructor.getMethodParam(3)});
        constructor.returnNull();
        MethodCreator executionMode = endpointCreator.getMethodCreator("executionMode", WebSocket.ExecutionMode.class, new Class[0]);
        executionMode.returnValue(executionMode.load((Enum)endpoint.executionMode));
        if (endpoint.onOpen != null) {
            callback = endpoint.onOpen;
            MethodCreator doOnOpen = endpointCreator.getMethodCreator("doOnOpen", Uni.class, new Class[]{Object.class});
            beanInstance = doOnOpen.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"beanInstance", Object.class, (Class[])new Class[]{String.class}), doOnOpen.getThis(), new ResultHandle[]{doOnOpen.load(endpoint.bean.getIdentifier())});
            tryBlock = this.onErrorTryBlock((BytecodeCreator)doOnOpen);
            args = callback.generateArguments(tryBlock.getThis(), (BytecodeCreator)tryBlock, transformedAnnotations, index);
            ret = tryBlock.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)callback.method), beanInstance, args);
            this.encodeAndReturnResult(tryBlock.getThis(), (BytecodeCreator)tryBlock, callback, globalErrorHandlers, endpoint, ret);
            MethodCreator onOpenExecutionModel = endpointCreator.getMethodCreator("onOpenExecutionModel", WebSocketEndpoint.ExecutionModel.class, new Class[0]);
            onOpenExecutionModel.returnValue(onOpenExecutionModel.load((Enum)callback.executionModel));
        }
        this.generateOnMessage(endpointCreator, endpoint, endpoint.onBinaryMessage, argumentProviders, transformedAnnotations, index, globalErrorHandlers);
        this.generateOnMessage(endpointCreator, endpoint, endpoint.onTextMessage, argumentProviders, transformedAnnotations, index, globalErrorHandlers);
        this.generateOnMessage(endpointCreator, endpoint, endpoint.onPongMessage, argumentProviders, transformedAnnotations, index, globalErrorHandlers);
        if (endpoint.onClose != null) {
            callback = endpoint.onClose;
            MethodCreator doOnClose = endpointCreator.getMethodCreator("doOnClose", Uni.class, new Class[]{Object.class});
            beanInstance = doOnClose.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"beanInstance", Object.class, (Class[])new Class[]{String.class}), doOnClose.getThis(), new ResultHandle[]{doOnClose.load(endpoint.bean.getIdentifier())});
            tryBlock = this.onErrorTryBlock((BytecodeCreator)doOnClose);
            args = callback.generateArguments(tryBlock.getThis(), (BytecodeCreator)tryBlock, transformedAnnotations, index);
            ret = tryBlock.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)callback.method), beanInstance, args);
            this.encodeAndReturnResult(tryBlock.getThis(), (BytecodeCreator)tryBlock, callback, globalErrorHandlers, endpoint, ret);
            MethodCreator onCloseExecutionModel = endpointCreator.getMethodCreator("onCloseExecutionModel", WebSocketEndpoint.ExecutionModel.class, new Class[0]);
            onCloseExecutionModel.returnValue(onCloseExecutionModel.load((Enum)callback.executionModel));
        }
        this.generateOnError(endpointCreator, endpoint, argumentProviders, transformedAnnotations, globalErrorHandlers, index);
        endpointCreator.close();
        return generatedName.replace('/', '.');
    }

    private void generateOnError(ClassCreator endpointCreator, WebSocketEndpointBuildItem endpoint, CallbackArgumentsBuildItem callbackArguments, TransformedAnnotationsBuildItem transformedAnnotations, GlobalErrorHandlersBuildItem globalErrorHandlers, IndexView index) {
        HashMap<DotName, WebSocketEndpointBuildItem.Callback> errors = new HashMap<DotName, WebSocketEndpointBuildItem.Callback>();
        ArrayList<ThrowableInfo> throwableInfos = new ArrayList<ThrowableInfo>();
        for (WebSocketEndpointBuildItem.Callback callback : endpoint.onErrors) {
            DotName errorTypeName = callback.argumentType(ErrorCallbackArgument::isError).name();
            if (errors.containsKey(errorTypeName)) {
                throw new WebSocketServerException(String.format("Multiple @OnError callbacks may not accept the same error parameter: %s\n\t- %s\n\t- %s", errorTypeName, WebSocketServerProcessor.callbackToString(callback.method), WebSocketServerProcessor.callbackToString(((WebSocketEndpointBuildItem.Callback)errors.get((Object)errorTypeName)).method)));
            }
            errors.put(errorTypeName, callback);
            throwableInfos.add(new ThrowableInfo(endpoint.bean, callback, this.throwableHierarchy(errorTypeName, index)));
        }
        for (GlobalErrorHandler globalErrorHandler : globalErrorHandlers.handlers) {
            WebSocketEndpointBuildItem.Callback callback = globalErrorHandler.callback;
            DotName errorTypeName = callback.argumentType(ErrorCallbackArgument::isError).name();
            if (errors.containsKey(errorTypeName)) continue;
            throwableInfos.add(new ThrowableInfo(globalErrorHandler.bean, callback, this.throwableHierarchy(errorTypeName, index)));
        }
        if (throwableInfos.isEmpty()) {
            return;
        }
        MethodCreator doOnError = endpointCreator.getMethodCreator("doOnError", Uni.class, new Class[]{Throwable.class});
        throwableInfos.sort(Comparator.comparingInt(ThrowableInfo::level).reversed());
        ResultHandle endpointThis = doOnError.getThis();
        for (ThrowableInfo throwableInfo : throwableInfos) {
            BytecodeCreator throwableMatches = doOnError.ifTrue(doOnError.instanceOf(doOnError.getMethodParam(0), throwableInfo.hierarchy.get(0).toString())).trueBranch();
            WebSocketEndpointBuildItem.Callback callback = throwableInfo.callback;
            FunctionCreator fun = throwableMatches.createFunction(Function.class);
            BytecodeCreator funBytecode = fun.getBytecode();
            TryBlock tryBlock = this.uniFailureTryBlock(funBytecode);
            ResultHandle beanInstance = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"beanInstance", Object.class, (Class[])new Class[]{String.class}), endpointThis, new ResultHandle[]{funBytecode.load(throwableInfo.bean().getIdentifier())});
            ResultHandle[] args = callback.generateArguments(endpointThis, (BytecodeCreator)tryBlock, transformedAnnotations, index);
            ResultHandle ret = tryBlock.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)callback.method), beanInstance, args);
            this.encodeAndReturnResult(endpointThis, (BytecodeCreator)tryBlock, callback, globalErrorHandlers, endpoint, ret);
            throwableMatches.returnValue(throwableMatches.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"doErrorExecute", Uni.class, (Class[])new Class[]{Throwable.class, WebSocketEndpoint.ExecutionModel.class, Function.class}), throwableMatches.getThis(), new ResultHandle[]{throwableMatches.getMethodParam(0), throwableMatches.load((Enum)callback.executionModel), fun.getInstance()}));
        }
        ResultHandle uniCreate = doOnError.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Uni.class, (String)"createFrom", UniCreate.class, (Class[])new Class[0]), new ResultHandle[0]);
        doOnError.returnValue(doOnError.invokeVirtualMethod(MethodDescriptor.ofMethod(UniCreate.class, (String)"failure", Uni.class, (Class[])new Class[]{Throwable.class}), uniCreate, new ResultHandle[]{doOnError.getMethodParam(0)}));
    }

    private List<DotName> throwableHierarchy(DotName throwableName, IndexView index) {
        ArrayList<DotName> ret = new ArrayList<DotName>();
        this.addToThrowableHierarchy(throwableName, index, ret);
        return ret;
    }

    private void addToThrowableHierarchy(DotName throwableName, IndexView index, List<DotName> hierarchy) {
        hierarchy.add(throwableName);
        ClassInfo errorClass = index.getClassByName(throwableName);
        if (errorClass == null) {
            throw new IllegalArgumentException("The class " + throwableName + " not found in the index");
        }
        if (errorClass.superName().equals((Object)DotName.OBJECT_NAME)) {
            return;
        }
        this.addToThrowableHierarchy(errorClass.superName(), index, hierarchy);
    }

    private void generateOnMessage(ClassCreator endpointCreator, WebSocketEndpointBuildItem endpoint, WebSocketEndpointBuildItem.Callback callback, CallbackArgumentsBuildItem callbackArguments, TransformedAnnotationsBuildItem transformedAnnotations, IndexView index, GlobalErrorHandlersBuildItem globalErrorHandlers) {
        String messageType;
        if (callback == null) {
            return;
        }
        MethodCreator doOnMessage = endpointCreator.getMethodCreator("doOn" + messageType + "Message", Uni.class, new Class[]{switch (callback.messageType()) {
            case WebSocketEndpointBuildItem.Callback.MessageType.BINARY -> {
                messageType = "Binary";
                yield Object.class;
            }
            case WebSocketEndpointBuildItem.Callback.MessageType.TEXT -> {
                messageType = "Text";
                yield Object.class;
            }
            case WebSocketEndpointBuildItem.Callback.MessageType.PONG -> {
                messageType = "Pong";
                yield Buffer.class;
            }
            default -> throw new IllegalArgumentException();
        }});
        TryBlock tryBlock = this.onErrorTryBlock((BytecodeCreator)doOnMessage);
        ResultHandle beanInstance = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"beanInstance", Object.class, (Class[])new Class[]{String.class}), tryBlock.getThis(), new ResultHandle[]{tryBlock.load(endpoint.bean.getIdentifier())});
        ResultHandle[] args = callback.generateArguments(tryBlock.getThis(), (BytecodeCreator)tryBlock, transformedAnnotations, index);
        ResultHandle ret = tryBlock.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)callback.method), beanInstance, args);
        this.encodeAndReturnResult(tryBlock.getThis(), (BytecodeCreator)tryBlock, callback, globalErrorHandlers, endpoint, ret);
        MethodCreator onMessageExecutionModel = endpointCreator.getMethodCreator("on" + messageType + "MessageExecutionModel", WebSocketEndpoint.ExecutionModel.class, new Class[0]);
        onMessageExecutionModel.returnValue(onMessageExecutionModel.load((Enum)callback.executionModel));
        if (callback.acceptsMulti() && callback.messageType != WebSocketEndpointBuildItem.Callback.MessageType.PONG) {
            org.jboss.jandex.Type multiItemType = (org.jboss.jandex.Type)callback.messageParamType().asParameterizedType().arguments().get(0);
            MethodCreator consumedMultiType = endpointCreator.getMethodCreator("consumed" + messageType + "MultiType", Type.class, new Class[0]);
            consumedMultiType.returnValue(Types.getTypeHandle((BytecodeCreator)consumedMultiType, (org.jboss.jandex.Type)multiItemType));
            MethodCreator decodeMultiItem = endpointCreator.getMethodCreator("decode" + messageType + "MultiItem", Object.class, new Class[]{Object.class});
            decodeMultiItem.returnValue(WebSocketServerProcessor.decodeMessage(decodeMultiItem.getThis(), (BytecodeCreator)decodeMultiItem, callback.acceptsBinaryMessage(), multiItemType, decodeMultiItem.getMethodParam(0), callback));
        }
    }

    private TryBlock uniFailureTryBlock(BytecodeCreator method) {
        TryBlock tryBlock = method.tryBlock();
        CatchBlockCreator catchBlock = tryBlock.addCatch(Throwable.class);
        ResultHandle uniCreate = catchBlock.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Uni.class, (String)"createFrom", UniCreate.class, (Class[])new Class[0]), new ResultHandle[0]);
        catchBlock.returnValue(catchBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(UniCreate.class, (String)"failure", Uni.class, (Class[])new Class[]{Throwable.class}), uniCreate, new ResultHandle[]{catchBlock.getCaughtException()}));
        return tryBlock;
    }

    private TryBlock onErrorTryBlock(BytecodeCreator method) {
        TryBlock tryBlock = method.tryBlock();
        CatchBlockCreator catchBlock = tryBlock.addCatch(Throwable.class);
        catchBlock.returnValue(catchBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"doOnError", Uni.class, (Class[])new Class[]{Throwable.class}), catchBlock.getThis(), new ResultHandle[]{catchBlock.getCaughtException()}));
        return tryBlock;
    }

    static ResultHandle decodeMessage(ResultHandle endpointThis, BytecodeCreator method, boolean binaryMessage, org.jboss.jandex.Type valueType, ResultHandle value, WebSocketEndpointBuildItem.Callback callback) {
        if (WebSocketDotNames.MULTI.equals((Object)valueType.name())) {
            return value;
        }
        if (binaryMessage) {
            if (WebSocketDotNames.BUFFER.equals((Object)valueType.name())) {
                return value;
            }
            if (WebSocketServerProcessor.isByteArray(valueType)) {
                return method.invokeInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"getBytes", byte[].class, (Class[])new Class[0]), value, new ResultHandle[0]);
            }
            if (WebSocketDotNames.STRING.equals((Object)valueType.name())) {
                return method.invokeInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"toString", String.class, (Class[])new Class[0]), value, new ResultHandle[0]);
            }
            if (WebSocketDotNames.JSON_OBJECT.equals((Object)valueType.name())) {
                return method.newInstance(MethodDescriptor.ofConstructor(JsonObject.class, (Class[])new Class[]{Buffer.class}), new ResultHandle[]{value});
            }
            if (WebSocketDotNames.JSON_ARRAY.equals((Object)valueType.name())) {
                return method.newInstance(MethodDescriptor.ofConstructor(JsonArray.class, (Class[])new Class[]{Buffer.class}), new ResultHandle[]{value});
            }
            DotName inputCodec = callback.getInputCodec();
            ResultHandle type = Types.getTypeHandle((BytecodeCreator)method, (org.jboss.jandex.Type)valueType);
            ResultHandle decoded = method.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"decodeBinary", Object.class, (Class[])new Class[]{Type.class, Buffer.class, Class.class}), endpointThis, new ResultHandle[]{type, value, inputCodec != null ? method.loadClass(inputCodec.toString()) : method.loadNull()});
            return decoded;
        }
        if (WebSocketDotNames.STRING.equals((Object)valueType.name())) {
            return value;
        }
        if (WebSocketDotNames.JSON_OBJECT.equals((Object)valueType.name())) {
            return method.newInstance(MethodDescriptor.ofConstructor(JsonObject.class, (Class[])new Class[]{String.class}), new ResultHandle[]{value});
        }
        if (WebSocketDotNames.JSON_ARRAY.equals((Object)valueType.name())) {
            return method.newInstance(MethodDescriptor.ofConstructor(JsonArray.class, (Class[])new Class[]{String.class}), new ResultHandle[]{value});
        }
        if (WebSocketDotNames.BUFFER.equals((Object)valueType.name())) {
            return method.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"buffer", Buffer.class, (Class[])new Class[]{String.class}), new ResultHandle[]{value});
        }
        if (WebSocketServerProcessor.isByteArray(valueType)) {
            ResultHandle buffer = method.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"buffer", Buffer.class, (Class[])new Class[]{byte[].class}), new ResultHandle[]{value});
            return method.invokeInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"getBytes", byte[].class, (Class[])new Class[0]), buffer, new ResultHandle[0]);
        }
        DotName inputCodec = callback.getInputCodec();
        ResultHandle type = Types.getTypeHandle((BytecodeCreator)method, (org.jboss.jandex.Type)valueType);
        ResultHandle decoded = method.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"decodeText", Object.class, (Class[])new Class[]{Type.class, String.class, Class.class}), endpointThis, new ResultHandle[]{type, value, inputCodec != null ? method.loadClass(inputCodec.toString()) : method.loadNull()});
        return decoded;
    }

    private ResultHandle uniOnFailureDoOnError(ResultHandle endpointThis, BytecodeCreator method, WebSocketEndpointBuildItem.Callback callback, ResultHandle uni, WebSocketEndpointBuildItem endpoint, GlobalErrorHandlersBuildItem globalErrorHandlers) {
        if (callback.isOnError() || globalErrorHandlers.handlers.isEmpty() && (endpoint == null || endpoint.onErrors.isEmpty())) {
            return uni;
        }
        FunctionCreator fun = method.createFunction(Function.class);
        BytecodeCreator funBytecode = fun.getBytecode();
        funBytecode.returnValue(funBytecode.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"doOnError", Uni.class, (Class[])new Class[]{Throwable.class}), endpointThis, new ResultHandle[]{funBytecode.getMethodParam(0)}));
        ResultHandle uniOnFailure = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(Uni.class, (String)"onFailure", UniOnFailure.class, (Class[])new Class[0]), uni, new ResultHandle[0]);
        return method.invokeVirtualMethod(MethodDescriptor.ofMethod(UniOnFailure.class, (String)"recoverWithUni", Uni.class, (Class[])new Class[]{Function.class}), uniOnFailure, new ResultHandle[]{fun.getInstance()});
    }

    private ResultHandle encodeMessage(ResultHandle endpointThis, BytecodeCreator method, WebSocketEndpointBuildItem.Callback callback, GlobalErrorHandlersBuildItem globalErrorHandlers, WebSocketEndpointBuildItem endpoint, ResultHandle value) {
        if (callback.acceptsBinaryMessage()) {
            if (callback.isReturnTypeUni()) {
                org.jboss.jandex.Type messageType = (org.jboss.jandex.Type)callback.returnType().asParameterizedType().arguments().get(0);
                if (messageType.name().equals((Object)WebSocketDotNames.VOID)) {
                    return this.uniOnFailureDoOnError(endpointThis, method, callback, value, endpoint, globalErrorHandlers);
                }
                FunctionCreator fun = method.createFunction(Function.class);
                BytecodeCreator funBytecode = fun.getBytecode();
                ResultHandle buffer = this.encodeBuffer(funBytecode, (org.jboss.jandex.Type)callback.returnType().asParameterizedType().arguments().get(0), funBytecode.getMethodParam(0), endpointThis, callback);
                funBytecode.returnValue(funBytecode.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"sendBinary", Uni.class, (Class[])new Class[]{Buffer.class, Boolean.TYPE}), endpointThis, new ResultHandle[]{buffer, funBytecode.load(callback.broadcast())}));
                ResultHandle uniChain = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(Uni.class, (String)"chain", Uni.class, (Class[])new Class[]{Function.class}), value, new ResultHandle[]{fun.getInstance()});
                return this.uniOnFailureDoOnError(endpointThis, method, callback, uniChain, endpoint, globalErrorHandlers);
            }
            if (callback.isReturnTypeMulti()) {
                FunctionCreator fun = method.createFunction(Function.class);
                BytecodeCreator funBytecode = fun.getBytecode();
                ResultHandle buffer = this.encodeBuffer(funBytecode, (org.jboss.jandex.Type)callback.returnType().asParameterizedType().arguments().get(0), funBytecode.getMethodParam(0), endpointThis, callback);
                funBytecode.returnValue(funBytecode.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"sendBinary", Uni.class, (Class[])new Class[]{Buffer.class, Boolean.TYPE}), endpointThis, new ResultHandle[]{buffer, funBytecode.load(callback.broadcast())}));
                return method.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"multiBinary", Uni.class, (Class[])new Class[]{Multi.class, Boolean.TYPE, Function.class}), endpointThis, new ResultHandle[]{value, method.load(callback.broadcast()), fun.getInstance()});
            }
            ResultHandle buffer = this.encodeBuffer(method, callback.returnType(), value, endpointThis, callback);
            return method.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"sendBinary", Uni.class, (Class[])new Class[]{Buffer.class, Boolean.TYPE}), endpointThis, new ResultHandle[]{buffer, method.load(callback.broadcast())});
        }
        if (callback.isReturnTypeUni()) {
            org.jboss.jandex.Type messageType = (org.jboss.jandex.Type)callback.returnType().asParameterizedType().arguments().get(0);
            if (messageType.name().equals((Object)WebSocketDotNames.VOID)) {
                return this.uniOnFailureDoOnError(endpointThis, method, callback, value, endpoint, globalErrorHandlers);
            }
            FunctionCreator fun = method.createFunction(Function.class);
            BytecodeCreator funBytecode = fun.getBytecode();
            ResultHandle text = this.encodeText(funBytecode, (org.jboss.jandex.Type)callback.returnType().asParameterizedType().arguments().get(0), funBytecode.getMethodParam(0), endpointThis, callback);
            funBytecode.returnValue(funBytecode.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"sendText", Uni.class, (Class[])new Class[]{String.class, Boolean.TYPE}), endpointThis, new ResultHandle[]{text, funBytecode.load(callback.broadcast())}));
            ResultHandle uniChain = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(Uni.class, (String)"chain", Uni.class, (Class[])new Class[]{Function.class}), value, new ResultHandle[]{fun.getInstance()});
            return this.uniOnFailureDoOnError(endpointThis, method, callback, uniChain, endpoint, globalErrorHandlers);
        }
        if (callback.isReturnTypeMulti()) {
            FunctionCreator fun = method.createFunction(Function.class);
            BytecodeCreator funBytecode = fun.getBytecode();
            ResultHandle text = this.encodeText(funBytecode, (org.jboss.jandex.Type)callback.returnType().asParameterizedType().arguments().get(0), funBytecode.getMethodParam(0), endpointThis, callback);
            funBytecode.returnValue(funBytecode.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"sendText", Uni.class, (Class[])new Class[]{String.class, Boolean.TYPE}), endpointThis, new ResultHandle[]{text, funBytecode.load(callback.broadcast())}));
            return method.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"multiText", Uni.class, (Class[])new Class[]{Multi.class, Boolean.TYPE, Function.class}), endpointThis, new ResultHandle[]{value, method.load(callback.broadcast()), fun.getInstance()});
        }
        ResultHandle text = this.encodeText(method, callback.returnType(), value, endpointThis, callback);
        return method.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"sendText", Uni.class, (Class[])new Class[]{String.class, Boolean.TYPE}), endpointThis, new ResultHandle[]{text, method.load(callback.broadcast())});
    }

    private ResultHandle encodeBuffer(BytecodeCreator method, org.jboss.jandex.Type messageType, ResultHandle value, ResultHandle endpointThis, WebSocketEndpointBuildItem.Callback callback) {
        ResultHandle buffer;
        if (messageType.name().equals((Object)WebSocketDotNames.BUFFER)) {
            buffer = value;
        } else if (WebSocketServerProcessor.isByteArray(messageType)) {
            buffer = method.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"buffer", Buffer.class, (Class[])new Class[]{byte[].class}), new ResultHandle[]{value});
        } else if (messageType.name().equals((Object)WebSocketDotNames.STRING)) {
            buffer = method.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"buffer", Buffer.class, (Class[])new Class[]{String.class}), new ResultHandle[]{value});
        } else if (messageType.name().equals((Object)WebSocketDotNames.JSON_OBJECT)) {
            buffer = method.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonObject.class, (String)"toBuffer", Buffer.class, (Class[])new Class[0]), value, new ResultHandle[0]);
        } else if (messageType.name().equals((Object)WebSocketDotNames.JSON_ARRAY)) {
            buffer = method.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonArray.class, (String)"toBuffer", Buffer.class, (Class[])new Class[0]), value, new ResultHandle[0]);
        } else {
            DotName outputCodec = callback.getOutputCodec();
            buffer = method.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"encodeBinary", Buffer.class, (Class[])new Class[]{Object.class, Class.class}), endpointThis, new ResultHandle[]{value, outputCodec != null ? method.loadClass(outputCodec.toString()) : method.loadNull()});
        }
        return buffer;
    }

    private ResultHandle encodeText(BytecodeCreator method, org.jboss.jandex.Type messageType, ResultHandle value, ResultHandle endpointThis, WebSocketEndpointBuildItem.Callback callback) {
        ResultHandle text;
        if (messageType.name().equals((Object)WebSocketDotNames.BUFFER)) {
            text = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"toString", String.class, (Class[])new Class[0]), value, new ResultHandle[0]);
        } else if (WebSocketServerProcessor.isByteArray(messageType)) {
            ResultHandle buffer = method.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"buffer", Buffer.class, (Class[])new Class[]{byte[].class}), new ResultHandle[]{value});
            text = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(Buffer.class, (String)"toString", String.class, (Class[])new Class[0]), buffer, new ResultHandle[0]);
        } else if (messageType.name().equals((Object)WebSocketDotNames.STRING)) {
            text = value;
        } else if (messageType.name().equals((Object)WebSocketDotNames.JSON_OBJECT)) {
            text = method.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonObject.class, (String)"encode", String.class, (Class[])new Class[0]), value, new ResultHandle[0]);
        } else if (messageType.name().equals((Object)WebSocketDotNames.JSON_ARRAY)) {
            text = method.invokeVirtualMethod(MethodDescriptor.ofMethod(JsonArray.class, (String)"encode", String.class, (Class[])new Class[0]), value, new ResultHandle[0]);
        } else {
            DotName outputCodec = callback.getOutputCodec();
            text = method.invokeVirtualMethod(MethodDescriptor.ofMethod(WebSocketEndpointBase.class, (String)"encodeText", String.class, (Class[])new Class[]{Object.class, Class.class}), endpointThis, new ResultHandle[]{value, outputCodec != null ? method.loadClass(outputCodec.toString()) : method.loadNull()});
        }
        return text;
    }

    private ResultHandle uniVoid(BytecodeCreator method) {
        ResultHandle uniCreate = method.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(Uni.class, (String)"createFrom", UniCreate.class, (Class[])new Class[0]), new ResultHandle[0]);
        return method.invokeVirtualMethod(MethodDescriptor.ofMethod(UniCreate.class, (String)"voidItem", Uni.class, (Class[])new Class[0]), uniCreate, new ResultHandle[0]);
    }

    private void encodeAndReturnResult(ResultHandle endpointThis, BytecodeCreator method, WebSocketEndpointBuildItem.Callback callback, GlobalErrorHandlersBuildItem globalErrorHandlers, WebSocketEndpointBuildItem endpoint, ResultHandle result) {
        if (callback.isReturnTypeVoid()) {
            method.returnValue(this.uniVoid(method));
        } else {
            BytecodeCreator isNull = method.ifNull(result).trueBranch();
            isNull.returnValue(this.uniVoid(isNull));
            method.returnValue(this.encodeMessage(endpointThis, method, callback, globalErrorHandlers, endpoint, result));
        }
    }

    private List<WebSocketEndpointBuildItem.Callback> findErrorHandlers(IndexView index, ClassInfo beanClass, CallbackArgumentsBuildItem callbackArguments, TransformedAnnotationsBuildItem transformedAnnotations, String endpointPath) {
        List<AnnotationInstance> annotations = this.findCallbackAnnotations(index, beanClass, WebSocketDotNames.ON_ERROR);
        if (annotations.isEmpty()) {
            return List.of();
        }
        ArrayList<WebSocketEndpointBuildItem.Callback> errorHandlers = new ArrayList<WebSocketEndpointBuildItem.Callback>();
        for (AnnotationInstance annotation : annotations) {
            MethodInfo method = annotation.target().asMethod();
            WebSocketEndpointBuildItem.Callback callback = new WebSocketEndpointBuildItem.Callback(annotation, method, this.executionModel(method), callbackArguments, transformedAnnotations, endpointPath, index);
            long errorArguments = callback.arguments.stream().filter(ca -> ca instanceof ErrorCallbackArgument).count();
            if (errorArguments != 1L) {
                throw new WebSocketServerException(String.format("@OnError callback must accept exactly one error parameter; found %s: %s", DotNames.simpleName((DotName)callback.annotation.name()), errorArguments, WebSocketServerProcessor.callbackToString(callback.method)));
            }
            errorHandlers.add(callback);
        }
        return errorHandlers;
    }

    private List<AnnotationInstance> findCallbackAnnotations(IndexView index, ClassInfo beanClass, DotName annotationName) {
        ClassInfo aClass = beanClass;
        ArrayList<AnnotationInstance> annotations = new ArrayList<AnnotationInstance>();
        while (aClass != null) {
            DotName superName;
            List declared = (List)aClass.annotationsMap().get(annotationName);
            if (declared != null) {
                annotations.addAll(declared);
            }
            aClass = (superName = aClass.superName()) != null && !superName.equals((Object)DotNames.OBJECT) ? index.getClassByName(superName) : null;
        }
        return annotations;
    }

    private WebSocketEndpointBuildItem.Callback findCallback(IndexView index, ClassInfo beanClass, DotName annotationName, CallbackArgumentsBuildItem callbackArguments, TransformedAnnotationsBuildItem transformedAnnotations, String endpointPath) {
        return this.findCallback(index, beanClass, annotationName, callbackArguments, transformedAnnotations, endpointPath, null);
    }

    private WebSocketEndpointBuildItem.Callback findCallback(IndexView index, ClassInfo beanClass, DotName annotationName, CallbackArgumentsBuildItem callbackArguments, TransformedAnnotationsBuildItem transformedAnnotations, String endpointPath, Consumer<WebSocketEndpointBuildItem.Callback> validator) {
        List<AnnotationInstance> annotations = this.findCallbackAnnotations(index, beanClass, annotationName);
        if (annotations.isEmpty()) {
            return null;
        }
        if (annotations.size() == 1) {
            AnnotationInstance annotation = annotations.get(0);
            MethodInfo method = annotation.target().asMethod();
            WebSocketEndpointBuildItem.Callback callback = new WebSocketEndpointBuildItem.Callback(annotation, method, this.executionModel(method), callbackArguments, transformedAnnotations, endpointPath, index);
            long messageArguments = callback.arguments.stream().filter(ca -> ca instanceof MessageCallbackArgument).count();
            if (callback.acceptsMessage()) {
                if (messageArguments > 1L) {
                    throw new WebSocketServerException(String.format("@%s callback may accept at most 1 message parameter; found %s: %s", DotNames.simpleName((DotName)callback.annotation.name()), messageArguments, WebSocketServerProcessor.callbackToString(callback.method)));
                }
            } else if (messageArguments != 0L) {
                throw new WebSocketServerException(String.format("@%s callback must not accept a message parameter; found %s: %s", DotNames.simpleName((DotName)callback.annotation.name()), messageArguments, WebSocketServerProcessor.callbackToString(callback.method)));
            }
            if (validator != null) {
                validator.accept(callback);
            }
            return callback;
        }
        throw new WebSocketServerException(String.format("There can be only one callback annotated with %s declared on %s", annotationName, beanClass));
    }

    WebSocketEndpoint.ExecutionModel executionModel(MethodInfo method) {
        if (this.hasBlockingSignature(method)) {
            return method.hasDeclaredAnnotation(WebSocketDotNames.RUN_ON_VIRTUAL_THREAD) ? WebSocketEndpoint.ExecutionModel.VIRTUAL_THREAD : WebSocketEndpoint.ExecutionModel.WORKER_THREAD;
        }
        return method.hasDeclaredAnnotation(WebSocketDotNames.BLOCKING) ? WebSocketEndpoint.ExecutionModel.WORKER_THREAD : WebSocketEndpoint.ExecutionModel.EVENT_LOOP;
    }

    boolean hasBlockingSignature(MethodInfo method) {
        switch (method.returnType().kind()) {
            case VOID: 
            case CLASS: {
                return true;
            }
            case PARAMETERIZED_TYPE: {
                DotName name = method.returnType().asParameterizedType().name();
                return !name.equals((Object)WebSocketDotNames.UNI) && !name.equals((Object)WebSocketDotNames.MULTI);
            }
        }
        throw new WebSocketServerException("Unsupported return type:" + WebSocketServerProcessor.callbackToString(method));
    }

    static boolean isUniVoid(org.jboss.jandex.Type type) {
        return WebSocketDotNames.UNI.equals((Object)type.name()) && ((org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0)).name().equals((Object)WebSocketDotNames.VOID);
    }

    static boolean isByteArray(org.jboss.jandex.Type type) {
        return type.kind() == Type.Kind.ARRAY && PrimitiveType.BYTE.equals((Object)type.asArrayType().constituent());
    }

    record GlobalErrorHandler(BeanInfo bean, WebSocketEndpointBuildItem.Callback callback) {
    }

    record ThrowableInfo(BeanInfo bean, WebSocketEndpointBuildItem.Callback callback, List<DotName> hierarchy) {
        public int level() {
            return this.hierarchy.size();
        }
    }
}

