/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next;

import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;

public class CloseReason {
    public static final CloseReason NORMAL = new CloseReason(WebSocketCloseStatus.NORMAL_CLOSURE.code());
    public static final CloseReason INTERNAL_SERVER_ERROR = new CloseReason(WebSocketCloseStatus.INTERNAL_SERVER_ERROR.code());
    private final int code;
    private final String message;

    public CloseReason(int code) {
        this(code, null);
    }

    public CloseReason(int code, String message) {
        if (!WebSocketCloseStatus.isValidStatusCode((int)code)) {
            throw new IllegalArgumentException("Invalid status code: " + code);
        }
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }
}

