/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.quarkus.websockets.next.WebSocketClientConnection;
import io.quarkus.websockets.next.WebSocketClientException;
import io.quarkus.websockets.next.WebSocketConnector;
import io.quarkus.websockets.next.WebSocketsClientRuntimeConfig;
import io.quarkus.websockets.next.runtime.ClientConnectionManager;
import io.quarkus.websockets.next.runtime.Codecs;
import io.quarkus.websockets.next.runtime.Endpoints;
import io.quarkus.websockets.next.runtime.SecuritySupport;
import io.quarkus.websockets.next.runtime.TrafficLogger;
import io.quarkus.websockets.next.runtime.WebSocketClientConnectionImpl;
import io.quarkus.websockets.next.runtime.WebSocketClientRecorder;
import io.quarkus.websockets.next.runtime.WebSocketConnectorBase;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.http.WebSocketConnectOptions;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;

@Typed(value={WebSocketConnector.class})
@Dependent
public class WebSocketConnectorImpl<CLIENT>
extends WebSocketConnectorBase<WebSocketConnectorImpl<CLIENT>>
implements WebSocketConnector<CLIENT> {
    private final WebSocketClientRecorder.ClientEndpoint clientEndpoint;

    WebSocketConnectorImpl(InjectionPoint injectionPoint, Codecs codecs, Vertx vertx, ClientConnectionManager connectionManager, WebSocketClientRecorder.ClientEndpointsContext endpointsContext, WebSocketsClientRuntimeConfig config, TlsConfigurationRegistry tlsConfigurationRegistry) {
        super(vertx, codecs, connectionManager, config, tlsConfigurationRegistry);
        this.clientEndpoint = Objects.requireNonNull(endpointsContext.endpoint(this.getEndpointClass(injectionPoint)));
        this.setPath(this.clientEndpoint.path);
    }

    @Override
    public Uni<WebSocketClientConnection> connect() {
        URI serverEndpointUri;
        WebSocketClient client = this.vertx.createWebSocketClient(this.populateClientOptions());
        StringBuilder serverEndpoint = new StringBuilder();
        if (this.baseUri != null) {
            serverEndpoint.append(this.baseUri.toString());
        } else {
            String key = this.clientEndpoint.clientId + ".base-uri";
            Optional maybeBaseUri = ConfigProvider.getConfig().getOptionalValue(key, String.class);
            if (maybeBaseUri.isEmpty()) {
                throw new WebSocketClientException("Unable to obtain the config value for: " + key);
            }
            serverEndpoint.append((String)maybeBaseUri.get());
        }
        serverEndpoint.append(this.replacePathParameters(this.clientEndpoint.path));
        try {
            serverEndpointUri = new URI(serverEndpoint.toString());
        }
        catch (URISyntaxException e) {
            throw new WebSocketClientException(e);
        }
        WebSocketConnectOptions connectOptions = new WebSocketConnectOptions().setSsl(Boolean.valueOf(serverEndpointUri.getScheme().equals("https"))).setHost(serverEndpointUri.getHost()).setPort(Integer.valueOf(serverEndpointUri.getPort()));
        StringBuilder uri = new StringBuilder();
        if (serverEndpointUri.getPath() != null) {
            uri.append(serverEndpointUri.getRawPath());
        }
        if (serverEndpointUri.getQuery() != null) {
            uri.append("?").append(serverEndpointUri.getQuery());
        }
        connectOptions.setURI(uri.toString());
        for (Map.Entry e : this.headers.entrySet()) {
            for (String val : (List)e.getValue()) {
                connectOptions.addHeader((String)e.getKey(), val);
            }
        }
        this.subprotocols.forEach(arg_0 -> ((WebSocketConnectOptions)connectOptions).addSubProtocol(arg_0));
        return UniHelper.toUni((Future)client.connect(connectOptions)).map(ws -> {
            TrafficLogger trafficLogger = TrafficLogger.forClient(this.config);
            WebSocketClientConnectionImpl connection = new WebSocketClientConnectionImpl(this.clientEndpoint.clientId, (WebSocket)ws, this.codecs, this.pathParams, serverEndpointUri, this.headers, trafficLogger);
            if (trafficLogger != null) {
                trafficLogger.connectionOpened(connection);
            }
            this.connectionManager.add(this.clientEndpoint.generatedEndpointClass, connection);
            Endpoints.initialize(this.vertx, Arc.container(), this.codecs, connection, (WebSocketBase)ws, this.clientEndpoint.generatedEndpointClass, this.config.autoPingInterval(), SecuritySupport.NOOP, this.config.unhandledFailureStrategy(), trafficLogger, () -> {
                this.connectionManager.remove(this.clientEndpoint.generatedEndpointClass, connection);
                client.close();
            });
            return connection;
        });
    }

    String getEndpointClass(InjectionPoint injectionPoint) {
        ParameterizedType parameterizedType = (ParameterizedType)injectionPoint.getType();
        return parameterizedType.getActualTypeArguments()[0].getTypeName();
    }
}

