/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next;

import io.quarkus.arc.Arc;
import io.quarkus.websockets.next.CloseReason;
import io.quarkus.websockets.next.WebSocketClientConnection;
import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.common.annotation.Experimental;
import io.smallrye.mutiny.Uni;
import io.vertx.core.buffer.Buffer;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@Experimental(value="This API is experimental and may change in the future")
public interface BasicWebSocketConnector {
    public static BasicWebSocketConnector create() {
        return (BasicWebSocketConnector)Arc.container().instance(BasicWebSocketConnector.class, new Annotation[0]).get();
    }

    public BasicWebSocketConnector baseUri(URI var1);

    public BasicWebSocketConnector path(String var1);

    public BasicWebSocketConnector pathParam(String var1, String var2);

    public BasicWebSocketConnector addHeader(String var1, String var2);

    public BasicWebSocketConnector addSubprotocol(String var1);

    public BasicWebSocketConnector executionModel(ExecutionModel var1);

    public BasicWebSocketConnector onOpen(Consumer<WebSocketClientConnection> var1);

    public BasicWebSocketConnector onTextMessage(BiConsumer<WebSocketClientConnection, String> var1);

    public BasicWebSocketConnector onBinaryMessage(BiConsumer<WebSocketClientConnection, Buffer> var1);

    public BasicWebSocketConnector onPong(BiConsumer<WebSocketClientConnection, Buffer> var1);

    public BasicWebSocketConnector onClose(BiConsumer<WebSocketClientConnection, CloseReason> var1);

    public BasicWebSocketConnector onError(BiConsumer<WebSocketClientConnection, Throwable> var1);

    @CheckReturnValue
    public Uni<WebSocketClientConnection> connect();

    default public WebSocketClientConnection connectAndAwait() {
        return (WebSocketClientConnection)this.connect().await().indefinitely();
    }

    public static enum ExecutionModel {
        BLOCKING,
        NON_BLOCKING,
        VIRTUAL_THREAD;

    }
}

