/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.websockets.next.OpenClientConnections;
import io.quarkus.websockets.next.WebSocketClientConnection;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

@Singleton
public class ClientConnectionManager
implements OpenClientConnections {
    private static final Logger LOG = Logger.getLogger(ClientConnectionManager.class);
    private final ConcurrentMap<String, Set<WebSocketClientConnection>> endpointToConnections = new ConcurrentHashMap<String, Set<WebSocketClientConnection>>();
    private final List<ClientConnectionListener> listeners = new CopyOnWriteArrayList<ClientConnectionListener>();

    @Override
    public Iterator<WebSocketClientConnection> iterator() {
        return this.stream().iterator();
    }

    @Override
    public Stream<WebSocketClientConnection> stream() {
        return this.endpointToConnections.values().stream().flatMap(Collection::stream).filter(WebSocketClientConnection::isOpen);
    }

    void add(String endpoint, WebSocketClientConnection connection) {
        LOG.debugf("Add client connection: %s", (Object)connection);
        if (this.endpointToConnections.computeIfAbsent(endpoint, e -> ConcurrentHashMap.newKeySet()).add(connection) && !this.listeners.isEmpty()) {
            for (ClientConnectionListener listener : this.listeners) {
                try {
                    listener.connectionAdded(endpoint, connection);
                }
                catch (Exception e2) {
                    LOG.warnf("Unable to call listener#connectionAdded() on [%s]: %s", listener.getClass(), (Object)e2.toString());
                }
            }
        }
    }

    void remove(String endpoint, WebSocketClientConnection connection) {
        LOG.debugf("Remove client connection: %s", (Object)connection);
        Set connections = (Set)this.endpointToConnections.get(endpoint);
        if (connections != null && connections.remove(connection) && !this.listeners.isEmpty()) {
            for (ClientConnectionListener listener : this.listeners) {
                try {
                    listener.connectionRemoved(endpoint, connection.id());
                }
                catch (Exception e) {
                    LOG.warnf("Unable to call listener#connectionRemoved() on [%s]: %s", listener.getClass(), (Object)e.toString());
                }
            }
        }
    }

    public Set<WebSocketClientConnection> getConnections(String endpoint) {
        Set ret = (Set)this.endpointToConnections.get(endpoint);
        if (ret == null) {
            return Set.of();
        }
        return ret;
    }

    public void addListener(ClientConnectionListener listener) {
        this.listeners.add(listener);
    }

    @PreDestroy
    void destroy() {
        this.endpointToConnections.clear();
    }

    public static interface ClientConnectionListener {
        public void connectionAdded(String var1, WebSocketClientConnection var2);

        public void connectionRemoved(String var1, String var2);
    }
}

