/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.quarkus.websockets.next.runtime.WebSocketConnectionBase;
import io.quarkus.websockets.next.runtime.WebSocketSessionContext;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import org.jboss.logging.Logger;

public class ContextSupport {
    private static final Logger LOG = Logger.getLogger(ContextSupport.class);
    static final String WEB_SOCKET_CONN_KEY = WebSocketConnectionBase.class.getName();
    private final WebSocketConnectionBase connection;
    private final WebSocketSessionContext.SessionContextState sessionContextState;
    private final WebSocketSessionContext sessionContext;
    private final ManagedContext requestContext;

    ContextSupport(WebSocketConnectionBase connection, WebSocketSessionContext.SessionContextState sessionContextState, WebSocketSessionContext sessionContext, ManagedContext requestContext) {
        this.connection = connection;
        this.sessionContextState = sessionContextState;
        this.sessionContext = sessionContext;
        this.requestContext = requestContext;
    }

    void start() {
        this.start(null);
    }

    void start(InjectableContext.ContextState requestContextState) {
        LOG.debugf("Start contexts: %s", (Object)this.connection);
        this.startSession();
        this.requestContext.activate(requestContextState);
    }

    void startSession() {
        this.sessionContext.activate(this.sessionContextState);
    }

    void end(boolean terminateSession) {
        this.end(true, terminateSession);
    }

    void end(boolean terminateRequest, boolean terminateSession) {
        LOG.debugf("End contexts: %s [terminateRequest: %s, terminateSession: %s]", (Object)this.connection, (Object)terminateRequest, (Object)terminateSession);
        if (terminateRequest) {
            this.requestContext.terminate();
        } else {
            this.requestContext.deactivate();
        }
        if (terminateSession) {
            this.endSession();
        } else {
            this.sessionContext.deactivate();
        }
    }

    void endSession() {
        this.sessionContext.terminate();
    }

    InjectableContext.ContextState currentRequestContextState() {
        return this.requestContext.getStateIfActive();
    }

    static Context createNewDuplicatedContext(Context context, WebSocketConnectionBase connection) {
        Context duplicated = VertxContext.createNewDuplicatedContext((Context)context);
        VertxContextSafetyToggle.setContextSafe((Context)duplicated, (boolean)true);
        duplicated.putLocal((Object)WEB_SOCKET_CONN_KEY, (Object)connection);
        LOG.debugf("New vertx duplicated context [%s] created: %s", (Object)duplicated, (Object)connection);
        return duplicated;
    }
}

