/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.vertx.utils.NoBoundChecksBuffer;
import io.quarkus.websockets.next.CloseReason;
import io.quarkus.websockets.next.HandshakeRequest;
import io.quarkus.websockets.next.WebSocketConnection;
import io.quarkus.websockets.next.runtime.Codecs;
import io.quarkus.websockets.next.runtime.TrafficLogger;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.buffer.impl.BufferImpl;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import org.jboss.logging.Logger;

public abstract class WebSocketConnectionBase {
    private static final Logger LOG = Logger.getLogger(WebSocketConnectionBase.class);
    protected final String identifier = UUID.randomUUID().toString();
    protected final Map<String, String> pathParams;
    protected final Codecs codecs;
    protected final HandshakeRequest handshakeRequest;
    protected final Instant creationTime;
    protected final TrafficLogger trafficLogger;

    WebSocketConnectionBase(Map<String, String> pathParams, Codecs codecs, HandshakeRequest handshakeRequest, TrafficLogger trafficLogger) {
        this.pathParams = pathParams;
        this.codecs = codecs;
        this.handshakeRequest = handshakeRequest;
        this.creationTime = Instant.now();
        this.trafficLogger = trafficLogger;
    }

    abstract WebSocketBase webSocket();

    public String id() {
        return this.identifier;
    }

    public String pathParam(String name) {
        return this.pathParams.get(name);
    }

    public Uni<Void> sendText(String message) {
        Uni uni = UniHelper.toUni((Future)this.webSocket().writeTextMessage(message));
        return this.trafficLogger == null ? uni : uni.invoke(() -> this.trafficLogger.textMessageSent(this, message));
    }

    public Uni<Void> sendBinary(Buffer message) {
        Uni uni = UniHelper.toUni((Future)this.webSocket().writeBinaryMessage(message));
        return this.trafficLogger == null ? uni : uni.invoke(() -> this.trafficLogger.binaryMessageSent(this, message));
    }

    public <M> Uni<Void> sendText(M message) {
        String text = message instanceof JsonObject || message instanceof JsonArray || message instanceof BufferImpl || message instanceof NoBoundChecksBuffer ? message.toString() : (message.getClass().isArray() && message.getClass().arrayType().equals(Byte.TYPE) ? Buffer.buffer((byte[])((byte[])message)).toString() : this.codecs.textEncode(message, null));
        return this.sendText((M)text);
    }

    public Uni<Void> sendPing(Buffer data) {
        return UniHelper.toUni((Future)this.webSocket().writePing(data));
    }

    void sendAutoPing() {
        this.webSocket().writePing(Buffer.buffer((String)"ping")).onComplete(r -> {
            if (r.failed()) {
                LOG.warnf("Unable to send auto-ping for %s: %s", (Object)this, (Object)r.cause().toString());
            }
        });
    }

    public Uni<Void> sendPong(Buffer data) {
        return UniHelper.toUni((Future)this.webSocket().writePong(data));
    }

    public Uni<Void> close() {
        return this.close(CloseReason.NORMAL);
    }

    public Uni<Void> close(CloseReason reason) {
        if (this.isClosed()) {
            LOG.warnf("Connection already closed: %s", (Object)this);
            return Uni.createFrom().voidItem();
        }
        return UniHelper.toUni((Future)this.webSocket().close((short)reason.getCode(), reason.getMessage()));
    }

    public boolean isSecure() {
        return this.webSocket().isSsl();
    }

    public boolean isClosed() {
        return this.webSocket().isClosed();
    }

    public HandshakeRequest handshakeRequest() {
        return this.handshakeRequest;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public WebSocketConnection.BroadcastSender broadcast() {
        throw new UnsupportedOperationException();
    }

    public CloseReason closeReason() {
        WebSocketBase ws = this.webSocket();
        if (ws.isClosed()) {
            return new CloseReason(ws.closeStatusCode().shortValue(), ws.closeReason());
        }
        return null;
    }
}

