/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.quarkus.websockets.next.WebSocketClientException;
import io.quarkus.websockets.next.WebSocketsClientRuntimeConfig;
import io.quarkus.websockets.next.runtime.ClientConnectionManager;
import io.quarkus.websockets.next.runtime.Codecs;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.WebSocketClientOptions;
import io.vertx.core.net.SSLOptions;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class WebSocketConnectorBase<THIS extends WebSocketConnectorBase<THIS>> {
    protected static final Pattern PATH_PARAM_PATTERN = Pattern.compile("\\{[a-zA-Z0-9_]+\\}");
    protected URI baseUri;
    protected final Map<String, String> pathParams;
    protected final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    protected final Set<String> subprotocols = new HashSet<String>();
    protected String path;
    protected Set<String> pathParamNames;
    protected final Vertx vertx;
    protected final Codecs codecs;
    protected final ClientConnectionManager connectionManager;
    protected final WebSocketsClientRuntimeConfig config;
    protected final TlsConfigurationRegistry tlsConfigurationRegistry;

    WebSocketConnectorBase(Vertx vertx, Codecs codecs, ClientConnectionManager connectionManager, WebSocketsClientRuntimeConfig config, TlsConfigurationRegistry tlsConfigurationRegistry) {
        this.pathParams = new HashMap<String, String>();
        this.vertx = vertx;
        this.codecs = codecs;
        this.connectionManager = connectionManager;
        this.config = config;
        this.tlsConfigurationRegistry = tlsConfigurationRegistry;
        this.path = "";
        this.pathParamNames = Set.of();
    }

    public THIS baseUri(URI baseUri) {
        this.baseUri = Objects.requireNonNull(baseUri);
        return this.self();
    }

    public THIS addHeader(String name, String value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        List<String> values = this.headers.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.headers.put(name, values);
        }
        values.add(value);
        return this.self();
    }

    public THIS pathParam(String name, String value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        if (!this.pathParamNames.contains(name)) {
            throw new IllegalArgumentException(String.format("[%s] is not a valid path parameter in the path %s", name, this.path));
        }
        this.pathParams.put(name, value);
        return this.self();
    }

    public THIS addSubprotocol(String value) {
        this.subprotocols.add(Objects.requireNonNull(value));
        return this.self();
    }

    void setPath(String path) {
        this.path = Objects.requireNonNull(path);
        this.pathParamNames = this.getPathParamNames(path);
    }

    protected THIS self() {
        return (THIS)this;
    }

    Set<String> getPathParamNames(String path) {
        HashSet<String> names = new HashSet<String>();
        Matcher m = PATH_PARAM_PATTERN.matcher(path);
        while (m.find()) {
            String match = m.group();
            String paramName = match.substring(1, match.length() - 1);
            names.add(paramName);
        }
        return names;
    }

    String replacePathParameters(String path) {
        StringBuilder sb = new StringBuilder();
        Matcher m = PATH_PARAM_PATTERN.matcher(path);
        while (m.find()) {
            String match = m.group();
            String paramName = match.substring(1, match.length() - 1);
            String val = this.pathParams.get(paramName);
            if (val == null) {
                throw new WebSocketClientException("Unable to obtain the path param for: " + paramName);
            }
            m.appendReplacement(sb, URLEncoder.encode(val, StandardCharsets.UTF_8));
        }
        m.appendTail(sb);
        return path.startsWith("/") ? sb.toString() : "/" + sb.toString();
    }

    protected WebSocketClientOptions populateClientOptions() {
        Optional maybeTlsConfiguration;
        WebSocketClientOptions clientOptions = new WebSocketClientOptions();
        if (this.config.offerPerMessageCompression()) {
            clientOptions.setTryUsePerMessageCompression(true);
            if (this.config.compressionLevel().isPresent()) {
                clientOptions.setCompressionLevel(this.config.compressionLevel().getAsInt());
            }
        }
        if (this.config.maxMessageSize().isPresent()) {
            clientOptions.setMaxMessageSize(this.config.maxMessageSize().getAsInt());
        }
        if ((maybeTlsConfiguration = TlsConfiguration.from((TlsConfigurationRegistry)this.tlsConfigurationRegistry, this.config.tlsConfigurationName())).isPresent()) {
            SSLOptions sslOptions;
            clientOptions.setSsl(true);
            TlsConfiguration tlsConfiguration = (TlsConfiguration)maybeTlsConfiguration.get();
            if (tlsConfiguration.getTrustStoreOptions() != null) {
                clientOptions.setTrustOptions(tlsConfiguration.getTrustStoreOptions());
            }
            if (tlsConfiguration.getKeyStoreOptions() != null) {
                clientOptions.setKeyCertOptions(tlsConfiguration.getKeyStoreOptions());
            }
            if (tlsConfiguration.isTrustAll()) {
                clientOptions.setTrustAll(true);
            }
            if (tlsConfiguration.getHostnameVerificationAlgorithm().isPresent() && ((String)tlsConfiguration.getHostnameVerificationAlgorithm().get()).equals("NONE")) {
                clientOptions.setVerifyHost(false);
            }
            if ((sslOptions = tlsConfiguration.getSSLOptions()) != null) {
                clientOptions.setSslHandshakeTimeout(sslOptions.getSslHandshakeTimeout());
                clientOptions.setSslHandshakeTimeoutUnit(sslOptions.getSslHandshakeTimeoutUnit());
                for (String suite : sslOptions.getEnabledCipherSuites()) {
                    clientOptions.addEnabledCipherSuite(suite);
                }
                for (Buffer buffer : sslOptions.getCrlValues()) {
                    clientOptions.addCrlValue(buffer);
                }
                clientOptions.setEnabledSecureTransportProtocols(sslOptions.getEnabledSecureTransportProtocols());
                clientOptions.setUseAlpn(sslOptions.isUseAlpn());
            }
        }
        return clientOptions;
    }
}

