/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.tls.TlsConfigurationRegistry;
import io.quarkus.virtual.threads.VirtualThreadsRecorder;
import io.quarkus.websockets.next.BasicWebSocketConnector;
import io.quarkus.websockets.next.CloseReason;
import io.quarkus.websockets.next.WebSocketClientConnection;
import io.quarkus.websockets.next.WebSocketClientException;
import io.quarkus.websockets.next.WebSocketsClientRuntimeConfig;
import io.quarkus.websockets.next.runtime.ClientConnectionManager;
import io.quarkus.websockets.next.runtime.Codecs;
import io.quarkus.websockets.next.runtime.ContextSupport;
import io.quarkus.websockets.next.runtime.TrafficLogger;
import io.quarkus.websockets.next.runtime.WebSocketClientConnectionImpl;
import io.quarkus.websockets.next.runtime.WebSocketConnectorBase;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.http.WebSocketConnectOptions;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Typed;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

@Typed(value={BasicWebSocketConnector.class})
@Dependent
public class BasicWebSocketConnectorImpl
extends WebSocketConnectorBase<BasicWebSocketConnectorImpl>
implements BasicWebSocketConnector {
    private static final Logger LOG = Logger.getLogger(BasicWebSocketConnectorImpl.class);
    private BasicWebSocketConnector.ExecutionModel executionModel = BasicWebSocketConnector.ExecutionModel.BLOCKING;
    private Consumer<WebSocketClientConnection> openHandler;
    private BiConsumer<WebSocketClientConnection, String> textMessageHandler;
    private BiConsumer<WebSocketClientConnection, Buffer> binaryMessageHandler;
    private BiConsumer<WebSocketClientConnection, Buffer> pongMessageHandler;
    private BiConsumer<WebSocketClientConnection, CloseReason> closeHandler;
    private BiConsumer<WebSocketClientConnection, Throwable> errorHandler;

    BasicWebSocketConnectorImpl(Vertx vertx, Codecs codecs, ClientConnectionManager connectionManager, WebSocketsClientRuntimeConfig config, TlsConfigurationRegistry tlsConfigurationRegistry) {
        super(vertx, codecs, connectionManager, config, tlsConfigurationRegistry);
    }

    @Override
    public BasicWebSocketConnector executionModel(BasicWebSocketConnector.ExecutionModel model) {
        this.executionModel = Objects.requireNonNull(model);
        return (BasicWebSocketConnector)this.self();
    }

    @Override
    public BasicWebSocketConnector path(String path) {
        this.setPath(Objects.requireNonNull(path));
        return (BasicWebSocketConnector)this.self();
    }

    @Override
    public BasicWebSocketConnector onOpen(Consumer<WebSocketClientConnection> consumer) {
        this.openHandler = Objects.requireNonNull(consumer);
        return (BasicWebSocketConnector)this.self();
    }

    @Override
    public BasicWebSocketConnector onTextMessage(BiConsumer<WebSocketClientConnection, String> consumer) {
        this.textMessageHandler = Objects.requireNonNull(consumer);
        return (BasicWebSocketConnector)this.self();
    }

    @Override
    public BasicWebSocketConnector onBinaryMessage(BiConsumer<WebSocketClientConnection, Buffer> consumer) {
        this.binaryMessageHandler = Objects.requireNonNull(consumer);
        return (BasicWebSocketConnector)this.self();
    }

    @Override
    public BasicWebSocketConnector onPong(BiConsumer<WebSocketClientConnection, Buffer> consumer) {
        this.pongMessageHandler = Objects.requireNonNull(consumer);
        return (BasicWebSocketConnector)this.self();
    }

    @Override
    public BasicWebSocketConnector onClose(BiConsumer<WebSocketClientConnection, CloseReason> consumer) {
        this.closeHandler = Objects.requireNonNull(consumer);
        return (BasicWebSocketConnector)this.self();
    }

    @Override
    public BasicWebSocketConnector onError(BiConsumer<WebSocketClientConnection, Throwable> consumer) {
        this.errorHandler = Objects.requireNonNull(consumer);
        return (BasicWebSocketConnector)this.self();
    }

    @Override
    public Uni<WebSocketClientConnection> connect() {
        URI serverEndpointUri;
        if (this.baseUri == null) {
            throw new WebSocketClientException("Endpoint URI not set!");
        }
        final WebSocketClient client = this.vertx.createWebSocketClient(this.populateClientOptions());
        WebSocketConnectOptions connectOptions = this.newConnectOptions(this.baseUri);
        StringBuilder requestUri = new StringBuilder();
        String mergedPath = this.mergePath(this.baseUri.getPath(), this.replacePathParameters(this.path));
        requestUri.append(mergedPath);
        if (this.baseUri.getQuery() != null) {
            requestUri.append("?").append(this.baseUri.getQuery());
        }
        connectOptions.setURI(requestUri.toString());
        for (Map.Entry e : this.headers.entrySet()) {
            for (String val : (List)e.getValue()) {
                connectOptions.addHeader((String)e.getKey(), val);
            }
        }
        this.subprotocols.forEach(arg_0 -> ((WebSocketConnectOptions)connectOptions).addSubProtocol(arg_0));
        try {
            serverEndpointUri = new URI(this.baseUri.getScheme(), this.baseUri.getUserInfo(), this.baseUri.getHost(), this.baseUri.getPort(), mergedPath, this.baseUri.getQuery(), this.baseUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new WebSocketClientException(e);
        }
        return Uni.createFrom().completionStage(() -> client.connect(connectOptions).toCompletionStage()).map(ws -> {
            String clientId = BasicWebSocketConnector.class.getName();
            final TrafficLogger trafficLogger = TrafficLogger.forClient(this.config);
            final WebSocketClientConnectionImpl connection = new WebSocketClientConnectionImpl(clientId, (WebSocket)ws, this.codecs, this.pathParams, serverEndpointUri, this.headers, trafficLogger);
            if (trafficLogger != null) {
                trafficLogger.connectionOpened(connection);
            }
            this.connectionManager.add(BasicWebSocketConnectorImpl.class.getName(), connection);
            if (this.openHandler != null) {
                this.doExecute(connection, null, (c, ignored) -> this.openHandler.accept((WebSocketClientConnection)c));
            }
            if (this.textMessageHandler != null) {
                ws.textMessageHandler((Handler)new Handler<String>(){

                    public void handle(String message) {
                        if (trafficLogger != null) {
                            trafficLogger.textMessageReceived(connection, message);
                        }
                        BasicWebSocketConnectorImpl.this.doExecute(connection, message, BasicWebSocketConnectorImpl.this.textMessageHandler);
                    }
                });
            }
            if (this.binaryMessageHandler != null) {
                ws.binaryMessageHandler((Handler)new Handler<Buffer>(){

                    public void handle(Buffer message) {
                        if (trafficLogger != null) {
                            trafficLogger.binaryMessageReceived(connection, message);
                        }
                        BasicWebSocketConnectorImpl.this.doExecute(connection, message, BasicWebSocketConnectorImpl.this.binaryMessageHandler);
                    }
                });
            }
            if (this.pongMessageHandler != null) {
                ws.pongHandler((Handler)new Handler<Buffer>(){

                    public void handle(Buffer event) {
                        BasicWebSocketConnectorImpl.this.doExecute(connection, event, BasicWebSocketConnectorImpl.this.pongMessageHandler);
                    }
                });
            }
            if (this.errorHandler != null) {
                ws.exceptionHandler((Handler)new Handler<Throwable>(){

                    public void handle(Throwable event) {
                        BasicWebSocketConnectorImpl.this.doExecute(connection, event, BasicWebSocketConnectorImpl.this.errorHandler);
                    }
                });
            }
            ws.closeHandler((Handler)new Handler<Void>(){

                public void handle(Void event) {
                    if (trafficLogger != null) {
                        trafficLogger.connectionClosed(connection);
                    }
                    if (BasicWebSocketConnectorImpl.this.closeHandler != null) {
                        BasicWebSocketConnectorImpl.this.doExecute(connection, new CloseReason(ws.closeStatusCode().shortValue(), ws.closeReason()), BasicWebSocketConnectorImpl.this.closeHandler);
                    }
                    BasicWebSocketConnectorImpl.this.connectionManager.remove(BasicWebSocketConnectorImpl.class.getName(), connection);
                    client.close();
                }
            });
            return connection;
        });
    }

    private <MESSAGE> void doExecute(final WebSocketClientConnectionImpl connection, final MESSAGE message, final BiConsumer<WebSocketClientConnection, MESSAGE> consumer) {
        Context context = this.vertx.getOrCreateContext();
        ContextSupport.createNewDuplicatedContext(context, connection).runOnContext((Handler)new Handler<Void>(){

            public void handle(Void event) {
                if (BasicWebSocketConnectorImpl.this.executionModel == BasicWebSocketConnector.ExecutionModel.VIRTUAL_THREAD) {
                    VirtualThreadsRecorder.getCurrent().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                consumer.accept(connection, message);
                            }
                            catch (Exception e) {
                                LOG.errorf((Throwable)e, "Unable to call handler: " + connection, new Object[0]);
                            }
                        }
                    });
                } else if (BasicWebSocketConnectorImpl.this.executionModel == BasicWebSocketConnector.ExecutionModel.BLOCKING) {
                    BasicWebSocketConnectorImpl.this.vertx.executeBlocking((Callable)new Callable<Void>(){

                        @Override
                        public Void call() {
                            try {
                                consumer.accept(connection, message);
                            }
                            catch (Exception e) {
                                LOG.errorf((Throwable)e, "Unable to call handler: " + connection, new Object[0]);
                            }
                            return null;
                        }
                    }, false);
                } else {
                    try {
                        consumer.accept(connection, message);
                    }
                    catch (Exception e) {
                        LOG.errorf((Throwable)e, "Unable to call handler: " + connection, new Object[0]);
                    }
                }
            }
        });
    }

    private String mergePath(String path1, String path2) {
        StringBuilder ret = new StringBuilder();
        if (path1 != null) {
            ret.append(path1);
        }
        if (path2 != null) {
            if (path1.endsWith("/")) {
                if (path2.startsWith("/")) {
                    ret.append(path2.substring(1));
                } else {
                    ret.append(path2);
                }
            } else if (path2.startsWith("/")) {
                ret.append(path2);
            } else {
                ret.append("/").append(path2);
            }
        }
        return ret.toString();
    }
}

