/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.websockets.next.HttpUpgradeCheck;
import io.smallrye.mutiny.Uni;
import java.util.List;
import java.util.Map;

public class SecurityHttpUpgradeCheck
implements HttpUpgradeCheck {
    public static final int BEAN_PRIORITY = 2147483547;
    private final String redirectUrl;
    private final Map<String, SecurityCheck> endpointToCheck;

    SecurityHttpUpgradeCheck(String redirectUrl, Map<String, SecurityCheck> endpointToCheck) {
        this.redirectUrl = redirectUrl;
        this.endpointToCheck = Map.copyOf(endpointToCheck);
    }

    @Override
    public Uni<HttpUpgradeCheck.CheckResult> perform(HttpUpgradeCheck.HttpUpgradeContext context) {
        return this.endpointToCheck.get(context.endpointId()).nonBlockingApply(context.securityIdentity(), (MethodDescription)null, null).replaceWith(HttpUpgradeCheck.CheckResult::permitUpgradeSync).onFailure(SecurityException.class).recoverWithItem(this::rejectUpgrade);
    }

    @Override
    public boolean appliesTo(String endpointId) {
        return this.endpointToCheck.containsKey(endpointId);
    }

    private HttpUpgradeCheck.CheckResult rejectUpgrade(Throwable throwable) {
        if (this.redirectUrl != null) {
            return HttpUpgradeCheck.CheckResult.rejectUpgradeSync(302, Map.of(HttpHeaderNames.LOCATION.toString(), List.of(this.redirectUrl), HttpHeaderNames.CACHE_CONTROL.toString(), List.of("no-store")));
        }
        if (throwable instanceof ForbiddenException) {
            return HttpUpgradeCheck.CheckResult.rejectUpgradeSync(403);
        }
        return HttpUpgradeCheck.CheckResult.rejectUpgradeSync(401);
    }
}

